package work.wangjw.util;

import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

/**
 * @author wjw
 * @since 2021/5/24 13:48
 **/
public class ListUtil {
    /**
     * 是否为空
     *
     * @param list 检测对象
     * @return 结果
     */
    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    /**
     * 是否不为空
     *
     * @param list 检测对象
     * @return 结果
     */
    public static boolean isNotEmpty(List<?> list) {
        return !isEmpty(list);
    }

    /**
     * 复制List
     *
     * @param source 被复制对象
     * @param target 目标Class
     * @return 复制对象
     */
    public static <S, T> List<T> copy(List<S> source, Class<T> target) {
        List<T> result = new ArrayList<>();
        if (isNotEmpty(source)) {
            try {
                for (S s : source) {
                    T t = target.newInstance();
                    BeanUtils.copyProperties(s, t);
                    result.add(t);
                }
            } catch (InstantiationException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /**
     * 通过连接符转化为string
     *
     * @param list      被转化对象
     * @param jointChar 连接符
     * @return 结果
     */
    public static String convertToString(List<?> list, String jointChar) {
        if (isEmpty(list)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); i++) {
            stringBuilder.append(list.get(i));
            if (i != list.size() - 1) {
                stringBuilder.append(jointChar);
            }
        }
        return stringBuilder.toString();
    }

    /**
     * 通过连接符转化为string
     *
     * @param array     被转化对象
     * @param jointChar 连接符
     * @return 结果
     */
    public static String convertToString(Object[] array, String jointChar) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < array.length; i++) {
            stringBuilder.append(array[i]);
            if (i != array.length - 1) {
                stringBuilder.append(jointChar);
            }
        }
        return stringBuilder.toString();
    }

    /**
     * list转为数组
     *
     * @param list list
     * @return array
     */
    public static String[] convertListToArray(List<String> list) {
        if (isEmpty(list)) {
            return null;
        }
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            array[i] = list.get(i);
        }
        return array;
    }

    /**
     * 去重
     */
    public static <T> List<T> distinct(List<T> list) {
        HashSet<T> set = new HashSet<>(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> newList(T... ts) {
        return new ArrayList<>(Arrays.asList(ts));
    }
}
