package work.wangjw.util;

import org.springframework.beans.BeanUtils;

import java.util.Objects;

/**
 * @author Gavin
 * @since 2021/7/19 15:14
 **/
public class ObjUtil {

    public static <S, T> T copy(S source, Class<T> target) {
        T t = null;
        try {
            t = target.newInstance();
            BeanUtils.copyProperties(source, t);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /**
     * 是否为null
     *
     * @param obj 目标值
     * @return 结果
     */
    public static Boolean isNull(Object obj) {
        return obj == null;
    }

    /**
     * 是否不为null
     *
     * @param obj 目标值
     * @return 结果
     */
    public static Boolean isNotNull(Object obj) {
        return obj != null;
    }
}
