package work.wangjw.util;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.BeanUtils;
import work.wangjw.bean.BasePage;

import java.util.List;
import java.util.Objects;

/**
 * @author wjw
 * @since 2021/5/21 17:33
 **/
public class PageUtil<T> {
    /**
     * 默认页数
     */
    private static final int DEFAULT_CURRENT = 1;
    /**
     * 默认每页大小
     */
    private static final int DEFAULT_SIZE = 10;

    /**
     * 获取page对象，并规范current和size
     *
     * @param current 当前页
     * @param size    每页大小
     * @return page对象
     */
    public static <T> Page<T> getPage(Integer current, Integer size) {
        if (Objects.isNull(current) || current < 1) {
            current = DEFAULT_CURRENT;
        }
        if (Objects.isNull(size) || size < 1) {
            size = DEFAULT_SIZE;
        }
        return new Page<>(current, size);
    }

    public static <T> Page<T> getPage(BasePage basePage) {
        return getPage(basePage.getCurrent(),basePage.getSize());
    }

    /**
     * 转换分页对象
     *
     * @param source 原始分页对象
     * @param target 目标Class
     * @return page对象
     */
    public static <S, T> Page<T> copy(Page<S> source, Class<T> target) {
        Page<T> result = new Page<>();
        BeanUtils.copyProperties(source, result);
        result.setRecords(ListUtil.copy(source.getRecords(), target));
        return result;
    }

    /**
     * list手动转page
     * @param list list
     * @param current 当前页
     * @param size 每页大小
     * @return page
     */
    public static <T> Page<T> listToPage(List<T> list, Integer current, Integer size) {
        if (Objects.isNull(current) || current < 1) {
            current = DEFAULT_CURRENT;
        }
        if (Objects.isNull(size) || size < 1) {
            size = DEFAULT_SIZE;
        }
        int count = list.size();
        int start = (current - 1) * size;
        int end = Math.min(current * size, count);
        List<T> pageList = list.subList(start, end);
        Page<T> page = new Page<>();
        page.setTotal(count).setCurrent(current).setSize(size).setRecords(pageList)
                .setPages(count % size == 0 ? count / size : count / size + 1);
        return page;
    }
}
