package work.wangjw.util.bean;

/**
 * @author Gavin
 * @since 2021/8/5 17:18
 */
public class SnowFlake {
    private final long workerId;
    private long sequence;

    private final Integer workerIdBits = 10;
    private final Integer sequenceBits = 12;

    private final Integer maxWorkerId = ~(-1 << workerIdBits);
    private final Integer maxSequence = ~(-1 << sequenceBits);

    private long lastTimestamp = 0;

    public SnowFlake(long workerId, long sequence) {
        if (workerId < 0 || workerId > maxWorkerId) {
            throw new IllegalArgumentException("workerId不合法");
        }
        if (sequence < 0 || sequence > maxSequence) {
            throw new IllegalArgumentException("sequence不合法");
        }
        this.workerId = workerId;
        this.sequence = sequence;
    }

    public SnowFlake(long workerId) {
        if (workerId < 0 || workerId > maxWorkerId) {
            throw new IllegalArgumentException("workerId不合法");
        }
        this.workerId = workerId;
        this.sequence = 0;
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException("时钟出现错误");
        }
        if (timestamp == lastTimestamp) {
            sequence = (sequence + 1) & (maxSequence);
            if (sequence == 0) {
                timestamp = nextMillis(lastTimestamp);
            }
        } else {
            sequence = 0;
        }
        lastTimestamp = timestamp;
        return (timestamp << (workerIdBits + sequenceBits)) | (workerId << sequenceBits) | sequence;
    }

    private long nextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}
