/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.aop;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import work.wangjw.util.IPUtil;

@Aspect
public class GlobalAspect {
    private static final Logger log = LoggerFactory.getLogger(GlobalAspect.class);

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.GetMapping)")
    public void executionServiceByGet() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void executionServiceByPost() {
    }

    @Pointcut(value="executionServiceByGet() || executionServiceByPost()")
    public void executionService() {
    }

    @Around(value="executionService()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        log.info("========================================== Start ==========================================");
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        String reqUrl = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() != 0) {
            queryString = URLDecoder.decode(queryString, "UTF-8");
            reqUrl = reqUrl + "?" + queryString;
        }
        log.info("URL            : {}", (Object)reqUrl);
        log.info("HTTP Method    : {}", (Object)request.getMethod());
        log.info("Class Method   : {}.{}", (Object)joinPoint.getSignature().getDeclaringTypeName(), (Object)joinPoint.getSignature().getName());
        log.info("IP             : {}", (Object)IPUtil.getIpAddr());
        Object[] args = joinPoint.getArgs();
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (null != args && args.length > 0) {
            for (Object obj : args) {
                if (obj instanceof HttpServletRequest || obj instanceof HttpServletResponse || obj instanceof MultipartFile) continue;
                paramList.add(obj);
            }
        }
        log.info("Request Args   : {}", paramList);
        Date startTime = new Date();
        Object proceed = joinPoint.proceed();
        Date endTime = new Date();
        log.info("Time-Consuming : {} ms", (Object)(endTime.getTime() - startTime.getTime()));
        log.info("========================================== end ============================================");
        return proceed;
    }
}

