/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.aop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.regex.Pattern;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import work.wangjw.annotation.valid.Digits;
import work.wangjw.annotation.valid.Email;
import work.wangjw.annotation.valid.NotNull;
import work.wangjw.annotation.valid.Phone;
import work.wangjw.annotation.valid.Regular;
import work.wangjw.annotation.valid.Size;
import work.wangjw.annotation.valid.Valid;
import work.wangjw.exception.WjwException;
import work.wangjw.util.ObjUtil;
import work.wangjw.util.StrUtil;

@Aspect
public class ValidAspect {
    private static final Logger log = LoggerFactory.getLogger(ValidAspect.class);

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.GetMapping)")
    public void executionServiceByGet() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void executionServiceByPost() {
    }

    @Pointcut(value="executionServiceByGet() || executionServiceByPost()")
    public void executionService() {
    }

    @Around(value="executionService()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        boolean isError = false;
        StringBuilder message = new StringBuilder();
        for (Object obj : args) {
            Valid valid;
            if (ObjUtil.isNull(obj).booleanValue() || (valid = obj.getClass().getAnnotation(Valid.class)) == null) continue;
            for (Field field : obj.getClass().getDeclaredFields()) {
                Regular regular;
                Phone phone;
                Email email;
                Size size;
                Digits digits;
                char[] chars = field.getName().toCharArray();
                chars[0] = (char)(chars[0] - 32);
                String methodName = "get" + String.valueOf(chars);
                Method method = obj.getClass().getMethod(methodName, new Class[0]);
                Object value = method.invoke(obj, new Object[0]);
                NotNull notNull = field.getAnnotation(NotNull.class);
                if (Objects.nonNull(notNull) && Objects.isNull(value)) {
                    message.append(isError ? "," : "").append(StrUtil.isEmpty(notNull.message()) ? field.getName() + "\u4e0d\u80fd\u4e3anull" : notNull.message());
                    isError = true;
                }
                if (Objects.nonNull(digits = field.getAnnotation(Digits.class))) {
                    if (Objects.isNull(value)) {
                        throw new WjwException(field.getName() + "\u4e0d\u80fd\u4e3anull");
                    }
                    if (!(value instanceof Number)) {
                        throw new RuntimeException("\u6ce8\u89e3Digits\u53ea\u80fd\u653e\u5728\u6570\u5b57(Number\u5b50\u7c7b)\u7c7b\u578b\u5b57\u6bb5\u4e0a");
                    }
                    Number number = (Number)value;
                    if ((double)digits.max() < number.doubleValue()) {
                        message.append(isError ? "," : "").append(StrUtil.isEmpty(digits.message()) ? field.getName() + "\u4e0d\u80fd\u5927\u4e8e" + digits.max() : digits.message());
                        isError = true;
                    }
                    if ((double)digits.min() > number.doubleValue()) {
                        message.append(isError ? "," : "").append(StrUtil.isEmpty(digits.message()) ? field.getName() + "\u4e0d\u80fd\u5c0f\u4e8e" + digits.min() : digits.message());
                        isError = true;
                    }
                }
                if (Objects.nonNull(size = field.getAnnotation(Size.class))) {
                    if (Objects.isNull(value)) {
                        throw new WjwException(field.getName() + "\u4e0d\u80fd\u4e3anull");
                    }
                    if (!(value instanceof String)) {
                        throw new RuntimeException("\u6ce8\u89e3Size\u53ea\u80fd\u653e\u5728String\u7c7b\u578b\u5b57\u6bb5\u4e0a");
                    }
                    String string = (String)value;
                    if (size.max() < string.length()) {
                        message.append(isError ? "," : "").append(StrUtil.isEmpty(size.message()) ? field.getName() + "\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + size.max() : size.message());
                        isError = true;
                    }
                    if (size.min() > string.length()) {
                        message.append(isError ? "," : "").append(StrUtil.isEmpty(size.message()) ? field.getName() + "\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + size.min() : size.message());
                        isError = true;
                    }
                }
                if (Objects.nonNull(email = field.getAnnotation(Email.class))) {
                    if (Objects.isNull(value)) {
                        throw new WjwException(field.getName() + "\u4e0d\u80fd\u4e3anull");
                    }
                    if (!(value instanceof String)) {
                        throw new RuntimeException("\u6ce8\u89e3Email\u53ea\u80fd\u653e\u5728String\u7c7b\u578b\u5b57\u6bb5\u4e0a");
                    }
                    String string = (String)value;
                    boolean matches = Pattern.matches("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$", string);
                    if (!matches) {
                        message.append(isError ? "," : "").append(StrUtil.isEmpty(email.message()) ? field.getName() + "\u4e0d\u662f\u90ae\u7bb1\u683c\u5f0f" : email.message());
                        isError = true;
                    }
                }
                if (Objects.nonNull(phone = field.getAnnotation(Phone.class))) {
                    if (Objects.isNull(value)) {
                        throw new WjwException(field.getName() + "\u4e0d\u80fd\u4e3anull");
                    }
                    String string = value.toString();
                    boolean matches = Pattern.matches("^1[34578]\\d{9}$", string);
                    if (!matches) {
                        message.append(isError ? "," : "").append(StrUtil.isEmpty(phone.message()) ? field.getName() + "\u4e0d\u662f\u624b\u673a\u53f7\u683c\u5f0f" : phone.message());
                        isError = true;
                    }
                }
                if (!Objects.nonNull(regular = field.getAnnotation(Regular.class))) continue;
                if (!(value instanceof String)) {
                    throw new RuntimeException("\u6ce8\u89e3Regular\u53ea\u80fd\u653e\u5728String\u7c7b\u578b\u5b57\u6bb5\u4e0a");
                }
                String string = (String)value;
                boolean matches = Pattern.matches(regular.value(), string);
                if (matches) continue;
                message.append(isError ? "," : "").append(StrUtil.isEmpty(regular.message()) ? field.getName() + "\u4e0d\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f" : regular.message());
                isError = true;
            }
        }
        if (isError) {
            throw new WjwException(message.toString());
        }
        return joinPoint.proceed();
    }
}

