/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.interceptor;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import work.wangjw.annotation.LimitRate;
import work.wangjw.exception.WjwException;
import work.wangjw.util.IPUtil;
import work.wangjw.util.RedisUtil;

public class LimitRateInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LimitRateInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        LimitRate limitRate = (LimitRate)handlerMethod.getMethodAnnotation(LimitRate.class);
        if (Objects.isNull(limitRate)) {
            limitRate = handlerMethod.getBeanType().getAnnotation(LimitRate.class);
        }
        if (Objects.nonNull(limitRate)) {
            String ip = IPUtil.getIpAddr();
            log.info("ip\u4e3a:{}", (Object)ip);
            if (Objects.nonNull(RedisUtil.get(ip + handlerMethod.getMethod().getName()))) {
                throw new WjwException(limitRate.message());
            }
            RedisUtil.set(ip + handlerMethod.getMethod().getName(), 1, limitRate.value());
        }
        return true;
    }
}

