/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static Date now() {
        return new Date();
    }

    public static Date date() {
        return new Date();
    }

    public static Date date(long timestamp) {
        return new Date(timestamp);
    }

    public static Date toDate(String dateStr) {
        return DateUtil.toDate(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date toDate(String dateStr, String format) {
        Date parseDate;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            parseDate = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
        }
        return parseDate;
    }

    public static String toString(Date date) {
        return DateUtil.toString(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String toString(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date beginOfDay(Date date) {
        Calendar beginOfDay = Calendar.getInstance();
        beginOfDay.setTime(date);
        beginOfDay.set(11, 0);
        beginOfDay.set(12, 0);
        beginOfDay.set(13, 0);
        beginOfDay.set(14, 0);
        return beginOfDay.getTime();
    }

    public static Date beginOfMonth(Date date) {
        Calendar beginOfMonth = Calendar.getInstance();
        beginOfMonth.setTime(date);
        beginOfMonth.set(5, 1);
        beginOfMonth.set(11, 0);
        beginOfMonth.set(12, 0);
        beginOfMonth.set(13, 0);
        beginOfMonth.set(14, 0);
        return beginOfMonth.getTime();
    }

    public static Date beginOfYear(Date date) {
        Calendar beginOfYear = Calendar.getInstance();
        beginOfYear.setTime(date);
        beginOfYear.set(2, 0);
        beginOfYear.set(5, 1);
        beginOfYear.set(11, 0);
        beginOfYear.set(12, 0);
        beginOfYear.set(13, 0);
        beginOfYear.set(14, 0);
        return beginOfYear.getTime();
    }

    public static Date endOfDay(Date date) {
        Calendar endOfDay = Calendar.getInstance();
        endOfDay.setTime(DateUtil.beginOfDay(date));
        endOfDay.add(5, 1);
        endOfDay.add(14, -1);
        return endOfDay.getTime();
    }

    public static Date endOfMonth(Date date) {
        Calendar endOfMonth = Calendar.getInstance();
        endOfMonth.setTime(DateUtil.beginOfMonth(date));
        endOfMonth.add(2, 1);
        endOfMonth.add(14, -1);
        return endOfMonth.getTime();
    }

    public static Date endOfYear(Date date) {
        Calendar endOfYear = Calendar.getInstance();
        endOfYear.setTime(DateUtil.beginOfYear(date));
        endOfYear.add(1, 1);
        endOfYear.add(14, -1);
        return endOfYear.getTime();
    }

    public static int year(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int month(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int day(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Date yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date lastWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(4, -1);
        return calendar.getTime();
    }

    public static Date nextWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(4, 1);
        return calendar.getTime();
    }

    public static Date lastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static Date nextMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date offset(Date date, int dateField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(dateField, amount);
        return calendar.getTime();
    }

    public static long between(Date startDate, Date endDate, int dateFiled) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        long between = Math.abs(endTime - startTime);
        System.out.println(between);
        long field = dateFiled == 1 ? 31536000000L : (dateFiled == 2 ? 1036800000L : (dateFiled == 5 ? 86400000L : (dateFiled == 10 ? 3600000L : (dateFiled == 12 ? 60000L : (dateFiled == 13 ? 1000L : 1L)))));
        return between / field;
    }

    public static int compare(Date date1, Date date2) {
        if (date1.getTime() - date2.getTime() > 0L) {
            return 1;
        }
        if (date1.getTime() - date2.getTime() < 0L) {
            return -1;
        }
        return 0;
    }
}

