/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.BeanUtils;

public class ListUtil {
    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNotEmpty(List<?> list) {
        return !ListUtil.isEmpty(list);
    }

    public static <S, T> List<T> copy(List<S> source, Class<T> target) {
        ArrayList<T> result = new ArrayList<T>();
        if (ListUtil.isNotEmpty(source)) {
            try {
                for (S s : source) {
                    T t = target.newInstance();
                    BeanUtils.copyProperties(s, t);
                    result.add(t);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String convertToString(List<?> list, String jointChar) {
        if (ListUtil.isEmpty(list)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i == list.size() - 1) continue;
            stringBuilder.append(jointChar);
        }
        return stringBuilder.toString();
    }

    public static String convertToString(Object[] array, String jointChar) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            stringBuilder.append(array[i]);
            if (i == array.length - 1) continue;
            stringBuilder.append(jointChar);
        }
        return stringBuilder.toString();
    }

    public static String[] convertListToArray(List<String> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static <T> List<T> distinct(List<T> list) {
        HashSet<T> set = new HashSet<T>(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> newList(T ... ts) {
        return new ArrayList<T>(Arrays.asList(ts));
    }
}

