/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import work.wangjw.bean.BasePage;
import work.wangjw.util.ListUtil;

public class PageUtil<T> {
    private static final int DEFAULT_CURRENT = 1;
    private static final int DEFAULT_SIZE = 10;

    public static <T> Page<T> getPage(Integer current, Integer size) {
        if (Objects.isNull(current) || current < 1) {
            current = 1;
        }
        if (Objects.isNull(size) || size < 1) {
            size = 10;
        }
        return new Page((long)current.intValue(), (long)size.intValue());
    }

    public static <T> Page<T> getPage(BasePage basePage) {
        return PageUtil.getPage(basePage.getCurrent(), basePage.getSize());
    }

    public static <S, T> Page<T> copy(Page<S> source, Class<T> target) {
        Page result = new Page();
        BeanUtils.copyProperties(source, (Object)result);
        result.setRecords(ListUtil.copy(source.getRecords(), target));
        return result;
    }

    public static <T> Page<T> listToPage(List<T> list, Integer current, Integer size) {
        if (Objects.isNull(current) || current < 1) {
            current = 1;
        }
        if (Objects.isNull(size) || size < 1) {
            size = 10;
        }
        int count = list.size();
        int start = (current - 1) * size;
        int end = Math.min(current * size, count);
        List<T> pageList = list.subList(start, end);
        Page page = new Page();
        page.setTotal((long)count).setCurrent((long)current.intValue()).setSize((long)size.intValue()).setRecords(pageList).setPages(count % size == 0 ? (long)(count / size) : (long)(count / size + 1));
        return page;
    }
}

