/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisUtil {
    private static RedisTemplate<String, Object> objectRedisTemplate;

    @Resource
    public void setObjectRedisTemplate(RedisTemplate<String, Object> objectRedisTemplate) {
        RedisUtil.objectRedisTemplate = objectRedisTemplate;
    }

    public static boolean expire(String key, long timeout) {
        return RedisUtil.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static boolean expire(String key, long timeout, TimeUnit unit) {
        Boolean ret = objectRedisTemplate.expire((Object)key, timeout, unit);
        return ret != null && ret != false;
    }

    public static boolean del(String key) {
        Boolean ret = objectRedisTemplate.delete((Object)key);
        return ret != null && ret != false;
    }

    public static long del(Collection<String> keys) {
        Long ret = objectRedisTemplate.delete(keys);
        return ret == null ? 0L : ret;
    }

    public static void set(String key, Object value) {
        objectRedisTemplate.opsForValue().set((Object)key, value);
    }

    public static void set(String key, Object value, long timeout) {
        objectRedisTemplate.opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
    }

    public static long increment(String key, long number) {
        return objectRedisTemplate.opsForValue().increment((Object)key, number);
    }

    public static Object get(String key) {
        return objectRedisTemplate.opsForValue().get((Object)key);
    }

    public static void hPut(String key, String hKey, Object value) {
        objectRedisTemplate.opsForHash().put((Object)key, (Object)hKey, value);
    }

    public static void hPutAll(String key, Map<String, Object> values) {
        objectRedisTemplate.opsForHash().putAll((Object)key, values);
    }

    public static Object hGet(String key, String hKey) {
        return objectRedisTemplate.opsForHash().get((Object)key, (Object)hKey);
    }

    public static List<Object> hMultiGet(String key, Collection<Object> hKeys) {
        return objectRedisTemplate.opsForHash().multiGet((Object)key, hKeys);
    }

    public static long sSet(String key, Object ... values) {
        Long count = objectRedisTemplate.opsForSet().add((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long sDel(String key, Object ... values) {
        Long count = objectRedisTemplate.opsForSet().remove((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long lPush(String key, Object value) {
        Long count = objectRedisTemplate.opsForList().rightPush((Object)key, value);
        return count == null ? 0L : count;
    }

    public static long lPushAll(String key, Collection<Object> values) {
        Long count = objectRedisTemplate.opsForList().rightPushAll((Object)key, values);
        return count == null ? 0L : count;
    }

    public static long lPushAll(String key, Object ... values) {
        Long count = objectRedisTemplate.opsForList().rightPushAll((Object)key, values);
        return count == null ? 0L : count;
    }

    public static List<Object> lGet(String key, int start, int end) {
        return objectRedisTemplate.opsForList().range((Object)key, (long)start, (long)end);
    }
}

