/*
 * Decompiled with CFR 0.152.
 */
package work.wangjw.util.bean;

public class SnowFlake {
    private final long workerId;
    private long sequence;
    private final Integer workerIdBits = 10;
    private final Integer sequenceBits = 12;
    private final Integer maxWorkerId = ~(-1 << this.workerIdBits);
    private final Integer maxSequence = ~(-1 << this.sequenceBits);
    private long lastTimestamp = 0L;

    public SnowFlake(long workerId, long sequence) {
        if (workerId < 0L || workerId > (long)this.maxWorkerId.intValue()) {
            throw new IllegalArgumentException("workerId\u4e0d\u5408\u6cd5");
        }
        if (sequence < 0L || sequence > (long)this.maxSequence.intValue()) {
            throw new IllegalArgumentException("sequence\u4e0d\u5408\u6cd5");
        }
        this.workerId = workerId;
        this.sequence = sequence;
    }

    public SnowFlake(long workerId) {
        if (workerId < 0L || workerId > (long)this.maxWorkerId.intValue()) {
            throw new IllegalArgumentException("workerId\u4e0d\u5408\u6cd5");
        }
        this.workerId = workerId;
        this.sequence = 0L;
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("\u65f6\u949f\u51fa\u73b0\u9519\u8bef");
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & (long)this.maxSequence.intValue();
            if (this.sequence == 0L) {
                timestamp = this.nextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp << this.workerIdBits + this.sequenceBits | this.workerId << this.sequenceBits | this.sequence;
    }

    private long nextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

