/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.server;

import eu.thesimplecloud.clientserverapi.lib.connection.AbstractNettyConnection;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.packet.AbstractChannelInboundHandlerImpl;
import eu.thesimplecloud.clientserverapi.server.INettyServer;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.ClientManager;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.IClientManager;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClient;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Leu/thesimplecloud/clientserverapi/server/NettyServerHandler;", "Leu/thesimplecloud/clientserverapi/lib/handler/packet/AbstractChannelInboundHandlerImpl;", "nettyServer", "Leu/thesimplecloud/clientserverapi/server/INettyServer;", "connectionHandler", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "(Leu/thesimplecloud/clientserverapi/server/INettyServer;Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;)V", "clientManager", "Leu/thesimplecloud/clientserverapi/server/client/clientmanager/ClientManager;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "exceptionCaught", "cause", "", "getConnection", "Leu/thesimplecloud/clientserverapi/lib/connection/AbstractNettyConnection;", "clientserverapi"})
@SourceDebugExtension(value={"SMAP\nNettyServerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyServerHandler.kt\neu/thesimplecloud/clientserverapi/server/NettyServerHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class NettyServerHandler
extends AbstractChannelInboundHandlerImpl {
    @NotNull
    private final IConnectionHandler connectionHandler;
    @NotNull
    private final ClientManager<?> clientManager;

    public NettyServerHandler(@NotNull INettyServer<?> nettyServer, @NotNull IConnectionHandler connectionHandler) {
        Intrinsics.checkNotNullParameter(nettyServer, (String)"nettyServer");
        Intrinsics.checkNotNullParameter((Object)connectionHandler, (String)"connectionHandler");
        this.connectionHandler = connectionHandler;
        IClientManager<?> iClientManager = nettyServer.getClientManager();
        Intrinsics.checkNotNull(iClientManager, (String)"null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.server.client.clientmanager.ClientManager<*>");
        this.clientManager = (ClientManager)iClientManager;
    }

    @Override
    @NotNull
    public AbstractNettyConnection getConnection(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        IConnectedClient<?> iConnectedClient = this.clientManager.getClient(ctx);
        Intrinsics.checkNotNull(iConnectedClient);
        return (AbstractNettyConnection)((Object)iConnectedClient);
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        IConnection it = this.clientManager.addClient(ctx);
        boolean bl = false;
        this.connectionHandler.onConnectionActive(it);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            IConnection iConnection = this.clientManager.removeClient(ctx);
            if (iConnection == null) break block0;
            IConnection it = iConnection;
            boolean bl = false;
            this.connectionHandler.onConnectionInactive(it);
        }
    }

    @Deprecated(message="Deprecated in Java")
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            if (cause instanceof IOException) {
                String string = cause.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"reset by peer", (boolean)false, (int)2, null) : false;
                if (bl) {
                    return;
                }
            }
            IConnectedClient<?> iConnectedClient = this.clientManager.getClient(ctx);
            if (iConnectedClient == null) break block3;
            IConnectedClient<?> it = iConnectedClient;
            boolean bl = false;
            if (!it.wasConnectionCloseIntended()) {
                this.connectionHandler.onFailure(it, cause);
            }
        }
    }
}

