/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.localuser;

import androidx.annotation.WorkerThread;
import io.github.crow_misia.mediasoup.Consumer;
import io.github.crow_misia.mediasoup.SendTransport;
import io.socket.client.SocketIOException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.Async;
import world.edgecenter.edgeconf.videocalls.ECSession;
import world.edgecenter.edgeconf.videocalls.localuser.ILocalUser;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.NotifyType;
import world.edgecenter.edgeconf.videocalls.model.UserRole;
import world.edgecenter.edgeconf.videocalls.network.MediaTrackKind;
import world.edgecenter.edgeconf.videocalls.network.client.AudioClient;
import world.edgecenter.edgeconf.videocalls.network.client.VideoClient;
import world.edgecenter.edgeconf.videocalls.network.socket.SocketIO;
import world.edgecenter.edgeconf.videocalls.room.ThreadWorkers;
import world.edgecenter.edgeconf.videocalls.state.LocalUserState;
import world.edgecenter.edgeconf.videocalls.state.RemoteUserRequestData;
import world.edgecenter.edgeconf.videocalls.state.RoomState;
import world.edgecenter.edgeconf.videocalls.utils.JsonUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0011H\u0017J\b\u0010\u001c\u001a\u00020\u000eH\u0017J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u001f\u001a\u00020\u000eJ\b\u0010 \u001a\u00020\u000eH\u0017J\b\u0010!\u001a\u00020\u000eH\u0007J\b\u0010\"\u001a\u00020\u000eH\u0007J\b\u0010#\u001a\u00020\u000eH\u0017J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0004J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0007J\b\u0010.\u001a\u00020\u000eH\u0016J\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0006\u00101\u001a\u00020\u000eJ\u0006\u00102\u001a\u00020\u000eJ\u0010\u00103\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u00104\u001a\u00020\u000e2\b\u00105\u001a\u0004\u0018\u000106J\u0018\u00107\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00108\u001a\u00020%H\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u00108\u001a\u00020%H\u0017J\u0010\u0010:\u001a\u00020\u000e2\u0006\u00108\u001a\u00020%H\u0017J\u0010\u0010;\u001a\u00020\u000e2\u0006\u00108\u001a\u00020%H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lworld/edgecenter/edgeconf/videocalls/localuser/LocalUser;", "Lworld/edgecenter/edgeconf/videocalls/localuser/ILocalUser;", "socketIO", "Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO;", "audioClient", "Lworld/edgecenter/edgeconf/videocalls/network/client/AudioClient;", "videoClient", "Lworld/edgecenter/edgeconf/videocalls/network/client/VideoClient;", "(Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO;Lworld/edgecenter/edgeconf/videocalls/network/client/AudioClient;Lworld/edgecenter/edgeconf/videocalls/network/client/VideoClient;)V", "roomState", "Lworld/edgecenter/edgeconf/videocalls/state/RoomState;", "getRoomState$edgeconf_sdk_release", "()Lworld/edgecenter/edgeconf/videocalls/state/RoomState;", "acceptAllRequestsToJoin", "", "acceptRequestToJoin", "userId", "", "acceptUserPermission", "requestData", "Lworld/edgecenter/edgeconf/videocalls/state/RemoteUserRequestData;", "acceptedPermission", "askModeratorToEnable", "mediaTrack", "Lworld/edgecenter/edgeconf/videocalls/network/MediaTrackKind;", "askUserToEnable", "changeDisplayName", "newName", "disableAudioOnly", "disableMediaTrackForUser", "disableMediaTracksForOtherUsers", "dispose", "enableAudioOnly", "enableCam", "enableMic", "flipCam", "isCamActive", "", "isMicActive", "logError", "message", "throwable", "", "pauseConsumer", "consumer", "Lio/github/crow_misia/mediasoup/Consumer;", "rejectAllRequestsToJoin", "rejectRequestToJoin", "rejectUserPermission", "removeCameraProducer", "removeMicProducer", "removeUser", "setSendTransport", "sendTransport", "Lio/github/crow_misia/mediasoup/SendTransport;", "setUsersPermission", "isOn", "toggleCam", "toggleMic", "toggleWaitingRoom", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nLocalUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalUser.kt\nworld/edgecenter/edgeconf/videocalls/localuser/LocalUser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n*L\n1#1,380:1\n1#2:381\n99#3,5:382\n319#3,5:387\n*S KotlinDebug\n*F\n+ 1 LocalUser.kt\nworld/edgecenter/edgeconf/videocalls/localuser/LocalUser\n*L\n143#1:382,5\n356#1:387,5\n*E\n"})
public final class LocalUser
implements ILocalUser {
    @NotNull
    private final SocketIO socketIO;
    @NotNull
    private final AudioClient audioClient;
    @NotNull
    private final VideoClient videoClient;

    public LocalUser(@NotNull SocketIO socketIO, @NotNull AudioClient audioClient, @NotNull VideoClient videoClient) {
        Intrinsics.checkNotNullParameter((Object)socketIO, (String)"socketIO");
        Intrinsics.checkNotNullParameter((Object)audioClient, (String)"audioClient");
        Intrinsics.checkNotNullParameter((Object)videoClient, (String)"videoClient");
        this.socketIO = socketIO;
        this.audioClient = audioClient;
        this.videoClient = videoClient;
    }

    @NotNull
    public final RoomState getRoomState$edgeconf_sdk_release() {
        return ECSession.INSTANCE.get_roomState$edgeconf_sdk_release();
    }

    public final void setSendTransport(@Nullable SendTransport sendTransport2) {
        this.audioClient.setSendTransport$edgeconf_sdk_release(sendTransport2);
        this.videoClient.setSendTransport$edgeconf_sdk_release(sendTransport2);
    }

    public final void dispose() {
        this.videoClient.dispose();
        this.audioClient.dispose();
    }

    public final boolean isCamActive() {
        return this.videoClient.isCamActive();
    }

    public final boolean isMicActive() {
        return this.audioClient.isMicActive();
    }

    public final void removeCameraProducer() {
        this.videoClient.removeProducer();
    }

    public final void removeMicProducer() {
        this.audioClient.removeProducer();
    }

    @Async
    public final void pauseConsumer(@NotNull Consumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.pauseConsumer$lambda$0(this, consumer));
    }

    @Override
    public void acceptAllRequestsToJoin() {
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void acceptRequestToJoin(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Async
    public void acceptUserPermission(@NotNull RemoteUserRequestData requestData) {
        Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        this.acceptedPermission(requestData);
    }

    @Override
    @Async
    public void askModeratorToEnable(@NotNull MediaTrackKind mediaTrack) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaTrack), (String)"mediaTrack");
        try {
            LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
            LLog.d("RoomMessageHandler", "askModeratorToEnableTrack() peerId:" + (localUserState2 != null ? localUserState2.getId() : null));
            this.socketIO.syncRequest("askModeratorToEnableTrack", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(this, mediaTrack){
                final /* synthetic */ LocalUser this$0;
                final /* synthetic */ MediaTrackKind $mediaTrack;
                {
                    this.this$0 = $receiver;
                    this.$mediaTrack = $mediaTrack;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    LocalUserState localUserState2 = (LocalUserState)this.this$0.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
                    JsonUtils.INSTANCE.jsonPut(data, "peerId", localUserState2 != null ? localUserState2.getId() : null);
                    JsonUtils.INSTANCE.jsonPut(data, "requestType", this.$mediaTrack.getValue());
                    LocalUserState localUserState3 = (LocalUserState)this.this$0.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
                    JsonUtils.INSTANCE.jsonPut(data, "displayName", localUserState3 != null ? localUserState3.getDisplayName() : null);
                }
            }));
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("acceptedPermissionByModerator failed", e);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logError("acceptedPermissionByModerator failed", e);
        }
    }

    @Override
    @Async
    public void askUserToEnable(@NotNull String userId, @NotNull MediaTrackKind mediaTrack) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaTrack), (String)"mediaTrack");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        try {
            LLog.d("RoomMessageHandler", "acceptedPermissionByModerator() peerId:" + userId + ",requestType:" + mediaTrack.getValue());
            this.socketIO.syncRequest("acceptedPermissionByModerator", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(userId, mediaTrack){
                final /* synthetic */ String $userId;
                final /* synthetic */ MediaTrackKind $mediaTrack;
                {
                    this.$userId = $userId;
                    this.$mediaTrack = $mediaTrack;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "peerId", this.$userId);
                    JsonUtils.INSTANCE.jsonPut(data, "requestType", this.$mediaTrack.getValue());
                    JsonUtils.INSTANCE.jsonPut(data, "fromModerator", true);
                }
            }));
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("acceptedPermissionByModerator failed", e);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logError("acceptedPermissionByModerator failed", e);
        }
    }

    @Override
    @Async
    public void changeDisplayName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        String string = localUserState2 != null ? localUserState2.getDisplayName() : null;
        if (string == null) {
            boolean $i$a$-checkNotNull-LocalUser$changeDisplayName$oldName$22 = false;
            String $i$a$-checkNotNull-LocalUser$changeDisplayName$oldName$22 = "changeDisplayName failed localUserState is null";
            throw new IllegalStateException($i$a$-checkNotNull-LocalUser$changeDisplayName$oldName$22.toString());
        }
        String oldName = string;
        String tag$iv = "RoomMessageHandler";
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"changeDisplayName()", (Object[])new Object[0]);
        }
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.changeDisplayName$lambda$3(this, newName, oldName));
    }

    @Override
    @Async
    public void disableAudioOnly() {
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.disableAudioOnly$lambda$4(this));
    }

    @Override
    @Async
    public void disableMediaTrackForUser(@NotNull String userId, @NotNull MediaTrackKind mediaTrack) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaTrack), (String)"mediaTrack");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        try {
            LLog.d("RoomMessageHandler", "disableTrackProducerByModerator() peerId:" + userId + ",kind:" + mediaTrack.getValue());
            this.socketIO.syncRequest("disableTrackProducerByModerator", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(userId, mediaTrack){
                final /* synthetic */ String $userId;
                final /* synthetic */ MediaTrackKind $mediaTrack;
                {
                    this.$userId = $userId;
                    this.$mediaTrack = $mediaTrack;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "peerId", this.$userId);
                    JsonUtils.INSTANCE.jsonPut(data, "kind", this.$mediaTrack.getValue());
                }
            }));
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("disableTrackProducerByModerator failed", e);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logError("disableTrackProducerByModerator failed", e);
        }
    }

    @Override
    public void disableMediaTracksForOtherUsers(@NotNull MediaTrackKind mediaTrack) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaTrack), (String)"mediaTrack");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Async
    public void enableAudioOnly() {
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.enableAudioOnly$lambda$5(this));
    }

    @Async
    public final void enableCam() {
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.enableCam$lambda$6(this));
    }

    @Async
    public final void enableMic() {
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.enableMic$lambda$7(this));
    }

    @Override
    @Async
    public void flipCam() {
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.flipCam$lambda$8(this));
    }

    @Override
    public void rejectAllRequestsToJoin() {
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void rejectRequestToJoin(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Async
    public void rejectUserPermission(@NotNull RemoteUserRequestData requestData) {
        Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Async
    public void removeUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        try {
            LLog.d("RoomMessageHandler", "removeUserByModerator() peerId:" + userId);
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("removeUserByModerator failed", e);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logError("removeUserByModerator failed", e);
        }
    }

    @Override
    public void setUsersPermission(@NotNull MediaTrackKind mediaTrack, boolean isOn) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaTrack), (String)"mediaTrack");
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Async
    @WorkerThread
    public void toggleCam(boolean isOn) {
        if (isOn) {
            LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
            if ((localUserState2 != null ? localUserState2.getRole() : null) == UserRole.MODERATOR || Intrinsics.areEqual((Object)this.getRoomState$edgeconf_sdk_release().getCamAllowed().getValue(), (Object)true)) {
                ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.toggleCam$lambda$9(this));
            } else {
                this.getRoomState$edgeconf_sdk_release().getOnRequestPermissionToEnableCamera().postValue(Unit.INSTANCE);
            }
        } else {
            ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.toggleCam$lambda$10(this));
        }
    }

    @Override
    @Async
    public void toggleMic(boolean isOn) {
        if (isOn) {
            boolean isModerator;
            LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
            boolean bl = isModerator = (localUserState2 != null ? localUserState2.getRole() : null) == UserRole.MODERATOR;
            if (isModerator || Intrinsics.areEqual((Object)this.getRoomState$edgeconf_sdk_release().getMicAllowed().getValue(), (Object)true)) {
                ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.toggleMic$lambda$11(this));
            } else {
                this.getRoomState$edgeconf_sdk_release().getOnRequestPermissionToEnableMic().postValue(Unit.INSTANCE);
            }
        } else {
            ThreadWorkers.INSTANCE.getWorkHandler().post(() -> LocalUser.toggleMic$lambda$12(this));
        }
    }

    @Override
    public void toggleWaitingRoom(boolean isOn) {
        LocalUserState localUserState2 = (LocalUserState)this.getRoomState$edgeconf_sdk_release().getLocalUserState().getValue();
        if ((localUserState2 != null ? localUserState2.getRole() : null) != UserRole.MODERATOR) {
            return;
        }
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    protected final void logError(@NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String tag$iv = "RoomMessageHandler";
        boolean $i$f$e = false;
        if (LLog.INSTANCE.isLoggable(6, tag$iv)) {
            Timber.tag((String)tag$iv);
            Throwable throwable2 = throwable;
            boolean bl = false;
            Timber.e((Throwable)throwable2, (String)message, (Object[])new Object[0]);
        }
    }

    private final void acceptedPermission(RemoteUserRequestData requestData) {
        try {
            LLog.d("RoomMessageHandler", "acceptedPermissionByModerator() peerId:" + requestData.getUserId() + ", requestType:" + requestData.getRequestedMediaTrack());
            this.socketIO.syncRequest("acceptedPermissionByModerator", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(requestData){
                final /* synthetic */ RemoteUserRequestData $requestData;
                {
                    this.$requestData = $requestData;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "peerId", this.$requestData.getUserId());
                    JsonUtils.INSTANCE.jsonPut(data, "requestType", this.$requestData.getRequestedMediaTrack().getValue());
                }
            }));
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("acceptedPermissionByModerator failed", e);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logError("acceptedPermissionByModerator failed", e);
        }
    }

    private static final void pauseConsumer$lambda$0(LocalUser this$0, Consumer $consumer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        this$0.videoClient.pauseConsumer($consumer);
    }

    private static final void changeDisplayName$lambda$3(LocalUser this$0, String $newName, String $oldName) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
        Intrinsics.checkNotNullParameter((Object)$oldName, (String)"$oldName");
        try {
            this$0.socketIO.syncRequest("changeDisplayName", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>($newName){
                final /* synthetic */ String $newName;
                {
                    this.$newName = $newName;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "displayName", this.$newName);
                }
            }));
            this$0.getRoomState$edgeconf_sdk_release().setDisplayName$edgeconf_sdk_release($newName);
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this$0.logError("changeDisplayName() | failed:", e);
            this$0.getRoomState$edgeconf_sdk_release().addNotify(NotifyType.CALL_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u043c\u044f.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443 \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443.");
            this$0.getRoomState$edgeconf_sdk_release().setDisplayName$edgeconf_sdk_release($oldName);
        }
    }

    private static final void disableAudioOnly$lambda$4(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.videoClient.disableAudioOnly();
    }

    private static final void enableAudioOnly$lambda$5(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.videoClient.enableAudioOnly();
    }

    private static final void enableCam$lambda$6(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.videoClient.isCamEnabled()) {
            this$0.videoClient.resumeCam();
        } else {
            this$0.videoClient.enableCam();
        }
    }

    private static final void enableMic$lambda$7(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.audioClient.enableMic();
    }

    private static final void flipCam$lambda$8(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.videoClient.flipCam();
    }

    private static final void toggleCam$lambda$9(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.videoClient.isCamEnabled()) {
            this$0.videoClient.resumeCam();
        } else {
            this$0.videoClient.enableCam();
        }
    }

    private static final void toggleCam$lambda$10(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.videoClient.pauseCam();
    }

    private static final void toggleMic$lambda$11(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.audioClient.isMicEnabled()) {
            this$0.audioClient.unmuteMic();
        } else {
            this$0.audioClient.enableMic();
        }
    }

    private static final void toggleMic$lambda$12(LocalUser this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.audioClient.muteMic();
    }
}

