/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.model;

import io.github.crow_misia.mediasoup.Consumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.Originator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0005J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005J\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lworld/edgecenter/edgeconf/videocalls/model/Consumers;", "", "()V", "consumers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lworld/edgecenter/edgeconf/videocalls/model/Consumers$ConsumerWrapper;", "addConsumer", "", "type", "consumer", "Lio/github/crow_misia/mediasoup/Consumer;", "remotelyPaused", "", "mediaTrackKind", "userId", "clear", "getConsumer", "consumerId", "getConsumers", "", "removeConsumer", "setConsumerCurrentLayers", "spatialLayer", "", "temporalLayer", "setConsumerPaused", "originator", "Lworld/edgecenter/edgeconf/videocalls/model/Originator;", "setConsumerResumed", "setConsumerScore", "score", "Lorg/json/JSONArray;", "Companion", "ConsumerWrapper", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nConsumers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Consumers.kt\nworld/edgecenter/edgeconf/videocalls/model/Consumers\n+ 2 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n*L\n1#1,118:1\n99#2,5:119\n99#2,5:124\n*S KotlinDebug\n*F\n+ 1 Consumers.kt\nworld/edgecenter/edgeconf/videocalls/model/Consumers\n*L\n29#1:119,5\n44#1:124,5\n*E\n"})
public final class Consumers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, ConsumerWrapper> consumers = new ConcurrentHashMap();
    @NotNull
    private static final String TAG = "Consumers";

    public final void addConsumer(@NotNull String type, @NotNull Consumer consumer, boolean remotelyPaused, @NotNull String mediaTrackKind, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)mediaTrackKind, (String)"mediaTrackKind");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        ((Map)this.consumers).put(consumer.getId(), new ConsumerWrapper(type, remotelyPaused, consumer, mediaTrackKind, userId));
    }

    public final void clear() {
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"consumers clear()", (Object[])new Object[0]);
        }
        this.consumers.clear();
    }

    @Nullable
    public final ConsumerWrapper getConsumer(@NotNull String consumerId) {
        Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
        return this.consumers.get(consumerId);
    }

    @NotNull
    public final List<ConsumerWrapper> getConsumers() {
        Collection<ConsumerWrapper> collection = this.consumers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"consumers.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final void removeConsumer(@NotNull String consumerId) {
        Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)("remove consumer id: " + consumerId), (Object[])new Object[0]);
        }
        ConsumerWrapper consumer = this.consumers.get(consumerId);
        this.consumers.remove(consumerId);
    }

    public final void setConsumerCurrentLayers(@NotNull String consumerId, int spatialLayer, int temporalLayer) {
        Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
        ConsumerWrapper consumerWrapper = this.consumers.get(consumerId);
        if (consumerWrapper == null) {
            return;
        }
        ConsumerWrapper wrapper = consumerWrapper;
        wrapper.setSpatialLayer(spatialLayer);
        wrapper.setTemporalLayer(temporalLayer);
    }

    public final void setConsumerPaused(@NotNull String consumerId, @Nullable Originator originator) {
        Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
        ConsumerWrapper consumerWrapper = this.consumers.get(consumerId);
        if (consumerWrapper == null) {
            return;
        }
        ConsumerWrapper wrapper = consumerWrapper;
        if (Originator.LOCAL == originator) {
            wrapper.setLocallyPaused(true);
        } else {
            wrapper.setRemotelyPaused(true);
        }
    }

    public final void setConsumerResumed(@NotNull String consumerId, @Nullable Originator originator) {
        Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
        ConsumerWrapper consumerWrapper = this.consumers.get(consumerId);
        if (consumerWrapper == null) {
            return;
        }
        ConsumerWrapper wrapper = consumerWrapper;
        if (Originator.LOCAL == originator) {
            wrapper.setLocallyPaused(false);
        } else {
            wrapper.setRemotelyPaused(false);
        }
    }

    public final void setConsumerScore(@NotNull String consumerId, @Nullable JSONArray score) {
        Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
        ConsumerWrapper consumerWrapper = this.consumers.get(consumerId);
        if (consumerWrapper == null) {
            return;
        }
        ConsumerWrapper wrapper = consumerWrapper;
        wrapper.setScore(score);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lworld/edgecenter/edgeconf/videocalls/model/Consumers$Companion;", "", "()V", "TAG", "", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u000e\"\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0013\u00a8\u0006)"}, d2={"Lworld/edgecenter/edgeconf/videocalls/model/Consumers$ConsumerWrapper;", "", "type", "", "isRemotelyPaused", "", "consumer", "Lio/github/crow_misia/mediasoup/Consumer;", "mediaTrackKind", "userId", "(Ljava/lang/String;ZLio/github/crow_misia/mediasoup/Consumer;Ljava/lang/String;Ljava/lang/String;)V", "getConsumer", "()Lio/github/crow_misia/mediasoup/Consumer;", "isLocallyPaused", "()Z", "setLocallyPaused", "(Z)V", "setRemotelyPaused", "getMediaTrackKind", "()Ljava/lang/String;", "preferredSpatialLayer", "", "getPreferredSpatialLayer", "()I", "preferredTemporalLayer", "getPreferredTemporalLayer", "score", "Lorg/json/JSONArray;", "getScore", "()Lorg/json/JSONArray;", "setScore", "(Lorg/json/JSONArray;)V", "spatialLayer", "getSpatialLayer", "setSpatialLayer", "(I)V", "temporalLayer", "getTemporalLayer", "setTemporalLayer", "getType", "getUserId", "edgeconf-sdk_release"})
    public static final class ConsumerWrapper {
        @NotNull
        private final String type;
        private boolean isRemotelyPaused;
        @NotNull
        private final Consumer consumer;
        @NotNull
        private final String mediaTrackKind;
        @NotNull
        private final String userId;
        private boolean isLocallyPaused;
        private int spatialLayer;
        private int temporalLayer;
        @Nullable
        private JSONArray score;
        private final int preferredSpatialLayer;
        private final int preferredTemporalLayer;

        public ConsumerWrapper(@NotNull String type, boolean isRemotelyPaused, @NotNull Consumer consumer, @NotNull String mediaTrackKind, @NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter((Object)mediaTrackKind, (String)"mediaTrackKind");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            this.type = type;
            this.isRemotelyPaused = isRemotelyPaused;
            this.consumer = consumer;
            this.mediaTrackKind = mediaTrackKind;
            this.userId = userId;
            this.spatialLayer = -1;
            this.temporalLayer = -1;
            this.preferredSpatialLayer = -1;
            this.preferredTemporalLayer = -1;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean isRemotelyPaused() {
            return this.isRemotelyPaused;
        }

        public final void setRemotelyPaused(boolean bl) {
            this.isRemotelyPaused = bl;
        }

        @NotNull
        public final Consumer getConsumer() {
            return this.consumer;
        }

        @NotNull
        public final String getMediaTrackKind() {
            return this.mediaTrackKind;
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        public final boolean isLocallyPaused() {
            return this.isLocallyPaused;
        }

        public final void setLocallyPaused(boolean bl) {
            this.isLocallyPaused = bl;
        }

        public final int getSpatialLayer() {
            return this.spatialLayer;
        }

        public final void setSpatialLayer(int n) {
            this.spatialLayer = n;
        }

        public final int getTemporalLayer() {
            return this.temporalLayer;
        }

        public final void setTemporalLayer(int n) {
            this.temporalLayer = n;
        }

        @Nullable
        public final JSONArray getScore() {
            return this.score;
        }

        public final void setScore(@Nullable JSONArray jSONArray) {
            this.score = jSONArray;
        }

        public final int getPreferredSpatialLayer() {
            return this.preferredSpatialLayer;
        }

        public final int getPreferredTemporalLayer() {
            return this.preferredTemporalLayer;
        }
    }
}

