/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.model;

import io.github.crow_misia.mediasoup.Producer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.webrtc.MediaStreamTrack;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.TrackSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lworld/edgecenter/edgeconf/videocalls/model/Producers;", "", "()V", "producers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lworld/edgecenter/edgeconf/videocalls/model/Producers$ProducersWrapper;", "addProducer", "", "producer", "Lio/github/crow_misia/mediasoup/Producer;", "clear", "filter", "trackKindEnum", "Lworld/edgecenter/edgeconf/videocalls/model/TrackSource;", "removeProducer", "producerId", "setProducerPaused", "setProducerResumed", "setProducerScore", "score", "Lorg/json/JSONArray;", "Companion", "ProducersWrapper", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Producers.kt\nworld/edgecenter/edgeconf/videocalls/model/Producers\n+ 2 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n99#2,5:61\n99#2,5:70\n766#3:66\n857#3,2:67\n1#4:69\n*S KotlinDebug\n*F\n+ 1 Producers.kt\nworld/edgecenter/edgeconf/videocalls/model/Producers\n*L\n16#1:61,5\n28#1:70,5\n23#1:66\n23#1:67,2\n*E\n"})
public final class Producers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, ProducersWrapper> producers = new ConcurrentHashMap();
    @NotNull
    private static final String TAG = "Producers";

    public final void addProducer(@NotNull Producer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        ((Map)this.producers).put(producer.getId(), new ProducersWrapper(producer));
    }

    public final void clear() {
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"producers clear()", (Object[])new Object[0]);
        }
        this.producers.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ProducersWrapper filter(@NotNull TrackSource trackKindEnum) {
        Object v3;
        block2: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)trackKindEnum), (String)"trackKindEnum");
            Collection<ProducersWrapper> collection = this.producers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"producers.values");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProducersWrapper it = (ProducersWrapper)element$iv$iv;
                boolean bl = false;
                if (!(it.getProducer().getTrack() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                ProducersWrapper it = (ProducersWrapper)e;
                boolean bl = false;
                String string = trackKindEnum.getKind();
                MediaStreamTrack mediaStreamTrack = it.getProducer().getTrack();
                Intrinsics.checkNotNull((Object)mediaStreamTrack);
                if (!Intrinsics.areEqual((Object)string, (Object)mediaStreamTrack.kind())) continue;
                v3 = e;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    public final void removeProducer(@NotNull String producerId2) {
        block2: {
            ProducersWrapper producersWrapper;
            Intrinsics.checkNotNullParameter((Object)producerId2, (String)"producerId");
            String tag$iv = TAG;
            boolean $i$f$d = false;
            if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Timber.d((String)("remove producer id: " + producerId2), (Object[])new Object[0]);
            }
            ProducersWrapper producer = this.producers.get(producerId2);
            this.producers.remove(producerId2);
            ProducersWrapper producersWrapper2 = producer;
            if (producersWrapper2 != null && (producersWrapper2 = producersWrapper2.getProducer()) != null) {
                producersWrapper2.close();
            }
            if ((producersWrapper = producer) == null || (producersWrapper = producersWrapper.getProducer()) == null) break block2;
            producersWrapper.dispose();
        }
    }

    public final void setProducerPaused(@NotNull String producerId2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)producerId2, (String)"producerId");
            ProducersWrapper producersWrapper = this.producers.get(producerId2);
            if (producersWrapper == null || (producersWrapper = producersWrapper.getProducer()) == null) break block0;
            producersWrapper.pause();
        }
    }

    public final void setProducerResumed(@NotNull String producerId2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)producerId2, (String)"producerId");
            ProducersWrapper producersWrapper = this.producers.get(producerId2);
            if (producersWrapper == null || (producersWrapper = producersWrapper.getProducer()) == null) break block0;
            producersWrapper.resume();
        }
    }

    public final void setProducerScore(@NotNull String producerId2, @Nullable JSONArray score) {
        Intrinsics.checkNotNullParameter((Object)producerId2, (String)"producerId");
        ProducersWrapper producersWrapper = this.producers.get(producerId2);
        if (producersWrapper != null) {
            producersWrapper.setScore(score);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lworld/edgecenter/edgeconf/videocalls/model/Producers$Companion;", "", "()V", "TAG", "", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lworld/edgecenter/edgeconf/videocalls/model/Producers$ProducersWrapper;", "", "producer", "Lio/github/crow_misia/mediasoup/Producer;", "(Lio/github/crow_misia/mediasoup/Producer;)V", "getProducer", "()Lio/github/crow_misia/mediasoup/Producer;", "score", "Lorg/json/JSONArray;", "getScore", "()Lorg/json/JSONArray;", "setScore", "(Lorg/json/JSONArray;)V", "edgeconf-sdk_release"})
    public static final class ProducersWrapper {
        @NotNull
        private final Producer producer;
        @Nullable
        private JSONArray score;

        public ProducersWrapper(@NotNull Producer producer) {
            Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
            this.producer = producer;
        }

        @NotNull
        public final Producer getProducer() {
            return this.producer;
        }

        @Nullable
        public final JSONArray getScore() {
            return this.score;
        }

        public final void setScore(@Nullable JSONArray jSONArray) {
            this.score = jSONArray;
        }
    }
}

