/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.network.client;

import androidx.annotation.WorkerThread;
import io.github.crow_misia.mediasoup.Device;
import io.github.crow_misia.mediasoup.MediasoupException;
import io.github.crow_misia.mediasoup.Producer;
import io.github.crow_misia.mediasoup.SendTransport;
import io.github.crow_misia.webrtc.RTCLocalAudioManager;
import io.github.crow_misia.webrtc.option.MediaConstraintsOption;
import io.socket.client.SocketIOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.webrtc.AudioTrack;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnectionFactory;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.Async;
import world.edgecenter.edgeconf.videocalls.ECSession;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.NotifyType;
import world.edgecenter.edgeconf.videocalls.model.Producers;
import world.edgecenter.edgeconf.videocalls.model.TrackSource;
import world.edgecenter.edgeconf.videocalls.network.MediaTrackKind;
import world.edgecenter.edgeconf.videocalls.network.client.AudioClient;
import world.edgecenter.edgeconf.videocalls.network.client.IAudioClient;
import world.edgecenter.edgeconf.videocalls.network.socket.SocketIO;
import world.edgecenter.edgeconf.videocalls.room.ThreadWorkers;
import world.edgecenter.edgeconf.videocalls.state.RoomState;
import world.edgecenter.edgeconf.videocalls.utils.JsonUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006*\u0001\u0014\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0017J\b\u0010\u001e\u001a\u00020\u001dH\u0003J\u0006\u0010\u001f\u001a\u00020\u001dJ\b\u0010 \u001a\u00020\u001dH\u0017J\b\u0010!\u001a\u00020\u001dH\u0003J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u001dH\u0017J\b\u0010,\u001a\u00020\u001dH\u0003J\u0006\u0010-\u001a\u00020\u001dJ\b\u0010.\u001a\u00020\u001dH\u0017J\b\u0010/\u001a\u00020\u001dH\u0003R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lworld/edgecenter/edgeconf/videocalls/network/client/AudioClient;", "Lworld/edgecenter/edgeconf/videocalls/network/client/IAudioClient;", "mediaConstraintsOption", "Lio/github/crow_misia/webrtc/option/MediaConstraintsOption;", "mediasoupDevice", "Lio/github/crow_misia/mediasoup/Device;", "peerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "socketIO", "Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO;", "(Lio/github/crow_misia/webrtc/option/MediaConstraintsOption;Lio/github/crow_misia/mediasoup/Device;Lorg/webrtc/PeerConnectionFactory;Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO;)V", "TAG", "", "localAudioManager", "Lio/github/crow_misia/webrtc/RTCLocalAudioManager;", "roomState", "Lworld/edgecenter/edgeconf/videocalls/state/RoomState;", "getRoomState", "()Lworld/edgecenter/edgeconf/videocalls/state/RoomState;", "rtcLocalAudioManager", "world/edgecenter/edgeconf/videocalls/network/client/AudioClient$rtcLocalAudioManager$1", "Lworld/edgecenter/edgeconf/videocalls/network/client/AudioClient$rtcLocalAudioManager$1;", "sendTransport", "Lio/github/crow_misia/mediasoup/SendTransport;", "getSendTransport$edgeconf_sdk_release", "()Lio/github/crow_misia/mediasoup/SendTransport;", "setSendTransport$edgeconf_sdk_release", "(Lio/github/crow_misia/mediasoup/SendTransport;)V", "disableMic", "", "disableMicImpl", "dispose", "enableMic", "enableMicImpl", "getMicProducer", "Lio/github/crow_misia/mediasoup/Producer;", "isMicActive", "", "isMicEnabled", "logError", "message", "throwable", "", "muteMic", "muteMicImpl", "removeProducer", "unmuteMic", "unmuteMicImpl", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nAudioClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioClient.kt\nworld/edgecenter/edgeconf/videocalls/network/client/AudioClient\n+ 2 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n*L\n1#1,247:1\n99#2,5:248\n99#2,5:253\n99#2,5:258\n99#2,5:263\n99#2,5:268\n99#2,5:273\n319#2,5:278\n99#2,5:283\n99#2,5:288\n*S KotlinDebug\n*F\n+ 1 AudioClient.kt\nworld/edgecenter/edgeconf/videocalls/network/client/AudioClient\n*L\n87#1:248,5\n93#1:253,5\n99#1:258,5\n105#1:263,5\n111#1:268,5\n133#1:273,5\n194#1:278,5\n199#1:283,5\n224#1:288,5\n*E\n"})
public final class AudioClient
implements IAudioClient {
    @NotNull
    private final MediaConstraintsOption mediaConstraintsOption;
    @NotNull
    private final Device mediasoupDevice;
    @NotNull
    private final PeerConnectionFactory peerConnectionFactory;
    @NotNull
    private final SocketIO socketIO;
    @Nullable
    private SendTransport sendTransport;
    @NotNull
    private final String TAG;
    @NotNull
    private final RTCLocalAudioManager localAudioManager;
    @NotNull
    private final rtcLocalAudioManager.1 rtcLocalAudioManager;

    public AudioClient(@NotNull MediaConstraintsOption mediaConstraintsOption, @NotNull Device mediasoupDevice, @NotNull PeerConnectionFactory peerConnectionFactory, @NotNull SocketIO socketIO) {
        Intrinsics.checkNotNullParameter((Object)mediaConstraintsOption, (String)"mediaConstraintsOption");
        Intrinsics.checkNotNullParameter((Object)mediasoupDevice, (String)"mediasoupDevice");
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)socketIO, (String)"socketIO");
        this.mediaConstraintsOption = mediaConstraintsOption;
        this.mediasoupDevice = mediasoupDevice;
        this.peerConnectionFactory = peerConnectionFactory;
        this.socketIO = socketIO;
        this.TAG = "AudioClient";
        rtcLocalAudioManager.2 var5_5 = rtcLocalAudioManager.2.INSTANCE;
        this.rtcLocalAudioManager = new RTCLocalAudioManager(var5_5){

            @NotNull
            public MediaConstraints createSourceConstraints(@NotNull MediaConstraintsOption option) {
                MediaConstraints mediaConstraints;
                Intrinsics.checkNotNullParameter((Object)option, (String)"option");
                MediaConstraints $this$createSourceConstraints_u24lambda_u240 = mediaConstraints = new MediaConstraints();
                boolean bl = false;
                this.addMandatory($this$createSourceConstraints_u24lambda_u240, "googAutoGainControl", true);
                this.addMandatory($this$createSourceConstraints_u24lambda_u240, "googNoiseSuppression", true);
                this.addMandatory($this$createSourceConstraints_u24lambda_u240, "googEchoCancellation", true);
                this.addMandatory($this$createSourceConstraints_u24lambda_u240, "googHighpassFilter", true);
                return mediaConstraints;
            }
        };
        this.localAudioManager = this.rtcLocalAudioManager;
    }

    @Nullable
    public final SendTransport getSendTransport$edgeconf_sdk_release() {
        return this.sendTransport;
    }

    public final void setSendTransport$edgeconf_sdk_release(@Nullable SendTransport sendTransport2) {
        this.sendTransport = sendTransport2;
    }

    private final RoomState getRoomState() {
        return ECSession.INSTANCE.get_roomState$edgeconf_sdk_release();
    }

    public final void dispose() {
        this.localAudioManager.dispose();
    }

    public final boolean isMicEnabled() {
        return this.getMicProducer() != null;
    }

    public final boolean isMicActive() {
        Producer micProducer2 = this.getMicProducer();
        return micProducer2 != null && !micProducer2.getPaused() && !micProducer2.getClosed();
    }

    public final void removeProducer() {
        Producer micProducer2 = this.getMicProducer();
        if (micProducer2 != null) {
            ThreadWorkers.INSTANCE.getWorkHandler().post(() -> AudioClient.removeProducer$lambda$0(this, micProducer2));
        }
    }

    private final Producer getMicProducer() {
        Object object = (Producers)this.getRoomState().getProducers().getValue();
        return object != null && (object = ((Producers)object).filter(TrackSource.MIC)) != null ? ((Producers.ProducersWrapper)object).getProducer() : null;
    }

    @Override
    @Async
    public void disableMic() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"disableMic()", (Object[])new Object[0]);
        }
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> AudioClient.disableMic$lambda$2(this));
    }

    @Override
    @Async
    public void enableMic() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"enableMic()", (Object[])new Object[0]);
        }
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> AudioClient.enableMic$lambda$4(this));
    }

    @Override
    @Async
    public void muteMic() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"muteMic()", (Object[])new Object[0]);
        }
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> AudioClient.muteMic$lambda$6(this));
    }

    @Override
    @Async
    public void unmuteMic() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"unmuteMic()", (Object[])new Object[0]);
        }
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> AudioClient.unmuteMic$lambda$8(this));
    }

    @WorkerThread
    private final void disableMicImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"disableMicImpl()", (Object[])new Object[0]);
        }
        Producer producer = this.getMicProducer();
        if (producer == null) {
            return;
        }
        Producer micProducer2 = producer;
        this.getRoomState().removeProducer$edgeconf_sdk_release(micProducer2.getId());
        try {
            this.socketIO.syncRequest("closeProducer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(micProducer2){
                final /* synthetic */ Producer $micProducer;
                {
                    this.$micProducer = $micProducer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "producerId", this.$micProducer.getId());
                }
            }));
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0438\u043a\u0440\u043e\u0444\u043e\u043d\u0430 \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 VPN.");
        }
    }

    @WorkerThread
    private final void enableMicImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"enableMicImpl()", (Object[])new Object[0]);
        }
        try {
            if (this.getMicProducer() != null) {
                return;
            }
            if (!this.mediasoupDevice.getLoaded()) {
                LLog.w(this.TAG, (Function0<String>)((Function0)enableMicImpl.2.INSTANCE));
                return;
            }
            if (!this.mediasoupDevice.canProduce(MediaTrackKind.AUDIO.getValue())) {
                LLog.w(this.TAG, (Function0<String>)((Function0)enableMicImpl.3.INSTANCE));
                return;
            }
            SendTransport sendTransport2 = this.sendTransport;
            if (sendTransport2 == null) {
                AudioClient $this$enableMicImpl_u24lambda_u2411 = this;
                boolean bl = false;
                LLog.w($this$enableMicImpl_u24lambda_u2411.TAG, (Function0<String>)((Function0)enableMicImpl.sendTransport.1.1.INSTANCE));
                return;
            }
            SendTransport sendTransport3 = sendTransport2;
            this.localAudioManager.initTrack(this.peerConnectionFactory, this.mediaConstraintsOption);
            AudioTrack audioTrack = this.localAudioManager.getTrack();
            if (audioTrack == null) {
                AudioClient $this$enableMicImpl_u24lambda_u2412 = this;
                boolean bl = false;
                Timber.w((String)"audio track null", (Object[])new Object[0]);
                return;
            }
            AudioTrack track = audioTrack;
            Producer micProducer2 = sendTransport3.produce(new Producer.Listener(this){
                final /* synthetic */ AudioClient this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onTransportClose(@NotNull Producer producer) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
                        String tag$iv = AudioClient.access$getTAG$p(this.this$0);
                        boolean $i$f$e = false;
                        if (LLog.INSTANCE.isLoggable(6, tag$iv)) {
                            Timber.tag((String)tag$iv);
                            boolean bl = false;
                            Timber.e((String)"onTransportClose(), micProducer", (Object[])new Object[0]);
                        }
                        Producer producer2 = AudioClient.access$getMicProducer(this.this$0);
                        if (producer2 == null) break block1;
                        Producer producer3 = producer2;
                        AudioClient audioClient = this.this$0;
                        Producer it = producer3;
                        boolean bl = false;
                        AudioClient.access$getRoomState(audioClient).removeProducer$edgeconf_sdk_release(it.getId());
                    }
                }
            }, (MediaStreamTrack)track, CollectionsKt.emptyList(), null, null);
            this.getRoomState().addProducer$edgeconf_sdk_release(micProducer2);
            this.getRoomState().setNeedNotifyLocalUserAboutSpeakWithOffMicro$edgeconf_sdk_release(false);
        }
        catch (MediasoupException e) {
            e.printStackTrace();
            this.logError("enableMic() | failed:", e);
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043c\u0438\u043a\u0440\u043e\u0444\u043e\u043d.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0438\u043a\u0440\u043e\u0444\u043e\u043d\u0430.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.");
            this.localAudioManager.setEnabled(false);
        }
    }

    private final void logError(String message, Throwable throwable) {
        String tag$iv = "RoomMessageHandler";
        boolean $i$f$e = false;
        if (LLog.INSTANCE.isLoggable(6, tag$iv)) {
            Timber.tag((String)tag$iv);
            Throwable throwable2 = throwable;
            boolean bl = false;
            Timber.e((Throwable)throwable2, (String)message, (Object[])new Object[0]);
        }
    }

    @WorkerThread
    private final void muteMicImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"muteMicImpl()", (Object[])new Object[0]);
        }
        Producer producer = this.getMicProducer();
        if (producer == null) {
            return;
        }
        Producer micProducer2 = producer;
        this.localAudioManager.setEnabled(false);
        micProducer2.pause();
        try {
            this.socketIO.syncRequest("pauseProducer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(micProducer2){
                final /* synthetic */ Producer $micProducer;
                {
                    this.$micProducer = $micProducer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "producerId", this.$micProducer.getId());
                }
            }));
            this.getRoomState().setProducerPaused$edgeconf_sdk_release(micProducer2.getId());
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("muteMic() | failed:", e);
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0438\u043a\u0440\u043e\u0444\u043e\u043d\u0430 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 VPN.");
        }
    }

    @WorkerThread
    private final void unmuteMicImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"unmuteMicImpl()", (Object[])new Object[0]);
        }
        Producer producer = this.getMicProducer();
        if (producer == null) {
            return;
        }
        Producer micProducer2 = producer;
        this.localAudioManager.setEnabled(true);
        micProducer2.resume();
        try {
            this.socketIO.syncRequest("resumeProducer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(micProducer2){
                final /* synthetic */ Producer $micProducer;
                {
                    this.$micProducer = $micProducer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "producerId", this.$micProducer.getId());
                }
            }));
            this.getRoomState().setProducerResumed$edgeconf_sdk_release(micProducer2.getId());
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("unmuteMic() | failed:", e);
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0438\u043a\u0440\u043e\u0444\u043e\u043d\u0430 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 VPN.");
        }
    }

    private static final void removeProducer$lambda$0(AudioClient this$0, Producer $micProducer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getRoomState().removeProducer$edgeconf_sdk_release($micProducer.getId());
    }

    private static final void disableMic$lambda$2(AudioClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.disableMicImpl();
    }

    private static final void enableMic$lambda$4(AudioClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.enableMicImpl();
    }

    private static final void muteMic$lambda$6(AudioClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.muteMicImpl();
    }

    private static final void unmuteMic$lambda$8(AudioClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.unmuteMicImpl();
    }

    public static final /* synthetic */ String access$getTAG$p(AudioClient $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Producer access$getMicProducer(AudioClient $this) {
        return $this.getMicProducer();
    }

    public static final /* synthetic */ RoomState access$getRoomState(AudioClient $this) {
        return $this.getRoomState();
    }
}

