/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.network.client;

import android.content.Context;
import androidx.annotation.WorkerThread;
import io.github.crow_misia.mediasoup.Consumer;
import io.github.crow_misia.mediasoup.Device;
import io.github.crow_misia.mediasoup.MediasoupException;
import io.github.crow_misia.mediasoup.Producer;
import io.github.crow_misia.mediasoup.SendTransport;
import io.github.crow_misia.webrtc.RTCComponentFactory;
import io.github.crow_misia.webrtc.RTCLocalVideoManager;
import io.github.crow_misia.webrtc.option.MediaConstraintsOption;
import io.socket.client.SocketIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpParameters;
import org.webrtc.VideoFrame;
import org.webrtc.VideoProcessor;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.Async;
import world.edgecenter.edgeconf.videocalls.ECSession;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.Consumers;
import world.edgecenter.edgeconf.videocalls.model.NotifyType;
import world.edgecenter.edgeconf.videocalls.model.Originator;
import world.edgecenter.edgeconf.videocalls.model.Producers;
import world.edgecenter.edgeconf.videocalls.model.TrackSource;
import world.edgecenter.edgeconf.videocalls.network.MediaTrackKind;
import world.edgecenter.edgeconf.videocalls.network.client.IVideoClient;
import world.edgecenter.edgeconf.videocalls.network.client.VideoClient;
import world.edgecenter.edgeconf.videocalls.network.client.VideoFrameListener;
import world.edgecenter.edgeconf.videocalls.network.socket.SocketIO;
import world.edgecenter.edgeconf.videocalls.room.RoomParams;
import world.edgecenter.edgeconf.videocalls.room.ThreadWorkers;
import world.edgecenter.edgeconf.videocalls.state.RoomState;
import world.edgecenter.edgeconf.videocalls.utils.JsonUtils;
import world.edgecenter.edgeconf.videocalls.utils.Utils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t*\u0001'\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010)\u001a\u00020%H\u0017J\b\u0010*\u001a\u00020%H\u0017J\b\u0010+\u001a\u00020%H\u0003J\b\u0010,\u001a\u00020%H\u0007J\b\u0010-\u001a\u00020%H\u0017J\b\u0010.\u001a\u00020%H\u0017J\b\u0010/\u001a\u00020%H\u0003J\b\u00100\u001a\u00020%H\u0017J\n\u00101\u001a\u0004\u0018\u000102H\u0002J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000204J\u0018\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020%H\u0017J\b\u0010;\u001a\u00020%H\u0003J\u0010\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020>H\u0007J\u0006\u0010?\u001a\u00020%J\b\u0010@\u001a\u00020%H\u0017J\b\u0010A\u001a\u00020%H\u0003J\u0010\u0010B\u001a\u00020%2\u0006\u0010=\u001a\u00020>H\u0003J\u0010\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020$H\u0002J\b\u0010E\u001a\u00020%H\u0007J\b\u0010F\u001a\u00020%H\u0007R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u0006G"}, d2={"Lworld/edgecenter/edgeconf/videocalls/network/client/VideoClient;", "Lworld/edgecenter/edgeconf/videocalls/network/client/IVideoClient;", "componentFactory", "Lio/github/crow_misia/webrtc/RTCComponentFactory;", "camCapturer", "Lorg/webrtc/CameraVideoCapturer;", "mediaConstraintsOption", "Lio/github/crow_misia/webrtc/option/MediaConstraintsOption;", "mediasoupDevice", "Lio/github/crow_misia/mediasoup/Device;", "peerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "socketIO", "Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO;", "(Lio/github/crow_misia/webrtc/RTCComponentFactory;Lorg/webrtc/CameraVideoCapturer;Lio/github/crow_misia/webrtc/option/MediaConstraintsOption;Lio/github/crow_misia/mediasoup/Device;Lorg/webrtc/PeerConnectionFactory;Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO;)V", "TAG", "", "localVideoManager", "Lio/github/crow_misia/webrtc/RTCLocalVideoManager;", "roomState", "Lworld/edgecenter/edgeconf/videocalls/state/RoomState;", "getRoomState", "()Lworld/edgecenter/edgeconf/videocalls/state/RoomState;", "sendTransport", "Lio/github/crow_misia/mediasoup/SendTransport;", "getSendTransport$edgeconf_sdk_release", "()Lio/github/crow_misia/mediasoup/SendTransport;", "setSendTransport$edgeconf_sdk_release", "(Lio/github/crow_misia/mediasoup/SendTransport;)V", "simulcastEncodings", "", "Lorg/webrtc/RtpParameters$Encoding;", "sink", "Lorg/webrtc/VideoSink;", "sinkCallback", "Lkotlin/Function1;", "Lorg/webrtc/VideoFrame;", "", "switchHandler", "world/edgecenter/edgeconf/videocalls/network/client/VideoClient$switchHandler$1", "Lworld/edgecenter/edgeconf/videocalls/network/client/VideoClient$switchHandler$1;", "disableAudioOnly", "disableCam", "disableCamImpl", "dispose", "enableAudioOnly", "enableCam", "enableCamImpl", "flipCam", "getCamProducer", "Lio/github/crow_misia/mediasoup/Producer;", "isCamActive", "", "isCamEnabled", "logError", "message", "throwable", "", "pauseCam", "pauseCamImpl", "pauseConsumer", "consumer", "Lio/github/crow_misia/mediasoup/Consumer;", "removeProducer", "resumeCam", "resumeCamImpl", "resumeConsumer", "sendFrame", "frame", "startCapture", "stopCapture", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nVideoClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoClient.kt\nworld/edgecenter/edgeconf/videocalls/network/client/VideoClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,461:1\n1#2:462\n99#3,5:463\n99#3,5:468\n99#3,5:473\n99#3,5:478\n99#3,5:483\n99#3,5:488\n99#3,5:493\n99#3,5:498\n99#3,5:503\n99#3,5:508\n319#3,5:513\n99#3,5:518\n99#3,5:523\n99#3,5:528\n766#4:533\n857#4,2:534\n1855#4,2:536\n766#4:538\n857#4,2:539\n1855#4,2:541\n*S KotlinDebug\n*F\n+ 1 VideoClient.kt\nworld/edgecenter/edgeconf/videocalls/network/client/VideoClient\n*L\n109#1:463,5\n147#1:468,5\n169#1:473,5\n179#1:478,5\n194#1:483,5\n206#1:488,5\n232#1:493,5\n242#1:498,5\n268#1:503,5\n291#1:508,5\n378#1:513,5\n383#1:518,5\n409#1:523,5\n435#1:528,5\n160#1:533\n160#1:534,2\n161#1:536,2\n183#1:538\n183#1:539,2\n184#1:541,2\n*E\n"})
public final class VideoClient
implements IVideoClient {
    @NotNull
    private final CameraVideoCapturer camCapturer;
    @NotNull
    private final MediaConstraintsOption mediaConstraintsOption;
    @NotNull
    private final Device mediasoupDevice;
    @NotNull
    private final PeerConnectionFactory peerConnectionFactory;
    @NotNull
    private final SocketIO socketIO;
    @Nullable
    private SendTransport sendTransport;
    @Nullable
    private VideoSink sink;
    @NotNull
    private final String TAG;
    @NotNull
    private final RTCLocalVideoManager localVideoManager;
    @NotNull
    private final Function1<VideoFrame, Unit> sinkCallback;
    @NotNull
    private final List<RtpParameters.Encoding> simulcastEncodings;
    @NotNull
    private final switchHandler.1 switchHandler;

    public VideoClient(@NotNull RTCComponentFactory componentFactory, @NotNull CameraVideoCapturer camCapturer, @NotNull MediaConstraintsOption mediaConstraintsOption, @NotNull Device mediasoupDevice, @NotNull PeerConnectionFactory peerConnectionFactory, @NotNull SocketIO socketIO) {
        RTCLocalVideoManager videoManager;
        RtpParameters.Encoding encoding;
        Intrinsics.checkNotNullParameter((Object)componentFactory, (String)"componentFactory");
        Intrinsics.checkNotNullParameter((Object)camCapturer, (String)"camCapturer");
        Intrinsics.checkNotNullParameter((Object)mediaConstraintsOption, (String)"mediaConstraintsOption");
        Intrinsics.checkNotNullParameter((Object)mediasoupDevice, (String)"mediasoupDevice");
        Intrinsics.checkNotNullParameter((Object)peerConnectionFactory, (String)"peerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)socketIO, (String)"socketIO");
        this.camCapturer = camCapturer;
        this.mediaConstraintsOption = mediaConstraintsOption;
        this.mediasoupDevice = mediasoupDevice;
        this.peerConnectionFactory = peerConnectionFactory;
        this.socketIO = socketIO;
        this.TAG = "VideoClient";
        this.sinkCallback = (Function1)new Function1<VideoFrame, Unit>(this){
            final /* synthetic */ VideoClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull VideoFrame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                VideoClient.access$sendFrame(this.this$0, frame);
            }
        };
        Object[] objectArray = new RtpParameters.Encoding[3];
        RtpParameters.Encoding encoding2 = encoding = new RtpParameters.Encoding("r1", true, null);
        int n = 0;
        Object[] objectArray2 = objectArray;
        VideoClient videoClient = this;
        boolean bl = false;
        $this$simulcastEncodings_u24lambda_u240.maxBitrateBps = 102400;
        Unit unit = Unit.INSTANCE;
        objectArray2[n] = encoding;
        RtpParameters.Encoding $this$simulcastEncodings_u24lambda_u240 = encoding = new RtpParameters.Encoding("r2", true, null);
        n = 1;
        objectArray2 = objectArray;
        boolean bl2 = false;
        $this$simulcastEncodings_u24lambda_u241.maxBitrateBps = 409600;
        unit = Unit.INSTANCE;
        objectArray2[n] = encoding;
        RtpParameters.Encoding $this$simulcastEncodings_u24lambda_u241 = encoding = new RtpParameters.Encoding("r3", true, null);
        n = 2;
        objectArray2 = objectArray;
        boolean bl3 = false;
        $this$simulcastEncodings_u24lambda_u242.maxBitrateBps = 716800;
        unit = Unit.INSTANCE;
        objectArray2[n] = encoding;
        videoClient.simulcastEncodings = CollectionsKt.listOf((Object[])objectArray);
        RTCLocalVideoManager rTCLocalVideoManager = videoManager = RTCComponentFactory.createVideoManager$default((RTCComponentFactory)componentFactory, null, (int)1, null);
        if (rTCLocalVideoManager == null) {
            videoClient = this;
            boolean bl4 = false;
            VideoClient videoClient2 = videoClient;
            String string = "creating video manager failed";
            throw new IllegalStateException(string.toString());
        }
        this.localVideoManager = rTCLocalVideoManager;
        this.switchHandler = new CameraVideoCapturer.CameraSwitchHandler(this){
            final /* synthetic */ VideoClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCameraSwitchDone(boolean b) {
                VideoClient.access$getRoomState(this.this$0).setCamInProgress$edgeconf_sdk_release(false);
            }

            public void onCameraSwitchError(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                LLog.w(VideoClient.access$getTAG$p(this.this$0), (Function0<String>)((Function0)new Function0<String>(errorMessage){
                    final /* synthetic */ String $errorMessage;
                    {
                        this.$errorMessage = $errorMessage;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "flipCam() | failed: " + this.$errorMessage;
                    }
                }));
                VideoClient.access$getRoomState(this.this$0).addNotify(NotifyType.CALL_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a\u0430\u043c\u0435\u0440\u044b.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443 \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0443\u0436\u043d\u0443\u044e \u043a\u0430\u043c\u0435\u0440\u0443.");
                VideoClient.access$getRoomState(this.this$0).setCamInProgress$edgeconf_sdk_release(false);
            }
        };
    }

    @Nullable
    public final SendTransport getSendTransport$edgeconf_sdk_release() {
        return this.sendTransport;
    }

    public final void setSendTransport$edgeconf_sdk_release(@Nullable SendTransport sendTransport2) {
        this.sendTransport = sendTransport2;
    }

    private final RoomState getRoomState() {
        return ECSession.INSTANCE.get_roomState$edgeconf_sdk_release();
    }

    @Async
    public final void dispose() {
        LLog.w(this.TAG, (Function0<String>)((Function0)dispose.1.INSTANCE));
        this.camCapturer.stopCapture();
        this.localVideoManager.dispose();
    }

    public final boolean isCamEnabled() {
        return this.getCamProducer() != null;
    }

    public final boolean isCamActive() {
        Producer camProducer2 = this.getCamProducer();
        return camProducer2 != null && !camProducer2.getPaused() && !camProducer2.getClosed();
    }

    public final void removeProducer() {
        Producer camProducer2 = this.getCamProducer();
        if (camProducer2 != null) {
            this.getRoomState().setCamInProgress$edgeconf_sdk_release(true);
            ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.removeProducer$lambda$4(this, camProducer2));
        }
    }

    @WorkerThread
    public final void pauseConsumer(@NotNull Consumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        String tag$iv = "RoomMessageHandler";
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)("pauseConsumer() " + consumer.getId()), (Object[])new Object[0]);
        }
        if (consumer.getPaused()) {
            return;
        }
        try {
            this.socketIO.syncRequest("pauseConsumer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(consumer){
                final /* synthetic */ Consumer $consumer;
                {
                    this.$consumer = $consumer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "consumerId", this.$consumer.getId());
                }
            }));
            consumer.pause();
            this.getRoomState().setConsumerPaused(consumer.getId(), Originator.LOCAL);
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("pauseConsumer() | failed:", e);
        }
    }

    @WorkerThread
    public final void startCapture() {
        this.camCapturer.startCapture(ECSession.INSTANCE.getCameraParams().getVideoWidth(), ECSession.INSTANCE.getCameraParams().getVideoHeight(), ECSession.INSTANCE.getCameraParams().getFrameRate());
    }

    @WorkerThread
    public final void stopCapture() {
        this.camCapturer.stopCapture();
    }

    @Override
    @Async
    public void disableAudioOnly() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"disableAudioOnly()", (Object[])new Object[0]);
        }
        this.getRoomState().setAudioOnlyInProgress$edgeconf_sdk_release(true);
        Producer camProducer2 = this.getCamProducer();
        RoomParams roomParams = ECSession.INSTANCE.getRoomParams();
        boolean bl = roomParams != null ? roomParams.isProduce() : false;
        if (bl) {
            if (camProducer2 != null) {
                this.resumeCam();
            } else {
                this.enableCam();
            }
        }
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.disableAudioOnly$lambda$9(this));
    }

    @Override
    @Async
    public void disableCam() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"disableCam()", (Object[])new Object[0]);
        }
        this.getRoomState().setCamInProgress$edgeconf_sdk_release(true);
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.disableCam$lambda$11(this));
    }

    @Override
    @Async
    public void enableAudioOnly() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"enableAudioOnly()", (Object[])new Object[0]);
        }
        this.getRoomState().setAudioOnlyInProgress$edgeconf_sdk_release(true);
        this.pauseCam();
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.enableAudioOnly$lambda$15(this));
    }

    @Override
    @Async
    public void enableCam() {
        boolean camEnabled = this.isCamEnabled();
        if (!camEnabled) {
            String tag$iv = this.TAG;
            boolean $i$f$d = false;
            if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Timber.d((String)("enableCam() camEnabled: " + camEnabled), (Object[])new Object[0]);
            }
            this.getRoomState().setCamInProgress$edgeconf_sdk_release(true);
            ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.enableCam$lambda$17(this));
        }
    }

    @Override
    @Async
    public void flipCam() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"flipCam()", (Object[])new Object[0]);
        }
        this.getRoomState().setCamInProgress$edgeconf_sdk_release(true);
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.flipCam$lambda$19(this));
    }

    @Override
    @Async
    public void pauseCam() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"pauseCam()", (Object[])new Object[0]);
        }
        this.getRoomState().setCamInProgress$edgeconf_sdk_release(true);
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.pauseCam$lambda$21(this));
    }

    @Override
    @Async
    public void resumeCam() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"resumeCam()", (Object[])new Object[0]);
        }
        this.getRoomState().setCamInProgress$edgeconf_sdk_release(true);
        ThreadWorkers.INSTANCE.getWorkHandler().post(() -> VideoClient.resumeCam$lambda$23(this));
    }

    @WorkerThread
    private final void disableCamImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"disableCamImpl()", (Object[])new Object[0]);
        }
        this.stopCapture();
        Producer producer = this.getCamProducer();
        if (producer == null) {
            return;
        }
        Producer camProducer2 = producer;
        this.getRoomState().removeProducer$edgeconf_sdk_release(camProducer2.getId());
        try {
            this.socketIO.syncRequest("closeProducer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(camProducer2){
                final /* synthetic */ Producer $camProducer;
                {
                    this.$camProducer = $camProducer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "producerId", this.$camProducer.getId());
                }
            }));
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u0430\u043c\u0435\u0440\u044b \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 VPN.");
        }
    }

    @WorkerThread
    private final void enableCamImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"enableCamImpl()", (Object[])new Object[0]);
        }
        try {
            if (this.getCamProducer() != null) {
                return;
            }
            if (!this.mediasoupDevice.getLoaded()) {
                LLog.w(this.TAG, (Function0<String>)((Function0)enableCamImpl.2.INSTANCE));
                return;
            }
            if (!this.mediasoupDevice.canProduce(MediaTrackKind.VIDEO.getValue())) {
                LLog.w(this.TAG, (Function0<String>)((Function0)enableCamImpl.3.INSTANCE));
                return;
            }
            SendTransport sendTransport2 = this.sendTransport;
            if (sendTransport2 == null) {
                VideoClient $this$enableCamImpl_u24lambda_u2426 = this;
                boolean bl = false;
                Timber.w((String)"enableCam() | mSendTransport doesn't ready", (Object[])new Object[0]);
                return;
            }
            SendTransport sendTransport3 = sendTransport2;
            this.localVideoManager.initTrack(this.peerConnectionFactory, this.mediaConstraintsOption, (Context)ECSession.INSTANCE.getAppContext$edgeconf_sdk_release());
            VideoFrameListener videoFrameListener = ECSession.INSTANCE.getVideoFrameListener();
            if (videoFrameListener != null) {
                VideoFrameListener it = videoFrameListener;
                boolean bl = false;
                VideoSource videoSource = this.localVideoManager.getSource();
                if (videoSource != null) {
                    videoSource.setVideoProcessor(new VideoProcessor(this, it){
                        final /* synthetic */ VideoClient this$0;
                        final /* synthetic */ VideoFrameListener $it;
                        {
                            this.this$0 = $receiver;
                            this.$it = $it;
                        }

                        public void onCapturerStarted(boolean p0) {
                        }

                        public void onCapturerStopped() {
                        }

                        public void onFrameCaptured(@Nullable VideoFrame frame) {
                            if (frame == null || VideoClient.access$getSink$p(this.this$0) == null) {
                                return;
                            }
                            this.$it.onFrameCaptured(frame, (Function1<? super VideoFrame, Unit>)VideoClient.access$getSinkCallback$p(this.this$0));
                        }

                        public void setSink(@Nullable VideoSink sink) {
                            VideoClient.access$setSink$p(this.this$0, sink);
                        }
                    });
                }
            }
            VideoTrack videoTrack = this.localVideoManager.getTrack();
            if (videoTrack == null) {
                VideoClient $this$enableCamImpl_u24lambda_u2428 = this;
                boolean bl = false;
                Timber.w((String)"video track null", (Object[])new Object[0]);
                return;
            }
            VideoTrack track = videoTrack;
            LLog.w(this.TAG, (Function0<String>)((Function0)new Function0<String>(track){
                final /* synthetic */ VideoTrack $track;
                {
                    this.$track = $track;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "enableCam() | localVideoTrack: " + this.$track;
                }
            }));
            Producer camProducer2 = sendTransport3.produce(new Producer.Listener(this){
                final /* synthetic */ VideoClient this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onTransportClose(@NotNull Producer producer) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
                        String tag$iv = VideoClient.access$getTAG$p(this.this$0);
                        boolean $i$f$e = false;
                        if (LLog.INSTANCE.isLoggable(6, tag$iv)) {
                            Timber.tag((String)tag$iv);
                            boolean bl = false;
                            Timber.e((String)"onTransportClose(), camProducer", (Object[])new Object[0]);
                        }
                        Producer producer2 = VideoClient.access$getCamProducer(this.this$0);
                        if (producer2 == null) break block1;
                        Producer producer3 = producer2;
                        VideoClient videoClient = this.this$0;
                        Producer it = producer3;
                        boolean bl = false;
                        videoClient.stopCapture();
                        VideoClient.access$getRoomState(videoClient).removeProducer$edgeconf_sdk_release(it.getId());
                    }
                }
            }, (MediaStreamTrack)track, this.simulcastEncodings, null, null);
            this.startCapture();
            this.getRoomState().addProducer$edgeconf_sdk_release(camProducer2);
        }
        catch (MediasoupException e) {
            e.printStackTrace();
            this.logError("enableWebcam() | failed:", e);
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u043a\u0430\u043c\u0435\u0440\u0443.\n\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0435\u0435 \u0440\u0430\u0431\u043e\u0442\u043e\u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u044c \u0438 \u0443\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u043c\u0435\u0440\u044b.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.");
            this.localVideoManager.setEnabled(false);
        }
    }

    private final Producer getCamProducer() {
        Object object = (Producers)this.getRoomState().getProducers().getValue();
        return object != null && (object = ((Producers)object).filter(TrackSource.CAM)) != null ? ((Producers.ProducersWrapper)object).getProducer() : null;
    }

    private final void logError(String message, Throwable throwable) {
        String tag$iv = "RoomMessageHandler";
        boolean $i$f$e = false;
        if (LLog.INSTANCE.isLoggable(6, tag$iv)) {
            Timber.tag((String)tag$iv);
            Throwable throwable2 = throwable;
            boolean bl = false;
            Timber.e((Throwable)throwable2, (String)message, (Object[])new Object[0]);
        }
    }

    @WorkerThread
    private final void pauseCamImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"muteCamImpl()", (Object[])new Object[0]);
        }
        Producer producer = this.getCamProducer();
        if (producer == null) {
            return;
        }
        Producer camProducer2 = producer;
        this.localVideoManager.setEnabled(false);
        camProducer2.pause();
        this.stopCapture();
        try {
            this.socketIO.syncRequest("pauseProducer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(camProducer2){
                final /* synthetic */ Producer $camProducer;
                {
                    this.$camProducer = $camProducer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "producerId", this.$camProducer.getId());
                }
            }));
            this.getRoomState().setProducerPaused$edgeconf_sdk_release(camProducer2.getId());
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("muteCam() | failed:", e);
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u0430\u043c\u0435\u0440\u044b \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 VPN.");
        }
    }

    @WorkerThread
    private final void resumeCamImpl() {
        String tag$iv = this.TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"resumeCamImpl()", (Object[])new Object[0]);
        }
        Producer producer = this.getCamProducer();
        if (producer == null) {
            return;
        }
        Producer camProducer2 = producer;
        this.localVideoManager.setEnabled(true);
        camProducer2.resume();
        this.startCapture();
        try {
            this.socketIO.syncRequest("resumeProducer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(camProducer2){
                final /* synthetic */ Producer $camProducer;
                {
                    this.$camProducer = $camProducer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "producerId", this.$camProducer.getId());
                }
            }));
            this.getRoomState().setProducerResumed$edgeconf_sdk_release(camProducer2.getId());
        }
        catch (SocketIOException e) {
            e.printStackTrace();
            this.logError("unmuteCam() | failed:", e);
            this.getRoomState().addNotify(NotifyType.CALL_ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u0430\u043c\u0435\u0440\u044b \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u041f\u0435\u0440\u0435\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u0441\u044c \u043a \u0437\u0432\u043e\u043d\u043a\u0443.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u0432\u044b \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435 VPN.");
        }
    }

    @WorkerThread
    private final void resumeConsumer(Consumer consumer) {
        String tag$iv = "RoomMessageHandler";
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)("resumeConsumer() " + consumer.getId()), (Object[])new Object[0]);
        }
        if (!consumer.getPaused()) {
            return;
        }
        try {
            this.socketIO.syncRequest("resumeConsumer", (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(consumer){
                final /* synthetic */ Consumer $consumer;
                {
                    this.$consumer = $consumer;
                    super(1);
                }

                public final void invoke(@NotNull JSONObject data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    JsonUtils.INSTANCE.jsonPut(data, "consumerId", this.$consumer.getId());
                }
            }));
            consumer.resume();
            this.getRoomState().setConsumerResumed(consumer.getId(), Originator.LOCAL);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logError("resumeConsumer() | failed:", e);
        }
    }

    private final void sendFrame(VideoFrame frame) {
        block0: {
            VideoSink videoSink = this.sink;
            if (videoSink == null) break block0;
            videoSink.onFrame(frame);
        }
    }

    private static final void removeProducer$lambda$4(VideoClient this$0, Producer $camProducer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.stopCapture();
        this$0.getRoomState().removeProducer$edgeconf_sdk_release($camProducer.getId());
        this$0.getRoomState().setCamInProgress$edgeconf_sdk_release(false);
    }

    /*
     * WARNING - void declaration
     */
    private static final void disableAudioOnly$lambda$9(VideoClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = (Consumers)this$0.getRoomState().getConsumers().getValue();
        if (object != null && (object = ((Consumers)object).getConsumers()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Consumers.ConsumerWrapper it = (Consumers.ConsumerWrapper)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)MediaTrackKind.VIDEO.getValue(), (Object)it.getConsumer().getKind())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Consumers.ConsumerWrapper it = (Consumers.ConsumerWrapper)element$iv;
                boolean bl = false;
                this$0.resumeConsumer(it.getConsumer());
            }
        }
        this$0.getRoomState().setAudioOnlyState$edgeconf_sdk_release(false);
        this$0.getRoomState().setAudioOnlyInProgress$edgeconf_sdk_release(false);
    }

    private static final void disableCam$lambda$11(VideoClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.disableCamImpl();
        this$0.getRoomState().setCamInProgress$edgeconf_sdk_release(false);
    }

    /*
     * WARNING - void declaration
     */
    private static final void enableAudioOnly$lambda$15(VideoClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = (Consumers)this$0.getRoomState().getConsumers().getValue();
        if (object != null && (object = ((Consumers)object).getConsumers()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Consumers.ConsumerWrapper it = (Consumers.ConsumerWrapper)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)MediaTrackKind.VIDEO.getValue(), (Object)it.getConsumer().getKind())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Consumers.ConsumerWrapper it = (Consumers.ConsumerWrapper)element$iv;
                boolean bl = false;
                this$0.pauseConsumer(it.getConsumer());
            }
        }
        this$0.getRoomState().setAudioOnlyState$edgeconf_sdk_release(true);
        this$0.getRoomState().setAudioOnlyInProgress$edgeconf_sdk_release(false);
    }

    private static final void enableCam$lambda$17(VideoClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.enableCamImpl();
        this$0.getRoomState().setCamInProgress$edgeconf_sdk_release(false);
    }

    private static final void flipCam$lambda$19(VideoClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Integer currentCameraId = Utils.getCameraId();
        if (currentCameraId == null) {
            this$0.localVideoManager.switchCamera((CameraVideoCapturer.CameraSwitchHandler)this$0.switchHandler);
        } else {
            String targetCameraName;
            String string = targetCameraName = Utils.isFrontFacingCamera(currentCameraId) ? Utils.getBackFacingCameraName() : Utils.getFrontFacingCameraName();
            if (targetCameraName != null) {
                this$0.localVideoManager.switchCamera((CameraVideoCapturer.CameraSwitchHandler)this$0.switchHandler, targetCameraName);
            } else {
                this$0.localVideoManager.switchCamera((CameraVideoCapturer.CameraSwitchHandler)this$0.switchHandler);
            }
        }
    }

    private static final void pauseCam$lambda$21(VideoClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.pauseCamImpl();
        this$0.getRoomState().setCamInProgress$edgeconf_sdk_release(true);
    }

    private static final void resumeCam$lambda$23(VideoClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.resumeCamImpl();
        this$0.getRoomState().setCamInProgress$edgeconf_sdk_release(false);
    }

    public static final /* synthetic */ String access$getTAG$p(VideoClient $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Producer access$getCamProducer(VideoClient $this) {
        return $this.getCamProducer();
    }

    public static final /* synthetic */ RoomState access$getRoomState(VideoClient $this) {
        return $this.getRoomState();
    }

    public static final /* synthetic */ VideoSink access$getSink$p(VideoClient $this) {
        return $this.sink;
    }

    public static final /* synthetic */ Function1 access$getSinkCallback$p(VideoClient $this) {
        return $this.sinkCallback;
    }

    public static final /* synthetic */ void access$setSink$p(VideoClient $this, VideoSink videoSink) {
        $this.sink = videoSink;
    }

    public static final /* synthetic */ void access$sendFrame(VideoClient $this, VideoFrame frame) {
        $this.sendFrame(frame);
    }
}

