/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.network.socket;

import androidx.annotation.WorkerThread;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.socket.client.AckWithTimeout;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.client.SocketIOException;
import io.socket.emitter.Emitter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.ECSession;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.network.NetworkUtils;
import world.edgecenter.edgeconf.videocalls.network.socket.SocketEventsListener;
import world.edgecenter.edgeconf.videocalls.room.RoomParams;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J7\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$2\u0006\u0010%\u001a\u00020\u00152!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u00130'J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u001fH\u0002J3\u0010+\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00152!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u00130'H\u0007J\u001a\u0010+\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00152\b\b\u0002\u0010*\u001a\u00020\u001fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO;", "", "eventsListener", "Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketEventsListener;", "(Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketEventsListener;)V", "isReconnection", "", "onClose", "Lio/socket/emitter/Emitter$Listener;", "onError", "onMessage", "onOpen", "onReconnectionAttempt", "onReconnectionFailed", "onReconnectionFailure", "onReconnectionSuccessful", "socket", "Lio/socket/client/Socket;", "connect", "", "url", "", "disconnect", "getAck", "Lio/socket/client/AckWithTimeout;", "emitter", "Lio/reactivex/ObservableEmitter;", "timeout", "", "getTimeout", "payload", "Lorg/json/JSONObject;", "getUnSafeSocket", "options", "Lio/socket/client/IO$Options;", "request", "Lio/reactivex/Observable;", "method", "setupData", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "data", "syncRequest", "Companion", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nSocketIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketIO.kt\nworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n*L\n1#1,240:1\n1#2:241\n99#3,5:242\n99#3,5:247\n99#3,5:252\n99#3,5:257\n99#3,5:262\n99#3,5:267\n99#3,5:272\n99#3,5:277\n99#3,5:282\n99#3,5:287\n99#3,5:292\n99#3,5:297\n*S KotlinDebug\n*F\n+ 1 SocketIO.kt\nworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO\n*L\n102#1:242,5\n128#1:247,5\n140#1:252,5\n151#1:257,5\n154#1:262,5\n160#1:267,5\n167#1:272,5\n170#1:277,5\n177#1:282,5\n183#1:287,5\n190#1:292,5\n197#1:297,5\n*E\n"})
public final class SocketIO {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketEventsListener eventsListener;
    @Nullable
    private Socket socket;
    private volatile boolean isReconnection;
    @NotNull
    private final Emitter.Listener onOpen;
    @NotNull
    private final Emitter.Listener onError;
    @NotNull
    private final Emitter.Listener onClose;
    @NotNull
    private final Emitter.Listener onMessage;
    @NotNull
    private final Emitter.Listener onReconnectionAttempt;
    @NotNull
    private final Emitter.Listener onReconnectionFailure;
    @NotNull
    private final Emitter.Listener onReconnectionSuccessful;
    @NotNull
    private final Emitter.Listener onReconnectionFailed;
    @NotNull
    private static final String TAG = "SocketIO";
    @NotNull
    private static final String EVENT_MESSAGE = "message";
    private static final long MAX_TIMEOUT = 9000L;
    private static final long MIN_TIMEOUT = 1500L;
    private static final int RETRIES = 10;

    public SocketIO(@NotNull SocketEventsListener eventsListener) {
        Intrinsics.checkNotNullParameter((Object)eventsListener, (String)"eventsListener");
        this.eventsListener = eventsListener;
        this.onOpen = arg_0 -> SocketIO.onOpen$lambda$7(this, arg_0);
        this.onError = arg_0 -> SocketIO.onError$lambda$10(this, arg_0);
        this.onClose = arg_0 -> SocketIO.onClose$lambda$12(this, arg_0);
        this.onMessage = arg_0 -> SocketIO.onMessage$lambda$15(this, arg_0);
        this.onReconnectionAttempt = arg_0 -> SocketIO.onReconnectionAttempt$lambda$17(this, arg_0);
        this.onReconnectionFailure = arg_0 -> SocketIO.onReconnectionFailure$lambda$19(this, arg_0);
        this.onReconnectionSuccessful = arg_0 -> SocketIO.onReconnectionSuccessful$lambda$21(this, arg_0);
        this.onReconnectionFailed = arg_0 -> SocketIO.onReconnectionFailed$lambda$23(this, arg_0);
    }

    public final void connect(@NotNull String url) {
        block11: {
            Socket socket;
            Socket socket2;
            Socket socket3;
            Socket socket4;
            Socket socket5;
            Socket socket6;
            Socket socket7;
            Socket socket8;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            RoomParams roomParams = ECSession.INSTANCE.getRoomParams();
            if (roomParams == null) {
                boolean $i$a$-checkNotNull-SocketIO$connect$hostName$22 = false;
                String $i$a$-checkNotNull-SocketIO$connect$hostName$22 = "roomParams is null";
                throw new IllegalStateException($i$a$-checkNotNull-SocketIO$connect$hostName$22.toString());
            }
            String hostName = roomParams.getHostName();
            String origin = "https://" + hostName;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Sec-WebSocket-Protocol", (Object)CollectionsKt.listOf((Object)"socketIO")), TuplesKt.to((Object)"origin", (Object)CollectionsKt.listOf((Object)origin))};
            IO.Options ioOptions = IO.Options.builder().setReconnectionAttempts(10).setReconnectionDelay(1500L).setReconnectionDelayMax(9000L).setExtraHeaders(MapsKt.mapOf((Pair[])pairArray)).build();
            SocketIO socketIO = this;
            if (NetworkUtils.INSTANCE.isTestStand(hostName)) {
                Intrinsics.checkNotNullExpressionValue((Object)ioOptions, (String)"ioOptions");
                socket8 = this.getUnSafeSocket(url, ioOptions);
            } else {
                IO.Options options;
                OkHttpClient okHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(false).build();
                IO.Options options2 = options = ioOptions;
                SocketIO socketIO2 = socketIO;
                boolean bl = false;
                $this$connect_u24lambda_u241.callFactory = (Call.Factory)okHttpClient;
                $this$connect_u24lambda_u241.webSocketFactory = (WebSocket.Factory)okHttpClient;
                socketIO = socketIO2;
                socket8 = socketIO.socket = IO.socket((String)url, (IO.Options)ioOptions);
            }
            if ((socket7 = this.socket) != null && (socket7 = socket7.io()) != null) {
                socket7.on("open", this.onOpen);
            }
            if ((socket6 = this.socket) != null && (socket6 = socket6.io()) != null) {
                socket6.on("error", this.onError);
            }
            if ((socket5 = this.socket) != null && (socket5 = socket5.io()) != null) {
                socket5.on("close", this.onClose);
            }
            Socket socket9 = this.socket;
            if (socket9 != null) {
                socket9.on(EVENT_MESSAGE, this.onMessage);
            }
            if ((socket4 = this.socket) != null && (socket4 = socket4.io()) != null) {
                socket4.on("reconnect_attempt", this.onReconnectionAttempt);
            }
            if ((socket3 = this.socket) != null && (socket3 = socket3.io()) != null) {
                socket3.on("reconnect", this.onReconnectionSuccessful);
            }
            if ((socket2 = this.socket) != null && (socket2 = socket2.io()) != null) {
                socket2.on("reconnect_error", this.onReconnectionFailure);
            }
            if ((socket = this.socket) != null && (socket = socket.io()) != null) {
                socket.on("reconnect_failed", this.onReconnectionFailed);
            }
            Socket socket10 = this.socket;
            if (socket10 == null) break block11;
            socket10.connect();
        }
    }

    public final void disconnect() {
        Socket socket = this.socket;
        if (socket != null) {
            socket.disconnect();
        }
        Socket socket2 = this.socket;
        if (socket2 != null) {
            socket2.off();
        }
        this.socket = null;
    }

    @NotNull
    public final Observable<String> request(@NotNull String method, @NotNull Function1<? super JSONObject, Unit> setupData) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(setupData, (String)"setupData");
        JSONObject data = new JSONObject();
        setupData.invoke((Object)data);
        return this.request(method, data);
    }

    @WorkerThread
    @NotNull
    public final String syncRequest(@NotNull String method, @NotNull Function1<? super JSONObject, Unit> setupData) throws SocketIOException {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(setupData, (String)"setupData");
        JSONObject data = new JSONObject();
        setupData.invoke((Object)data);
        return this.syncRequest(method, data);
    }

    @WorkerThread
    @NotNull
    public final String syncRequest(@NotNull String method, @NotNull JSONObject data) throws SocketIOException {
        String string;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)("syncRequest(), method: " + method), (Object[])new Object[0]);
        }
        try {
            Object object = this.request(method, data).blockingFirst();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            request(me\u2026blockingFirst()\n        }");
            string = (String)object;
        }
        catch (Throwable throwable) {
            throw new SocketIOException(throwable.getMessage());
        }
        return string;
    }

    public static /* synthetic */ String syncRequest$default(SocketIO socketIO, String string, JSONObject jSONObject, int n, Object object) throws SocketIOException {
        if ((n & 2) != 0) {
            jSONObject = new JSONObject();
        }
        return socketIO.syncRequest(string, jSONObject);
    }

    private final Socket getUnSafeSocket(String url, IO.Options options) {
        IO.Options options2;
        OkHttpClient okHttpClient = NetworkUtils.INSTANCE.getUnSafeOkHttpClient();
        IO.Options $this$getUnSafeSocket_u24lambda_u243 = options2 = options;
        boolean bl = false;
        $this$getUnSafeSocket_u24lambda_u243.callFactory = (Call.Factory)okHttpClient;
        $this$getUnSafeSocket_u24lambda_u243.webSocketFactory = (WebSocket.Factory)okHttpClient;
        Socket socket = IO.socket((String)url, (IO.Options)options);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket(url, options)");
        return socket;
    }

    private final Observable<String> request(String method, JSONObject data) {
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)("request(), method: " + method + "   data: " + data.toString(2)), (Object[])new Object[0]);
        }
        JSONObject request = new JSONObject();
        request.put("type", (Object)method);
        request.put("data", (Object)data);
        Observable observable = Observable.create(arg_0 -> SocketIO.request$lambda$5(this, request, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"create {\n            soc\u2026eout(request)))\n        }");
        return observable;
    }

    private final AckWithTimeout getAck(ObservableEmitter<String> emitter, long timeout) {
        return new AckWithTimeout(timeout, emitter){
            final /* synthetic */ ObservableEmitter<String> $emitter;
            {
                this.$emitter = $emitter;
                super($timeout);
            }

            public void onSuccess(Object ... args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                Object object = args[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONObject");
                JSONObject response2 = (JSONObject)object;
                String tag$iv = "SocketIO";
                boolean $i$f$d = false;
                if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                    Timber.tag((String)tag$iv);
                    boolean bl = false;
                    Timber.d((String)("Ack onSuccess " + response2.toString(2)), (Object[])new Object[0]);
                }
                if (!this.$emitter.isDisposed()) {
                    if (response2.has("error")) {
                        this.$emitter.onError((Throwable)new SocketIOException(response2.get("error").toString()));
                    } else {
                        this.$emitter.onNext((Object)response2.toString());
                    }
                }
            }

            public void onTimeout() {
                if (!this.$emitter.isDisposed()) {
                    this.$emitter.onError((Throwable)new SocketIOException("request timeout"));
                }
            }
        };
    }

    private final long getTimeout(JSONObject payload) {
        return (long)((double)1500 * ((double)15 + 0.1 * (double)payload.toString().length()));
    }

    private static final void request$lambda$5(SocketIO this$0, JSONObject $request, ObservableEmitter it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Socket socket = this$0.socket;
            if (socket == null) break block0;
            Object[] objectArray = new Object[]{$request, this$0.getAck((ObservableEmitter<String>)it, this$0.getTimeout($request))};
            socket.emit(EVENT_MESSAGE, objectArray);
        }
    }

    private static final void onOpen$lambda$7(SocketIO this$0, Object[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"onOpen", (Object[])new Object[0]);
        }
        this$0.eventsListener.onOpen();
    }

    private static final void onError$lambda$10(SocketIO this$0, Object[] it) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (this$0.isReconnection) break block7;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!(it.length == 0)) break block8;
            }
            return;
        }
        Object reason = it[0];
        if (reason instanceof Exception) {
            String tag$iv = TAG;
            boolean $i$f$d = false;
            if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Timber.d((String)("onError " + ((Exception)reason).getMessage()), (Object[])new Object[0]);
            }
            this$0.eventsListener.onError((Exception)reason);
        } else {
            String tag$iv = TAG;
            boolean $i$f$d = false;
            if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Timber.d((String)("onError " + reason), (Object[])new Object[0]);
            }
        }
    }

    private static final void onClose$lambda$12(SocketIO this$0, Object[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"onClose", (Object[])new Object[0]);
        }
        this$0.eventsListener.onClose();
    }

    private static final void onMessage$lambda$15(SocketIO this$0, Object[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (!(it.length == 0)) {
            String tag$iv = TAG;
            boolean $i$f$d = false;
            if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Object object = it[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONObject");
                Timber.d((String)("onMessage: " + ((JSONObject)object).toString(2)), (Object[])new Object[0]);
            }
            this$0.eventsListener.onMessage(it);
        } else {
            String tag$iv = TAG;
            boolean $i$f$d = false;
            if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Timber.d((String)"onMessage empty", (Object[])new Object[0]);
            }
        }
    }

    private static final void onReconnectionAttempt$lambda$17(SocketIO this$0, Object[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isReconnection = true;
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)("onReconnectionAttempt " + it[0]), (Object[])new Object[0]);
        }
        SocketEventsListener socketEventsListener2 = this$0.eventsListener;
        Object object = it[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        socketEventsListener2.onReconnectionAttempt((Integer)object);
    }

    private static final void onReconnectionFailure$lambda$19(SocketIO this$0, Object[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"onReconnectionFailure", (Object[])new Object[0]);
        }
        this$0.eventsListener.onReconnectionFailure();
    }

    private static final void onReconnectionSuccessful$lambda$21(SocketIO this$0, Object[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isReconnection = false;
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"onReconnectionSuccessful", (Object[])new Object[0]);
        }
        this$0.eventsListener.onReconnectionSuccessful();
    }

    private static final void onReconnectionFailed$lambda$23(SocketIO this$0, Object[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isReconnection = false;
        String tag$iv = TAG;
        boolean $i$f$d = false;
        if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
            Timber.tag((String)tag$iv);
            boolean bl = false;
            Timber.d((String)"onReconnectionFailed", (Object[])new Object[0]);
        }
        this$0.eventsListener.onReconnectionFailed();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lworld/edgecenter/edgeconf/videocalls/network/socket/SocketIO$Companion;", "", "()V", "EVENT_MESSAGE", "", "MAX_TIMEOUT", "", "MIN_TIMEOUT", "RETRIES", "", "TAG", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

