/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.remoteuser;

import io.github.crow_misia.mediasoup.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.RemoteUser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\u000e2\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u00170\u0004J\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lworld/edgecenter/edgeconf/videocalls/remoteuser/RemoteUsers;", "", "()V", "list", "", "Lworld/edgecenter/edgeconf/videocalls/model/RemoteUser;", "getList", "()Ljava/util/List;", "remoteUsersInfo", "", "", "kotlin.jvm.PlatformType", "", "addConsumer", "", "userId", "consumer", "Lio/github/crow_misia/mediasoup/Consumer;", "addRemoteUser", "userInfo", "Lorg/json/JSONObject;", "addRemoteUsers", "remoteUsers", "Lkotlin/Pair;", "clear", "getUser", "removeConsumer", "consumerId", "removeRemoteUser", "setUserDisplayName", "displayName", "Companion", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nRemoteUsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteUsers.kt\nworld/edgecenter/edgeconf/videocalls/remoteuser/RemoteUsers\n+ 2 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n279#2,5:86\n1855#3,2:91\n1#4:93\n*S KotlinDebug\n*F\n+ 1 RemoteUsers.kt\nworld/edgecenter/edgeconf/videocalls/remoteuser/RemoteUsers\n*L\n26#1:86,5\n41#1:91,2\n*E\n"})
public final class RemoteUsers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Map<String, RemoteUser> remoteUsersInfo = Collections.synchronizedMap(new LinkedHashMap());
    @NotNull
    private static final String TAG = "RemoteUsers";

    @NotNull
    public final List<RemoteUser> getList() {
        List remoteUsers2 = new ArrayList();
        LLog.d(TAG, "get allRemoteUsers " + this.remoteUsersInfo.size());
        remoteUsers2.addAll(this.remoteUsersInfo.values());
        return remoteUsers2;
    }

    public final void addConsumer(@NotNull String userId, @NotNull Consumer consumer) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        RemoteUser remoteUser = this.getUser(userId);
        if (remoteUser == null) {
            String tag$iv = TAG;
            boolean $i$f$e = false;
            if (LLog.INSTANCE.isLoggable(6, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Timber.e((String)"no RemoteUser found for new Consumer", (Object[])new Object[0]);
            }
            return;
        }
        remoteUser.getConsumerIDs().add(consumer.getId());
    }

    public final synchronized void addRemoteUser(@NotNull String userId, @NotNull JSONObject userInfo) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Map<String, RemoteUser> map = this.remoteUsersInfo;
        Intrinsics.checkNotNullExpressionValue(map, (String)"remoteUsersInfo");
        Map<String, RemoteUser> map2 = map;
        RemoteUser remoteUser = new RemoteUser(userInfo);
        map2.put(userId, remoteUser);
    }

    public final void addRemoteUsers(@NotNull List<? extends Pair<String, ? extends JSONObject>> remoteUsers2) {
        Intrinsics.checkNotNullParameter(remoteUsers2, (String)"remoteUsers");
        Iterable $this$forEach$iv = remoteUsers2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map<String, RemoteUser> map;
            Pair remoteUser = (Pair)element$iv;
            boolean bl = false;
            String id = (String)remoteUser.getFirst();
            JSONObject user = (JSONObject)remoteUser.getSecond();
            Intrinsics.checkNotNullExpressionValue(this.remoteUsersInfo, (String)"remoteUsersInfo");
            RemoteUser remoteUser2 = new RemoteUser(user);
            map.put(id, remoteUser2);
        }
    }

    public final void clear() {
        this.remoteUsersInfo.clear();
    }

    @Nullable
    public final RemoteUser getUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.remoteUsersInfo.get(userId);
    }

    public final void removeConsumer(@NotNull String consumerId) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
            Iterable iterable = this.getList();
            for (Object t : iterable) {
                RemoteUser user = (RemoteUser)t;
                boolean bl = false;
                if (!user.getConsumerIDs().contains(consumerId)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        RemoteUser remoteUser = v0;
        if (remoteUser == null) {
            return;
        }
        RemoteUser remoteUser2 = remoteUser;
        remoteUser2.getConsumerIDs().remove(consumerId);
    }

    public final void removeConsumer(@NotNull String userId, @NotNull String consumerId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)consumerId, (String)"consumerId");
        RemoteUser remoteUser = this.getUser(userId);
        if (remoteUser == null) {
            return;
        }
        RemoteUser remoteUser2 = remoteUser;
        remoteUser2.getConsumerIDs().remove(consumerId);
    }

    public final void removeRemoteUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.remoteUsersInfo.remove(userId);
    }

    public final void setUserDisplayName(@NotNull String userId, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        RemoteUser remoteUser = this.remoteUsersInfo.get(userId);
        if (remoteUser == null) {
            boolean bl = false;
            String string = "setUserDisplayName failed userId " + userId + " not found";
            throw new IllegalStateException(string.toString());
        }
        RemoteUser remoteUser2 = remoteUser;
        remoteUser2.setDisplayName(displayName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lworld/edgecenter/edgeconf/videocalls/remoteuser/RemoteUsers$Companion;", "", "()V", "TAG", "", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

