/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.ui.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import world.edgecenter.edgeconf.videocalls.logger.LLog;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 c2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001cB\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0002J\u0006\u0010&\u001a\u00020\u001dJ\u0006\u0010'\u001a\u00020\u001dJ\u0006\u0010(\u001a\u00020\u001dJ\b\u0010)\u001a\u00020\u0012H\u0002J4\u0010*\u001a\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0007J\u0010\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u0012H\u0002J\b\u00103\u001a\u00020\u001dH\u0016J\u0010\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u000206H\u0016J \u00107\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u0014H\u0016J0\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u00020\u0014H\u0014J\u0018\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u00142\u0006\u0010A\u001a\u00020\u0014H\u0014J \u0010B\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u0014H\u0016J\u0010\u0010G\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020DH\u0016J \u0010H\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u0014H\u0016J\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020DH\u0016J\u0006\u0010J\u001a\u00020\u001dJ\u0010\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020MH\u0002J\u0006\u0010N\u001a\u00020\u001dJ\u0010\u0010O\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010P\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010Q\u001a\u00020\u001d2\u0006\u0010R\u001a\u00020\u000fJ\u000e\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020!J\u000e\u0010U\u001a\u00020\u001d2\u0006\u0010V\u001a\u00020\u000fJ\u0010\u0010W\u001a\u00020\u001d2\b\u0010X\u001a\u0004\u0018\u00010YJ\u001a\u0010W\u001a\u00020\u001d2\b\u0010Z\u001a\u0004\u0018\u00010Y2\b\u0010[\u001a\u0004\u0018\u00010YJ(\u0010\\\u001a\u00020\u001d2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u00142\u0006\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u0014H\u0016J\u0010\u0010`\u001a\u00020\u001d2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010a\u001a\u00020\u001d2\u0006\u0010]\u001a\u00020^H\u0016J\b\u0010b\u001a\u00020\u001dH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lworld/edgecenter/edgeconf/videocalls/ui/view/TextureViewRenderer;", "Landroid/view/TextureView;", "Landroid/view/SurfaceHolder$Callback;", "Landroid/view/TextureView$SurfaceTextureListener;", "Lorg/webrtc/VideoSink;", "Lorg/webrtc/RendererCommon$RendererEvents;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "eglRenderer", "Lorg/webrtc/SurfaceEglRenderer;", "enableFixedSize", "", "rendererEvents", "resourceName", "", "rotatedFrameHeight", "", "rotatedFrameWidth", "surfaceHeight", "surfaceTextureListeners", "", "surfaceWidth", "videoLayoutMeasure", "Lorg/webrtc/RendererCommon$VideoLayoutMeasure;", "addFrameListener", "", "listener", "Lorg/webrtc/EglRenderer$FrameListener;", "scale", "", "addSurfaceTextureListener", "adjustAspectRatio", "videoWidth", "videoHeight", "clearAllSurfaceTextureListeners", "clearImage", "disableFpsReduction", "getResourceName", "init", "sharedContext", "Lorg/webrtc/EglBase$Context;", "configAttrs", "", "drawer", "Lorg/webrtc/RendererCommon$GlDrawer;", "logD", "string", "onFirstFrameRendered", "onFrame", "frame", "Lorg/webrtc/VideoFrame;", "onFrameResolutionChanged", "rotation", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSurfaceTextureAvailable", "surface", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "pauseVideo", "postOrRun", "runnable", "Ljava/lang/Runnable;", "release", "removeFrameListener", "removeSurfaceTextureListener", "setEnableHardwareScaler", "enabled", "setFpsReduction", "fps", "setMirror", "mirror", "setScalingType", "scalingType", "Lorg/webrtc/RendererCommon$ScalingType;", "scalingTypeMatchOrientation", "scalingTypeMismatchOrientation", "surfaceChanged", "holder", "Landroid/view/SurfaceHolder;", "format", "surfaceCreated", "surfaceDestroyed", "updateSurfaceSize", "Companion", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nTextureViewRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextureViewRenderer.kt\nworld/edgecenter/edgeconf/videocalls/ui/view/TextureViewRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n1855#2,2:417\n1855#2,2:419\n1855#2,2:421\n1855#2,2:423\n*S KotlinDebug\n*F\n+ 1 TextureViewRenderer.kt\nworld/edgecenter/edgeconf/videocalls/ui/view/TextureViewRenderer\n*L\n260#1:417,2\n275#1:419,2\n291#1:421,2\n299#1:423,2\n*E\n"})
public final class TextureViewRenderer
extends TextureView
implements SurfaceHolder.Callback,
TextureView.SurfaceTextureListener,
VideoSink,
RendererCommon.RendererEvents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean enableFixedSize;
    @Nullable
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameHeight;
    private int rotatedFrameWidth;
    private int surfaceHeight;
    private int surfaceWidth;
    @NotNull
    private final SurfaceEglRenderer eglRenderer;
    @NotNull
    private final String resourceName;
    @NotNull
    private final List<TextureView.SurfaceTextureListener> surfaceTextureListeners;
    @NotNull
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure;
    @NotNull
    private static final String TAG = "TextureViewRenderer";

    public TextureViewRenderer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.surfaceTextureListeners = new ArrayList();
        this.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.setSurfaceTextureListener(this);
    }

    public TextureViewRenderer(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.surfaceTextureListeners = new ArrayList();
        this.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.setSurfaceTextureListener(this);
    }

    public final void addFrameListener(@Nullable EglRenderer.FrameListener listener, float scale) {
        this.eglRenderer.addFrameListener(listener, scale);
    }

    public final void addSurfaceTextureListener(@NotNull TextureView.SurfaceTextureListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.surfaceTextureListeners.add(listener);
    }

    public final void clearAllSurfaceTextureListeners() {
        this.surfaceTextureListeners.clear();
    }

    public final void clearImage() {
        this.eglRenderer.clearImage();
    }

    public final void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    @JvmOverloads
    public final void init(@Nullable EglBase.Context sharedContext, @Nullable RendererCommon.RendererEvents rendererEvents, @Nullable int[] configAttrs, @Nullable RendererCommon.GlDrawer drawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(sharedContext, (RendererCommon.RendererEvents)this, configAttrs, drawer);
    }

    public static /* synthetic */ void init$default(TextureViewRenderer textureViewRenderer, EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = EglBase.CONFIG_PLAIN;
        }
        if ((n & 8) != 0) {
            glDrawer = (RendererCommon.GlDrawer)new GlRectDrawer();
        }
        textureViewRenderer.init(context, rendererEvents, nArray, glDrawer);
    }

    public final void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    public final void release() {
        this.eglRenderer.release();
    }

    public final void removeFrameListener(@Nullable EglRenderer.FrameListener listener) {
        this.eglRenderer.removeFrameListener(listener);
    }

    public final void removeSurfaceTextureListener(@NotNull TextureView.SurfaceTextureListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.surfaceTextureListeners.remove(listener);
    }

    public final void setEnableHardwareScaler(boolean enabled) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = enabled;
        this.updateSurfaceSize();
    }

    public final void setFpsReduction(float fps) {
        this.eglRenderer.setFpsReduction(fps);
    }

    public final void setMirror(boolean mirror) {
        this.eglRenderer.setMirror(mirror);
    }

    public final void setScalingType(@Nullable RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
        this.requestLayout();
    }

    public final void setScalingType(@Nullable RendererCommon.ScalingType scalingTypeMatchOrientation, @Nullable RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingTypeMatchOrientation, scalingTypeMismatchOrientation);
        this.requestLayout();
    }

    public void onFirstFrameRendered() {
        if (this.rendererEvents != null) {
            RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
            Intrinsics.checkNotNull((Object)rendererEvents);
            rendererEvents.onFirstFrameRendered();
        }
    }

    public synchronized void onFrame(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.eglRenderer.onFrame(frame);
    }

    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        int n;
        int n2;
        if (this.rendererEvents != null) {
            RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
            Intrinsics.checkNotNull((Object)rendererEvents);
            rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
        }
        switch (rotation) {
            case 0: 
            case 180: {
                n2 = videoWidth;
                break;
            }
            default: {
                n2 = videoHeight;
            }
        }
        int rotatedWidth = n2;
        switch (rotation) {
            case 0: 
            case 180: {
                n = videoHeight;
                break;
            }
            default: {
                n = videoWidth;
            }
        }
        int rotatedHeight = n;
        this.postOrRun(() -> TextureViewRenderer.onFrameResolutionChanged$lambda$0(this, rotatedWidth, rotatedHeight));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        float layoutAspectRatio = (float)(right - left) / (float)(bottom - top);
        this.eglRenderer.setLayoutAspectRatio(layoutAspectRatio);
        this.updateSurfaceSize();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ThreadUtils.checkIsOnMainThread();
        Point size = this.videoLayoutMeasure.measure(widthMeasureSpec, heightMeasureSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(size.x, size.y);
        this.logD("onMeasure(). New size: " + size.x + "x" + size.y);
    }

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(new Surface(this.getSurfaceTexture()));
        this.surfaceWidth = 0;
        this.surfaceHeight = 0;
        this.updateSurfaceSize();
        Iterable $this$forEach$iv = this.surfaceTextureListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureView.SurfaceTextureListener it = (TextureView.SurfaceTextureListener)element$iv;
            boolean bl = false;
            it.onSurfaceTextureAvailable(surface, width, height);
        }
        LLog.d(TAG, "textureAvailabe");
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(() -> TextureViewRenderer.onSurfaceTextureDestroyed$lambda$2(completionLatch));
        ThreadUtils.awaitUninterruptibly((CountDownLatch)completionLatch);
        Iterable $this$forEach$iv = this.surfaceTextureListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureView.SurfaceTextureListener it = (TextureView.SurfaceTextureListener)element$iv;
            boolean bl = false;
            it.onSurfaceTextureDestroyed(surface);
        }
        LLog.d(TAG, "textureDestroyed");
        return true;
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        ThreadUtils.checkIsOnMainThread();
        this.logD("surfaceChanged: size: " + width + "x" + height);
        Iterable $this$forEach$iv = this.surfaceTextureListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureView.SurfaceTextureListener it = (TextureView.SurfaceTextureListener)element$iv;
            boolean bl = false;
            it.onSurfaceTextureSizeChanged(surface, width, height);
        }
        LLog.d(TAG, "textureChanged");
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Iterable $this$forEach$iv = this.surfaceTextureListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextureView.SurfaceTextureListener it = (TextureView.SurfaceTextureListener)element$iv;
            boolean bl = false;
            it.onSurfaceTextureUpdated(surface);
        }
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ThreadUtils.checkIsOnMainThread();
        this.surfaceWidth = 0;
        this.surfaceHeight = 0;
        this.updateSurfaceSize();
        LLog.d(TAG, "surfaceCreated");
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LLog.d(TAG, "surfaceDestroyed");
    }

    private final void adjustAspectRatio(int videoWidth, int videoHeight) {
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        double aspectRatio = (double)videoHeight / (double)videoWidth;
        int newWidth = 0;
        int newHeight = 0;
        if (viewHeight > (int)((double)viewWidth * aspectRatio)) {
            newWidth = viewWidth;
            newHeight = (int)((double)viewWidth * aspectRatio);
        } else {
            newWidth = (int)((double)viewHeight / aspectRatio);
            newHeight = viewHeight;
        }
        int xoff = (viewWidth - newWidth) / 2;
        int yoff = (viewHeight - newHeight) / 2;
        this.logD("video=" + videoWidth + "x" + videoHeight + " view=" + viewWidth + "x" + viewHeight + " newView=" + newWidth + "x" + newHeight + " off=" + xoff + "," + yoff);
        Matrix txform = new Matrix();
        this.getTransform(txform);
        txform.setScale((float)newWidth / (float)viewWidth, (float)newHeight / (float)viewHeight);
        txform.postTranslate((float)xoff, (float)yoff);
        this.setTransform(txform);
    }

    private final String getResourceName() {
        String string;
        try {
            String string2 = this.getResources().getResourceName(this.getId());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            resources.\u2026esourceName(id)\n        }");
            string = string2;
        }
        catch (Resources.NotFoundException e) {
            string = "";
        }
        return string;
    }

    private final void logD(String string) {
        Logging.d((String)TAG, (String)(this.resourceName + ": " + string));
    }

    private final void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    private final void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
            float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
            int drawnFrameWidth = 0;
            int drawnFrameHeight = 0;
            if (frameAspectRatio > layoutAspectRatio) {
                drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                drawnFrameHeight = this.rotatedFrameHeight;
            } else {
                drawnFrameWidth = this.rotatedFrameWidth;
                drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
            }
            int width = Math.min(this.getWidth(), drawnFrameWidth);
            int height = Math.min(this.getHeight(), drawnFrameHeight);
            this.logD("updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + width + "x" + height + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (width != this.surfaceWidth || height != this.surfaceHeight) {
                this.surfaceWidth = width;
                this.surfaceHeight = height;
                this.adjustAspectRatio(this.surfaceWidth, this.surfaceHeight);
            }
        } else {
            this.surfaceWidth = 0;
            this.surfaceHeight = 0;
        }
    }

    @JvmOverloads
    public final void init(@Nullable EglBase.Context sharedContext, @Nullable RendererCommon.RendererEvents rendererEvents, @Nullable int[] configAttrs) {
        TextureViewRenderer.init$default(this, sharedContext, rendererEvents, configAttrs, null, 8, null);
    }

    @JvmOverloads
    public final void init(@Nullable EglBase.Context sharedContext, @Nullable RendererCommon.RendererEvents rendererEvents) {
        TextureViewRenderer.init$default(this, sharedContext, rendererEvents, null, null, 12, null);
    }

    private static final void onFrameResolutionChanged$lambda$0(TextureViewRenderer this$0, int $rotatedWidth, int $rotatedHeight) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.rotatedFrameWidth = $rotatedWidth;
        this$0.rotatedFrameHeight = $rotatedHeight;
        this$0.updateSurfaceSize();
        this$0.requestLayout();
    }

    private static final void onSurfaceTextureDestroyed$lambda$2(CountDownLatch $completionLatch) {
        Intrinsics.checkNotNullParameter((Object)$completionLatch, (String)"$completionLatch");
        $completionLatch.countDown();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lworld/edgecenter/edgeconf/videocalls/ui/view/TextureViewRenderer$Companion;", "", "()V", "TAG", "", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

