/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.ui.view.me;

import android.content.Context;
import android.util.AttributeSet;
import androidx.lifecycle.Observer;
import io.github.crow_misia.mediasoup.Producer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoTrack;
import world.edgecenter.edgeconf.videocalls.ECSession;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.Producers;
import world.edgecenter.edgeconf.videocalls.model.TrackSource;
import world.edgecenter.edgeconf.videocalls.ui.view.BaseVideoView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lworld/edgecenter/edgeconf/videocalls/ui/view/me/LocalVideoView;", "Lworld/edgecenter/edgeconf/videocalls/ui/view/BaseVideoView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TAG", "", "offlineCameraTrackObserver", "Landroidx/lifecycle/Observer;", "Lorg/webrtc/VideoTrack;", "producers", "Lworld/edgecenter/edgeconf/videocalls/model/Producers;", "producersObserver", "connect", "", "onAttachedToWindow", "onDetachedFromWindow", "onOfflineCameraTrackChanged", "track", "onPropertyChanged", "edgeconf-sdk_release"})
public final class LocalVideoView
extends BaseVideoView {
    @Nullable
    private Producers producers;
    @NotNull
    private final String TAG;
    @NotNull
    private final Observer<Producers> producersObserver;
    @NotNull
    private final Observer<VideoTrack> offlineCameraTrackObserver;

    public LocalVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.TAG = "LocalVideoView";
        this.producersObserver = arg_0 -> LocalVideoView.producersObserver$lambda$0(this, arg_0);
        this.offlineCameraTrackObserver = arg_0 -> LocalVideoView.offlineCameraTrackObserver$lambda$1(this, arg_0);
    }

    public LocalVideoView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.TAG = "LocalVideoView";
        this.producersObserver = arg_0 -> LocalVideoView.producersObserver$lambda$0(this, arg_0);
        this.offlineCameraTrackObserver = arg_0 -> LocalVideoView.offlineCameraTrackObserver$lambda$1(this, arg_0);
    }

    public LocalVideoView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.TAG = "LocalVideoView";
        this.producersObserver = arg_0 -> LocalVideoView.producersObserver$lambda$0(this, arg_0);
        this.offlineCameraTrackObserver = arg_0 -> LocalVideoView.offlineCameraTrackObserver$lambda$1(this, arg_0);
    }

    public final void connect() {
        LLog.d(this.TAG, "connect");
        this.onPropertyChanged();
    }

    @Override
    protected void onAttachedToWindow() {
        this.getRoomState().getProducers().observeForever(this.producersObserver);
        this.getRoomState().getOfflineCameraTrack$edgeconf_sdk_release().observeForever(this.offlineCameraTrackObserver);
        LLog.d(this.TAG, "onAttachedToWindow");
        super.onAttachedToWindow();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.getRoomState().getProducers().removeObserver(this.producersObserver);
        this.getRoomState().getOfflineCameraTrack$edgeconf_sdk_release().removeObserver(this.offlineCameraTrackObserver);
        LLog.d(this.TAG, "onDetachedFromWindow");
        super.onDetachedFromWindow();
    }

    private final void onPropertyChanged() {
        Unit unit;
        Producer videoProducer;
        Producers.ProducersWrapper camPW;
        LLog.d(this.TAG, "onPropertyChanged");
        Producers producers2 = this.producers;
        Producers.ProducersWrapper producersWrapper = camPW = producers2 != null ? producers2.filter(TrackSource.CAM) : null;
        Producer producer = videoProducer = producersWrapper != null ? producersWrapper.getProducer() : null;
        if (producer != null) {
            Producer producer2 = producer;
            boolean bl = false;
            MediaStreamTrack mediaStreamTrack = producer2.getTrack();
            Intrinsics.checkNotNull((Object)mediaStreamTrack, (String)"null cannot be cast to non-null type org.webrtc.VideoTrack");
            this.setVideoTrack((VideoTrack)mediaStreamTrack);
            this.setVideoVisible(!producer2.getPaused());
            LLog.d(this.TAG, "videoTrack: " + this.getVideoTrack() + " isVideoVisible: " + this.isVideoVisible());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            LocalVideoView $this$onPropertyChanged_u24lambda_u243 = this;
            boolean bl = false;
            LLog.d($this$onPropertyChanged_u24lambda_u243.TAG, "videoProducer null");
            $this$onPropertyChanged_u24lambda_u243.setVideoVisible(false);
            $this$onPropertyChanged_u24lambda_u243.setVideoTrack(null);
        }
        this.updateSink();
    }

    private final void onOfflineCameraTrackChanged(VideoTrack track) {
        LLog.d(this.TAG, "onOfflineCameraTrackChanged");
        this.setVideoTrack(track);
        this.setVideoVisible(track.enabled());
        this.updateSink();
    }

    private static final void producersObserver$lambda$0(LocalVideoView this$0, Producers producers2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)producers2, (String)"producers");
        this$0.producers = producers2;
        LLog.d(this$0.TAG, "producers updated");
        this$0.onPropertyChanged();
    }

    private static final void offlineCameraTrackObserver$lambda$1(LocalVideoView this$0, VideoTrack track) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        if (ECSession.INSTANCE.isClosed()) {
            this$0.onOfflineCameraTrackChanged(track);
        }
    }
}

