/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.ui.view.remoteuser;

import android.content.Context;
import android.util.AttributeSet;
import androidx.lifecycle.Observer;
import io.github.crow_misia.mediasoup.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoSink;
import org.webrtc.VideoTrack;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.model.Consumers;
import world.edgecenter.edgeconf.videocalls.model.RemoteUser;
import world.edgecenter.edgeconf.videocalls.network.MediaTrackKind;
import world.edgecenter.edgeconf.videocalls.remoteuser.RemoteUsers;
import world.edgecenter.edgeconf.videocalls.ui.view.BaseVideoView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\fJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0014J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\b\u0010\u001e\u001a\u00020\u0019H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lworld/edgecenter/edgeconf/videocalls/ui/view/remoteuser/RemoteVideoView;", "Lworld/edgecenter/edgeconf/videocalls/ui/view/BaseVideoView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TAG", "", "_userId", "consumers", "Lworld/edgecenter/edgeconf/videocalls/model/Consumers;", "consumersObserver", "Landroidx/lifecycle/Observer;", "remoteUsers", "Lworld/edgecenter/edgeconf/videocalls/remoteuser/RemoteUsers;", "remoteUsersObserver", "userId", "getUserId", "()Ljava/lang/String;", "connect", "", "getVideoConsumerWrapper", "Lworld/edgecenter/edgeconf/videocalls/model/Consumers$ConsumerWrapper;", "onAttachedToWindow", "onDetachedFromWindow", "onPropertyChanged", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nRemoteVideoView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteVideoView.kt\nworld/edgecenter/edgeconf/videocalls/ui/view/remoteuser/RemoteVideoView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1603#2,9:101\n1855#2:110\n1856#2:112\n1612#2:113\n288#2,2:114\n1#3:111\n1#3:116\n*S KotlinDebug\n*F\n+ 1 RemoteVideoView.kt\nworld/edgecenter/edgeconf/videocalls/ui/view/remoteuser/RemoteVideoView\n*L\n74#1:101,9\n74#1:110\n74#1:112\n74#1:113\n74#1:114,2\n74#1:111\n*E\n"})
public final class RemoteVideoView
extends BaseVideoView {
    @Nullable
    private String _userId;
    @Nullable
    private Consumers consumers;
    @Nullable
    private RemoteUsers remoteUsers;
    @NotNull
    private final String TAG;
    @NotNull
    private final Observer<Consumers> consumersObserver;
    @NotNull
    private final Observer<RemoteUsers> remoteUsersObserver;

    @Nullable
    public final String getUserId() {
        return this._userId;
    }

    public RemoteVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.TAG = "RemoteVideoView";
        this.consumersObserver = arg_0 -> RemoteVideoView.consumersObserver$lambda$0(this, arg_0);
        this.remoteUsersObserver = arg_0 -> RemoteVideoView.remoteUsersObserver$lambda$1(this, arg_0);
    }

    public RemoteVideoView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.TAG = "RemoteVideoView";
        this.consumersObserver = arg_0 -> RemoteVideoView.consumersObserver$lambda$0(this, arg_0);
        this.remoteUsersObserver = arg_0 -> RemoteVideoView.remoteUsersObserver$lambda$1(this, arg_0);
    }

    public RemoteVideoView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.TAG = "RemoteVideoView";
        this.consumersObserver = arg_0 -> RemoteVideoView.consumersObserver$lambda$0(this, arg_0);
        this.remoteUsersObserver = arg_0 -> RemoteVideoView.remoteUsersObserver$lambda$1(this, arg_0);
    }

    public final void connect(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (!Intrinsics.areEqual((Object)this._userId, (Object)userId)) {
            this._userId = userId;
            LLog.d(this.TAG, "connect " + userId);
            VideoTrack videoTrack = this.getVideoTrack();
            if (videoTrack != null) {
                videoTrack.removeSink((VideoSink)this.getTextureView());
            }
            this.setSinked(false);
            this.onPropertyChanged();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        this.getRoomState().getRemoteUsers().observeForever(this.remoteUsersObserver);
        this.getRoomState().getConsumers().observeForever(this.consumersObserver);
        super.onAttachedToWindow();
    }

    @Override
    protected void onDetachedFromWindow() {
        this.getRoomState().getRemoteUsers().removeObserver(this.remoteUsersObserver);
        this.getRoomState().getConsumers().removeObserver(this.consumersObserver);
        super.onDetachedFromWindow();
    }

    /*
     * WARNING - void declaration
     */
    private final Consumers.ConsumerWrapper getVideoConsumerWrapper(Consumers consumers2) {
        LLog.d(this.TAG, "getConsumer _userId: " + this._userId);
        String string = this._userId;
        if (string != null) {
            String userId = string;
            boolean bl = false;
            RemoteUsers remoteUsers2 = this.remoteUsers;
            RemoteUser remoteUser = remoteUsers2 != null ? remoteUsers2.getUser(userId) : null;
            LLog.d(this.TAG, "getConsumer remoteUser: " + remoteUser);
            RemoteUser remoteUser2 = remoteUser;
            if (remoteUser2 != null) {
                Object v5;
                block4: {
                    void $this$firstOrNull$iv;
                    void $this$mapNotNullTo$iv$iv;
                    RemoteUser user = remoteUser2;
                    boolean bl2 = false;
                    Set<String> set = user.getConsumerIDs();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"user.consumerIDs");
                    LLog.d(this.TAG, "getConsumer consumerIDs: " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                    Set<String> set2 = user.getConsumerIDs();
                    Intrinsics.checkNotNullExpressionValue(set2, (String)"user.consumerIDs");
                    Iterable $this$mapNotNull$iv = set2;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Consumers.ConsumerWrapper it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl3 = false;
                        String it = (String)element$iv$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (consumers2.getConsumer(it) == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Consumers.ConsumerWrapper it = (Consumers.ConsumerWrapper)element$iv;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)MediaTrackKind.VIDEO.getValue(), (Object)it.getMediaTrackKind())) continue;
                        v5 = element$iv;
                        break block4;
                    }
                    v5 = null;
                }
                return v5;
            }
        }
        return null;
    }

    private final void onPropertyChanged() {
        Unit unit;
        Consumer videoConsumer;
        Consumers.ConsumerWrapper videoCW;
        Consumers.ConsumerWrapper consumerWrapper;
        Consumers consumers2 = this.consumers;
        if (consumers2 != null) {
            Consumers it = consumers2;
            boolean bl = false;
            consumerWrapper = this.getVideoConsumerWrapper(it);
        } else {
            consumerWrapper = null;
        }
        Consumers.ConsumerWrapper consumerWrapper2 = videoCW = consumerWrapper;
        Consumer consumer = videoConsumer = consumerWrapper2 != null ? consumerWrapper2.getConsumer() : null;
        if (consumer != null) {
            Consumer consumer2 = consumer;
            boolean bl = false;
            MediaStreamTrack mediaStreamTrack = consumer2.getTrack();
            Intrinsics.checkNotNull((Object)mediaStreamTrack, (String)"null cannot be cast to non-null type org.webrtc.VideoTrack");
            this.setVideoTrack((VideoTrack)mediaStreamTrack);
            this.setVideoVisible(!videoCW.isLocallyPaused() && !videoCW.isRemotelyPaused());
            LLog.d(this.TAG, "isVideoVisible: " + this.isVideoVisible());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            RemoteVideoView $this$onPropertyChanged_u24lambda_u248 = this;
            boolean bl = false;
            LLog.d($this$onPropertyChanged_u24lambda_u248.TAG, "no video consumer");
            $this$onPropertyChanged_u24lambda_u248.setVideoVisible(false);
            $this$onPropertyChanged_u24lambda_u248.setVideoTrack(null);
        }
        this.updateSink();
    }

    private static final void consumersObserver$lambda$0(RemoteVideoView this$0, Consumers consumers2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)consumers2, (String)"consumers");
        this$0.consumers = consumers2;
        LLog.d(this$0.TAG, "consumers updated");
        this$0.onPropertyChanged();
    }

    private static final void remoteUsersObserver$lambda$1(RemoteVideoView this$0, RemoteUsers remoteUsers2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)remoteUsers2, (String)"remoteUsers");
        this$0.remoteUsers = remoteUsers2;
        LLog.d(this$0.TAG, "remoteUsers updated");
        this$0.onPropertyChanged();
    }
}

