/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.utils;

import android.content.Context;
import android.media.AudioRecord;
import androidx.core.app.ActivityCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import world.edgecenter.edgeconf.videocalls.ECSession;
import world.edgecenter.edgeconf.videocalls.localuser.LocalUserInfo;
import world.edgecenter.edgeconf.videocalls.model.Consumers;
import world.edgecenter.edgeconf.videocalls.model.Producers;
import world.edgecenter.edgeconf.videocalls.model.Speaker;
import world.edgecenter.edgeconf.videocalls.model.TrackSource;
import world.edgecenter.edgeconf.videocalls.network.MediaTrackKind;
import world.edgecenter.edgeconf.videocalls.state.RoomState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/AudioVolumeAnalyser;", "", "roomState", "Lworld/edgecenter/edgeconf/videocalls/state/RoomState;", "(Lworld/edgecenter/edgeconf/videocalls/state/RoomState;)V", "audioRecord", "Landroid/media/AudioRecord;", "bufferSize", "", "updateFrequencyMillis", "checkSpeakWithOffMic", "", "Companion", "edgeconf-sdk_release"})
public final class AudioVolumeAnalyser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomState roomState;
    private int updateFrequencyMillis;
    private final int bufferSize;
    @Nullable
    private AudioRecord audioRecord;
    @NotNull
    private static final String audioLevelKey = "audioLevel";
    private static final int defaultUpdateFrequencyMillis = 1000;
    private static final double minAudioLevelTrigger = 0.003;
    private static final int SAMPLE_RATE = 44100;
    private static final int CHANNEL_CONFIG = 16;
    private static final int AUDIO_FORMAT = 2;
    private static final double minAudioRecordVolumeTrigger = 50.0;

    public AudioVolumeAnalyser(@NotNull RoomState roomState) {
        Intrinsics.checkNotNullParameter((Object)roomState, (String)"roomState");
        this.roomState = roomState;
        this.updateFrequencyMillis = 1000;
        this.bufferSize = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"audio volume analyser", (int)0, (Function0)((Function0)new Function0<Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                long startTime = System.currentTimeMillis();
                while (true) {
                    Object object;
                    List<Consumers.ConsumerWrapper> list;
                    if (System.currentTimeMillis() - startTime <= (long)updateFrequencyMillis) {
                        continue;
                    }
                    List activeSpeakers = new ArrayList();
                    Consumers consumers2 = (Consumers)roomState.getConsumers().getValue();
                    if (consumers2 != null && (list = consumers2.getConsumers()) != null) {
                        void $this$forEach$iv;
                        Iterator $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Iterable iterable = list;
                        boolean $i$f$filter = false;
                        void var8_7 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        Iterator iterator = $this$filterTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv = iterator.next();
                            Consumers.ConsumerWrapper it = (Consumers.ConsumerWrapper)element$iv$iv;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it.getMediaTrackKind(), (Object)MediaTrackKind.AUDIO.getValue()) && !it.isLocallyPaused() && !it.isRemotelyPaused())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
                        block2: while ($this$filterTo$iv$iv.hasNext()) {
                            Object element$iv = $this$filterTo$iv$iv.next();
                            Consumers.ConsumerWrapper consumerWrapper = (Consumers.ConsumerWrapper)element$iv;
                            boolean bl = false;
                            JSONArray consumerStats = new JSONArray(consumerWrapper.getConsumer().getStats());
                            int n = consumerStats.length();
                            for (int i = 0; i < n; ++i) {
                                JSONObject jSONObject = consumerStats.optJSONObject(i);
                                if (jSONObject == null) continue;
                                double audioLevel = jSONObject.optDouble(AudioVolumeAnalyser.audioLevelKey);
                                if (Double.isNaN(audioLevel) || !(audioLevel > 0.003)) continue;
                                activeSpeakers.add(new Speaker(consumerWrapper.getUserId(), audioLevel));
                                continue block2;
                            }
                        }
                    }
                    if ((object = (Producers)roomState.getProducers().getValue()) != null && (object = ((Producers)object).filter(TrackSource.MIC)) != null) {
                        Object micPW = object;
                        boolean bl = false;
                        Object object2 = ECSession.INSTANCE.getLocalUserInfo();
                        if (object2 != null && (object2 = ((LocalUserInfo)object2).getId()) != null) {
                            Object localUserId = object2;
                            JSONArray producerStats = new JSONArray(((Producers.ProducersWrapper)micPW).getProducer().getStats());
                            double audioLevel = 0.0;
                            int n = producerStats.length();
                            for (int i = 0; i < n; ++i) {
                                JSONObject jSONObject = producerStats.optJSONObject(i);
                                if (jSONObject == null) continue;
                                audioLevel = jSONObject.optDouble(AudioVolumeAnalyser.audioLevelKey);
                                if (!Double.isNaN(audioLevel)) break;
                            }
                            if (audioLevel > 0.003 && !((Producers.ProducersWrapper)micPW).getProducer().getPaused() && !((Producers.ProducersWrapper)micPW).getProducer().getClosed()) {
                                activeSpeakers.add(new Speaker((String)localUserId, audioLevel));
                            }
                        }
                    }
                    roomState.setRoomActiveSpeakers$edgeconf_sdk_release(activeSpeakers);
                    startTime = System.currentTimeMillis();
                }
            }
        }), (int)21, null);
    }

    public final void checkSpeakWithOffMic() {
        if (ActivityCompat.checkSelfPermission((Context)((Context)ECSession.INSTANCE.getAppContext$edgeconf_sdk_release()), (String)"android.permission.RECORD_AUDIO") != 0) {
            return;
        }
        AudioRecord audioRecord = this.audioRecord = new AudioRecord(1, 44100, 16, 2, this.bufferSize);
        boolean bl = audioRecord != null ? audioRecord.getState() == 1 : false;
        if (bl) {
            AudioRecord audioRecord2 = this.audioRecord;
            Intrinsics.checkNotNull((Object)audioRecord2);
            audioRecord2.startRecording();
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ AudioVolumeAnalyser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    short[] buffer = new short[AudioVolumeAnalyser.access$getBufferSize$p(this.this$0)];
                    long startTime = System.currentTimeMillis();
                    while (AudioVolumeAnalyser.access$getRoomState$p(this.this$0).getNeedNotifyLocalUserAboutSpeakWithOffMicro$edgeconf_sdk_release()) {
                        int readSize;
                        if (System.currentTimeMillis() - startTime <= (long)AudioVolumeAnalyser.access$getUpdateFrequencyMillis$p(this.this$0)) continue;
                        AudioRecord audioRecord = AudioVolumeAnalyser.access$getAudioRecord$p(this.this$0);
                        int n = readSize = audioRecord != null ? audioRecord.read(buffer, 0, AudioVolumeAnalyser.access$getBufferSize$p(this.this$0)) : 0;
                        if (readSize > 0) {
                            double sum = 0.0;
                            for (int i = 0; i < readSize; ++i) {
                                sum += (double)(buffer[i] * buffer[i]);
                            }
                            double amplitude = sum / (double)readSize;
                            double volume = (double)10 * Math.log10(amplitude);
                            if (volume > 50.0) {
                                AudioVolumeAnalyser.access$getRoomState$p(this.this$0).addNotify("\u0412\u0430\u0441 \u043d\u0435 \u0441\u043b\u044b\u0448\u043d\u043e, \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043c\u0438\u043a\u0440\u043e\u0444\u043e\u043d");
                                AudioVolumeAnalyser.access$getRoomState$p(this.this$0).setNeedNotifyLocalUserAboutSpeakWithOffMicro$edgeconf_sdk_release(false);
                                if (AudioVolumeAnalyser.access$getAudioRecord$p(this.this$0) != null) {
                                    AudioRecord audioRecord2;
                                    AudioRecord $this$invoke_u24lambda_u240 = audioRecord2;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u240.stop();
                                    $this$invoke_u24lambda_u240.release();
                                }
                                AudioVolumeAnalyser.access$setAudioRecord$p(this.this$0, null);
                            }
                        }
                        startTime = System.currentTimeMillis();
                    }
                }
            }), (int)31, null);
        }
    }

    public static final /* synthetic */ int access$getBufferSize$p(AudioVolumeAnalyser $this) {
        return $this.bufferSize;
    }

    public static final /* synthetic */ AudioRecord access$getAudioRecord$p(AudioVolumeAnalyser $this) {
        return $this.audioRecord;
    }

    public static final /* synthetic */ void access$setAudioRecord$p(AudioVolumeAnalyser $this, AudioRecord audioRecord) {
        $this.audioRecord = audioRecord;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/AudioVolumeAnalyser$Companion;", "", "()V", "AUDIO_FORMAT", "", "CHANNEL_CONFIG", "SAMPLE_RATE", "audioLevelKey", "", "defaultUpdateFrequencyMillis", "minAudioLevelTrigger", "", "minAudioRecordVolumeTrigger", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

