/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.utils;

import android.text.TextUtils;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.network.NetworkUtils;
import world.edgecenter.edgeconf.videocalls.state.LocalUserState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\u00102\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\rH\u0002\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019J*\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J:\u0010 \u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010(R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/UrlFactory;", "", "()V", "balancerHost", "", "getBalancerHost$edgeconf_sdk_release", "()Ljava/lang/String;", "setBalancerHost$edgeconf_sdk_release", "(Ljava/lang/String;)V", "balancerToken", "getBalancerToken$edgeconf_sdk_release", "setBalancerToken$edgeconf_sdk_release", "serversMapArray", "", "[[Ljava/lang/Object;", "serversMapping", "", "convertToMap", "mappingArray", "([[Ljava/lang/Object;)Ljava/util/Map;", "getConfigUrl", "hostName", "roomId", "getConfigUrl$edgeconf_sdk_release", "getDomainConfigUrl", "getDomainConfigUrl$edgeconf_sdk_release", "getInvitationLink", "isWebinar", "", "asParticipant", "getServIndex", "", "getSocketIOUrl", "port", "localUserState", "Lworld/edgecenter/edgeconf/videocalls/state/LocalUserState;", "apiEvent", "getTestStandHost", "getWebRtcHost", "getWebrtcServers", "(Ljava/lang/String;)[Ljava/lang/String;", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nUrlFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFactory.kt\nworld/edgecenter/edgeconf/videocalls/utils/UrlFactory\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n540#2:171\n525#2,6:172\n1#3:178\n*S KotlinDebug\n*F\n+ 1 UrlFactory.kt\nworld/edgecenter/edgeconf/videocalls/utils/UrlFactory\n*L\n161#1:171\n161#1:172,6\n*E\n"})
public final class UrlFactory {
    @NotNull
    public static final UrlFactory INSTANCE = new UrlFactory();
    @NotNull
    private static final Object[][] serversMapArray;
    @NotNull
    private static final Map<String, String[]> serversMapping;
    @Nullable
    private static String balancerHost;
    @Nullable
    private static String balancerToken;

    private UrlFactory() {
    }

    @JvmStatic
    @NotNull
    public static final String getInvitationLink(@NotNull String roomId, @NotNull String hostName, boolean isWebinar, boolean asParticipant) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        String roomType = isWebinar ? "webinar" : "call";
        Locale locale = Locale.US;
        String string = "https://%s/" + roomType + "/?roomId=%s";
        Object[] objectArray = new Object[]{hostName, roomId};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        Object url = string2;
        if (isWebinar && asParticipant) {
            url = (String)url + "&itisparticipant=true";
        }
        return url;
    }

    public static /* synthetic */ String getInvitationLink$default(String string, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return UrlFactory.getInvitationLink(string, string2, bl, bl2);
    }

    @NotNull
    public final String getDomainConfigUrl$edgeconf_sdk_release(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return "https://balancer.edgelive.ru/domain-config/" + roomId;
    }

    @NotNull
    public final String getConfigUrl$edgeconf_sdk_release(@NotNull String hostName, @NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        String host = NetworkUtils.INSTANCE.isTestStand(hostName) ? this.getTestStandHost(hostName) : this.getWebRtcHost(hostName, roomId);
        return "https://" + host + "/get-config";
    }

    @Nullable
    public final String getBalancerHost$edgeconf_sdk_release() {
        return balancerHost;
    }

    public final void setBalancerHost$edgeconf_sdk_release(@Nullable String string) {
        balancerHost = string;
    }

    @Nullable
    public final String getBalancerToken$edgeconf_sdk_release() {
        return balancerToken;
    }

    public final void setBalancerToken$edgeconf_sdk_release(@Nullable String string) {
        balancerToken = string;
    }

    @JvmStatic
    @NotNull
    public static final String getSocketIOUrl(@NotNull String hostName, @NotNull String roomId, int port, @NotNull LocalUserState localUserState2, boolean isWebinar, @Nullable String apiEvent) {
        String string;
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Intrinsics.checkNotNullParameter((Object)localUserState2, (String)"localUserState");
        String string2 = balancerHost;
        if (string2 == null) {
            string2 = NetworkUtils.INSTANCE.isTestStand(hostName) ? INSTANCE.getTestStandHost(hostName) : INSTANCE.getWebRtcHost(hostName, roomId);
        }
        String host = string2;
        String peerId = localUserState2.getId();
        String url = "https://" + host + ":" + port + "/?";
        url = url + "roomId=" + URLEncoder.encode(roomId, "UTF-8");
        url = url + "&peerId=" + URLEncoder.encode(peerId, "UTF-8");
        if (isWebinar) {
            url = url + "&webinar=true";
            if (localUserState2.isParticipant()) {
                url = url + "&itisparticipant=true";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)apiEvent)) {
            url = url + "&apiEvent=" + URLEncoder.encode(apiEvent, "UTF-8");
        }
        if ((string = balancerToken) == null) {
            string = URLEncoder.encode(localUserState2.getToken$edgeconf_sdk_release(), "UTF-8");
        }
        String token = string;
        url = url + "&token=" + token;
        return url;
    }

    private final Map<String, String[]> convertToMap(Object[][] mappingArray) {
        Map result = new LinkedHashMap();
        int n = ((Object[])mappingArray).length;
        for (int i = 0; i < n; ++i) {
            Object[] mapItem = mappingArray[i];
            Map map = result;
            Object object = mapItem[0];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)object;
            Object object2 = mapItem[1];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.String>");
            String[] stringArray = (String[])object2;
            map.put(string, stringArray);
        }
        return result;
    }

    private final int getServIndex(String roomId) {
        String roomIdWebrtcServPrefix = "serv";
        String string = roomId.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!StringsKt.startsWith$default((String)string, (String)roomIdWebrtcServPrefix, (boolean)false, (int)2, null)) {
            return 0;
        }
        char servIndexChar = roomId.charAt(roomIdWebrtcServPrefix.length());
        return Character.isDigit(servIndexChar) ? Integer.parseInt(String.valueOf(servIndexChar)) : 0;
    }

    private final String getWebRtcHost(String hostName, String roomId) {
        int servIndex = this.getServIndex(roomId);
        Object[] webRtcServers = this.getWebrtcServers(hostName);
        LLog.d("UrlFactory", "servIndex: (" + servIndex + ") webRtcServers for " + hostName + ": " + ArraysKt.joinToString$default((Object[])webRtcServers, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        Object[] objectArray = webRtcServers;
        if (servIndex < 0 || servIndex > ArraysKt.getLastIndex((Object[])objectArray)) {
            int it = servIndex;
            boolean bl = false;
            return "webrtc1.edgelive.ru";
        }
        Object webRtcHost = objectArray[servIndex];
        return webRtcHost;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getWebrtcServers(String hostName) {
        String[] servers;
        Iterator iterator;
        String[] defaultServers;
        block4: {
            void $this$filterNotTo$iv$iv;
            defaultServers = serversMapping.get("*");
            Map<String, String[]> $this$filterNot$iv = serversMapping;
            boolean $i$f$filterNot = false;
            Map<String, String[]> map = $this$filterNot$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator iterator22 = $this$filterNotTo$iv$iv.entrySet().iterator();
            while (iterator22.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator22.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it.getKey(), (Object)"*")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map filteredMapping = destination$iv$iv;
            Iterable iterable = filteredMapping.entrySet();
            for (Iterator iterator22 : iterable) {
                Map.Entry it = (Map.Entry)((Object)iterator22);
                boolean bl = false;
                if (!new Regex((String)it.getKey()).containsMatchIn((CharSequence)hostName)) continue;
                iterator = iterator22;
                break block4;
            }
            iterator = null;
        }
        Map.Entry entry = (Map.Entry)((Object)iterator);
        String[] stringArray = servers = entry != null ? (String[])entry.getValue() : null;
        if (servers == null) {
            stringArray = defaultServers;
            if (defaultServers == null) {
                stringArray = new String[]{};
            }
        }
        return stringArray;
    }

    private final String getTestStandHost(String hostName) {
        return StringsKt.substringBefore$default((String)hostName, (String)".", null, (int)2, null) + "-backend" + StringsKt.substringAfter$default((String)hostName, (String)"stand", null, (int)2, null);
    }

    static {
        Object[][] objectArrayArray = new Object[11][];
        Object[] objectArray = new Object[2];
        objectArray[0] = "edgecenter.ru$";
        String[] stringArray = new String[]{"webrtc1.edgelive.ru", "webrtc2.edgelive.ru"};
        objectArray[1] = stringArray;
        objectArrayArray[0] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "meet.econsult.lu";
        stringArray = new String[]{"meet-backend.econsult.lu"};
        objectArray[1] = stringArray;
        objectArrayArray[1] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "meet.preprod.curamedon.com";
        stringArray = new String[]{"meet-backend.preprod.curamedon.com"};
        objectArray[1] = stringArray;
        objectArrayArray[2] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "video.curamedon.com";
        stringArray = new String[]{"video-backend.curamedon.com"};
        objectArray[1] = stringArray;
        objectArrayArray[3] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "ehealth|econsult";
        stringArray = new String[]{"front-video.econsult.lu"};
        objectArray[1] = stringArray;
        objectArrayArray[4] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "meetv2|test.gvideo.co|internal-testing.gvideo.co";
        stringArray = new String[]{"webrtc-test.edgelive.ru"};
        objectArray[1] = stringArray;
        objectArrayArray[5] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "internal-preprod.gvideo.co";
        stringArray = new String[]{"webrtc-preprod.gvideo.co"};
        objectArray[1] = stringArray;
        objectArrayArray[6] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "meet-preprod|tinkoff.gvideo.co";
        stringArray = new String[]{"webrtc-preprod.edgelive.ru"};
        objectArray[1] = stringArray;
        objectArrayArray[7] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "cameo|hof360";
        stringArray = new String[]{"webrtc3.gvideo.co", "webrtc4.gvideo.co"};
        objectArray[1] = stringArray;
        objectArrayArray[8] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "bnionline|caremonitor|rello";
        stringArray = new String[]{"webrtc4.gvideo.co"};
        objectArray[1] = stringArray;
        objectArrayArray[9] = objectArray;
        objectArray = new Object[2];
        objectArray[0] = "*";
        stringArray = new String[]{"webrtc1.edgelive.ru", "webrtc2.edgelive.ru", "webrtc3.gvideo.co", "webrtc4.gvideo.co", "webrtc5.gvideo.co", "webrtc6.gvideo.co", "webrtc1.edgelive.ru"};
        objectArray[1] = stringArray;
        objectArrayArray[10] = objectArray;
        serversMapArray = objectArrayArray;
        serversMapping = INSTANCE.convertToMap(serversMapArray);
    }
}

