/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.text.TextUtils;
import io.github.crow_misia.webrtc.RTCComponentFactory;
import io.github.crow_misia.webrtc.option.MediaConstraintsOption;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.VideoCapturer;
import timber.log.Timber;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.utils.PeerConnectionUtils;
import world.edgecenter.edgeconf.videocalls.utils.Utils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J\u000f\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\tH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0007J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006%"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/Utils;", "", "()V", "ALLOWED_CHARACTERS", "", "TAG", "cameraEnumerator", "Lorg/webrtc/CameraEnumerator;", "openedCameraIndex", "", "Ljava/lang/Integer;", "createCamCapturer", "Lorg/webrtc/CameraVideoCapturer;", "context", "Landroid/content/Context;", "createComponentFactory", "Lio/github/crow_misia/webrtc/RTCComponentFactory;", "mediaConstraintsOption", "Lio/github/crow_misia/webrtc/option/MediaConstraintsOption;", "createMediaConstraintsOption", "camCapturer", "createPeerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "componentFactory", "getBackFacingCameraName", "getCameraId", "()Ljava/lang/Integer;", "getFrontFacingCameraName", "getRandomString", "sizeOfRandomString", "isFrontFacingCamera", "", "cameraId", "saveImageToGallery", "", "bitmap", "Landroid/graphics/Bitmap;", "edgeconf-sdk_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nworld/edgecenter/edgeconf/videocalls/utils/Utils\n+ 2 LLog.kt\nworld/edgecenter/edgeconf/videocalls/logger/LLog\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n99#2,5:203\n1#3:208\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nworld/edgecenter/edgeconf/videocalls/utils/Utils\n*L\n31#1:203,5\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final String ALLOWED_CHARACTERS = "0123456789qwertyuiopasdfghjklzxcvbnm";
    @NotNull
    private static final String TAG = "Utils";
    @Nullable
    private static CameraEnumerator cameraEnumerator;
    @Nullable
    private static Integer openedCameraIndex;

    private Utils() {
    }

    @JvmStatic
    @NotNull
    public static final CameraVideoCapturer createCamCapturer(@NotNull Context context) {
        String string;
        String[] deviceNames;
        CameraVideoCapturer capturer;
        CameraEnumerator cameraEnumerator;
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String tag$iv = TAG;
            boolean $i$f$d = false;
            if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                Timber.tag((String)tag$iv);
                boolean bl = false;
                Timber.d((String)"createCamCapturer()", (Object[])new Object[0]);
            }
            boolean isCamera2Supported = Camera2Enumerator.isSupported((Context)context);
            cameraEnumerator = isCamera2Supported ? (CameraEnumerator)new Camera2Enumerator(context) : (CameraEnumerator)new Camera1Enumerator();
            Utils.cameraEnumerator = cameraEnumerator;
            capturer = null;
            deviceNames = cameraEnumerator.getDeviceNames();
            Intrinsics.checkNotNullExpressionValue((Object)deviceNames, (String)"deviceNames");
            String[] stringArray = deviceNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String it = string2 = stringArray[i];
                boolean bl = false;
                if (!cameraEnumerator.isFrontFacing(it)) continue;
                string = string2;
                break block4;
            }
            string = null;
        }
        String selectedDeviceName = string;
        CameraVideoCapturer.CameraEventsHandler cameraHandler2 = new CameraVideoCapturer.CameraEventsHandler(deviceNames){
            final /* synthetic */ String[] $deviceNames;
            {
                this.$deviceNames = $deviceNames;
            }

            public void onCameraError(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                String tag$iv = "Utils";
                boolean $i$f$e = false;
                if (LLog.INSTANCE.isLoggable(6, tag$iv)) {
                    Timber.tag((String)tag$iv);
                    boolean bl = false;
                    Timber.e((String)("onCameraError, " + error), (Object[])new Object[0]);
                }
            }

            public void onCameraDisconnected() {
                LLog.w("Utils", (Function0<String>)((Function0)createCamCapturer.cameraHandler.onCameraDisconnected.1.INSTANCE));
            }

            public void onCameraFreezed(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                LLog.w("Utils", (Function0<String>)((Function0)new Function0<String>(error){
                    final /* synthetic */ String $error;
                    {
                        this.$error = $error;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "onCameraFreezed, " + this.$error;
                    }
                }));
            }

            public void onCameraOpening(@NotNull String cameraName) {
                Intrinsics.checkNotNullParameter((Object)cameraName, (String)"cameraName");
                Intrinsics.checkNotNullExpressionValue((Object)this.$deviceNames, (String)"deviceNames");
                Utils.access$setOpenedCameraIndex$p(ArraysKt.indexOf((Object[])this.$deviceNames, (Object)cameraName));
                String tag$iv = "Utils";
                boolean $i$f$d = false;
                if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                    Timber.tag((String)tag$iv);
                    boolean bl = false;
                    Timber.d((String)("onCameraOpening, " + cameraName), (Object[])new Object[0]);
                }
            }

            public void onFirstFrameAvailable() {
                String tag$iv = "Utils";
                boolean $i$f$d = false;
                if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                    Timber.tag((String)tag$iv);
                    boolean bl = false;
                    Timber.d((String)"onFirstFrameAvailable", (Object[])new Object[0]);
                }
            }

            public void onCameraClosed() {
                String tag$iv = "Utils";
                boolean $i$f$d = false;
                if (LLog.INSTANCE.isLoggable(3, tag$iv)) {
                    Timber.tag((String)tag$iv);
                    boolean bl = false;
                    Timber.d((String)"onCameraClosed", (Object[])new Object[0]);
                }
            }
        };
        if (!TextUtils.isEmpty((CharSequence)selectedDeviceName)) {
            capturer = cameraEnumerator.createCapturer(selectedDeviceName, cameraHandler2);
        }
        CameraVideoCapturer cameraVideoCapturer = capturer;
        if (cameraVideoCapturer == null) {
            boolean bl = false;
            String string3 = "Failed to create camera capturer";
            throw new IllegalStateException(string3.toString());
        }
        return cameraVideoCapturer;
    }

    @JvmStatic
    @NotNull
    public static final RTCComponentFactory createComponentFactory(@NotNull MediaConstraintsOption mediaConstraintsOption) {
        Intrinsics.checkNotNullParameter((Object)mediaConstraintsOption, (String)"mediaConstraintsOption");
        return new RTCComponentFactory(mediaConstraintsOption);
    }

    @JvmStatic
    @NotNull
    public static final MediaConstraintsOption createMediaConstraintsOption(@NotNull CameraVideoCapturer camCapturer) {
        MediaConstraintsOption mediaConstraintsOption;
        Intrinsics.checkNotNullParameter((Object)camCapturer, (String)"camCapturer");
        AudioAttributes audioAttrs = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
        MediaConstraintsOption it = mediaConstraintsOption = new MediaConstraintsOption();
        boolean bl = false;
        it.setAudioAttributes(audioAttrs);
        it.setAudioSource(7);
        it.enableAudioDownstream();
        it.enableAudioUpstream();
        it.enableVideoDownstream(PeerConnectionUtils.INSTANCE.getEglContext());
        it.enableVideoUpstream((VideoCapturer)camCapturer, PeerConnectionUtils.INSTANCE.getEglContext());
        return mediaConstraintsOption;
    }

    @JvmStatic
    @NotNull
    public static final PeerConnectionFactory createPeerConnectionFactory(@NotNull RTCComponentFactory componentFactory, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)componentFactory, (String)"componentFactory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return componentFactory.createPeerConnectionFactory(context, (Function2)createPeerConnectionFactory.1.INSTANCE);
    }

    @JvmStatic
    @Nullable
    public static final Integer getCameraId() {
        return openedCameraIndex;
    }

    @JvmStatic
    @NotNull
    public static final String getRandomString(int sizeOfRandomString) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(sizeOfRandomString);
        for (int i = 0; i < sizeOfRandomString; ++i) {
            sb.append(ALLOWED_CHARACTERS.charAt(random.nextInt(36)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmStatic
    public static final boolean isFrontFacingCamera(int cameraId) {
        CameraEnumerator cameraEnumerator = Utils.cameraEnumerator;
        if (cameraEnumerator == null) {
            boolean bl = false;
            String string = "cameraEnumerator is null";
            throw new IllegalStateException(string.toString());
        }
        CameraEnumerator camEnumerator = cameraEnumerator;
        return camEnumerator.isFrontFacing(camEnumerator.getDeviceNames()[cameraId]);
    }

    @JvmStatic
    @Nullable
    public static final String getFrontFacingCameraName() {
        Object object;
        block2: {
            CameraEnumerator cameraEnumerator = Utils.cameraEnumerator;
            if (cameraEnumerator == null) {
                boolean bl = false;
                String string = "cameraEnumerator is null";
                throw new IllegalStateException(string.toString());
            }
            CameraEnumerator camEnumerator = cameraEnumerator;
            String[] stringArray = camEnumerator.getDeviceNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"camEnumerator.deviceNames");
            for (Object object2 : (Object[])stringArray) {
                String it = (String)object2;
                boolean bl = false;
                if (!camEnumerator.isFrontFacing(it)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (String)object;
    }

    @JvmStatic
    @Nullable
    public static final String getBackFacingCameraName() {
        Object object;
        block2: {
            CameraEnumerator cameraEnumerator = Utils.cameraEnumerator;
            if (cameraEnumerator == null) {
                boolean bl = false;
                String string = "cameraEnumerator is null";
                throw new IllegalStateException(string.toString());
            }
            CameraEnumerator camEnumerator = cameraEnumerator;
            String[] stringArray = camEnumerator.getDeviceNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"camEnumerator.deviceNames");
            for (Object object2 : (Object[])stringArray) {
                String it = (String)object2;
                boolean bl = false;
                if (!camEnumerator.isBackFacing(it)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (String)object;
    }

    @JvmStatic
    public static final void saveImageToGallery(@NotNull Context context, @NotNull Bitmap bitmap) {
        Unit unit;
        Uri contentUri;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        ContentResolver resolver = context.getContentResolver();
        Uri imageStorageAddress = Build.VERSION.SDK_INT >= 29 ? MediaStore.Images.Media.getContentUri((String)"external_primary") : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentValues $this$saveImageToGallery_u24lambda_u249 = contentValues = new ContentValues();
        boolean bl = false;
        $this$saveImageToGallery_u24lambda_u249.put("_display_name", "my_app_" + System.currentTimeMillis() + ".jpg");
        $this$saveImageToGallery_u24lambda_u249.put("mime_type", "image/jpeg");
        $this$saveImageToGallery_u24lambda_u249.put("date_added", Long.valueOf(System.currentTimeMillis()));
        ContentValues imageDetails = contentValues;
        Uri uri = contentUri = resolver.insert(imageStorageAddress, imageDetails);
        if (uri != null) {
            Unit unit2;
            OutputStream outputStream;
            Uri uri2 = uri;
            boolean bl2 = false;
            OutputStream outputStream2 = outputStream = resolver.openOutputStream(uri2);
            if (outputStream2 != null) {
                OutputStream outStream = outputStream2;
                boolean bl3 = false;
                boolean isBitmapCompressed = bitmap.compress(Bitmap.CompressFormat.JPEG, 95, outStream);
                if (isBitmapCompressed) {
                    outStream.flush();
                    outStream.close();
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 == null) {
                throw new IOException("Failed to get output stream.");
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IOException("Failed to create new MediaStore record.");
        }
    }

    public static final /* synthetic */ void access$setOpenedCameraIndex$p(Integer n) {
        openedCameraIndex = n;
    }
}

