/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.utils.image;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import com.google.mlkit.vision.segmentation.SegmentationMask;
import io.github.crow_misia.libyuv.AbgrBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.I420Buffer;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.PlanePrimitive;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.JavaI420Buffer;
import org.webrtc.VideoFrame;
import world.edgecenter.edgeconf.videocalls.logger.LLog;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J.\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010!\u001a\u00020\u000fJ\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\rH\u0002J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\rJ\u001f\u0010'\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010!\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b(J\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020+0*2\u0006\u0010 \u001a\u00020\rH\u0002J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\tH\u0002J \u0010.\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameConverter;", "", "()V", "abgrBuffer", "Lio/github/crow_misia/libyuv/AbgrBuffer;", "argbBuffer", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "argbBufferBlurred", "i420Buffer", "Lio/github/crow_misia/libyuv/I420Buffer;", "paint", "Landroid/graphics/Paint;", "abgrBufferToFrame", "Lorg/webrtc/VideoFrame;", "frameWidth", "", "frameHeight", "rotation", "timestampNs", "", "applyBackgroundToBitmap", "Landroid/graphics/Bitmap;", "frameBitmap", "bgImageBitmap", "mask", "Lcom/google/mlkit/vision/segmentation/SegmentationMask;", "applyBackgroundToFrame", "frameRotation", "frameTimeStampsNs", "bitmapToFrame", "bitmap", "blurFrame", "frame", "blurRadius", "checkAndAllocateAbgrBuffer", "checkAndAllocateArgbBuffer", "checkAndAllocateI420Buffer", "frameToAbgrBuffer", "frameToBitmap", "frameToBlurredBitmap", "frameToBlurredBitmap$edgeconf_sdk_release", "frameToI420Buffer", "Lkotlin/Pair;", "Lorg/webrtc/VideoFrame$I420Buffer;", "i420BufferToAbgrBuffer", "buffer", "i420BufferToFrame", "segmentationMaskToColorsMask", "", "Companion", "edgeconf-sdk_release"})
public final class VideoFrameConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AbgrBuffer abgrBuffer;
    @Nullable
    private ArgbBuffer argbBuffer;
    @Nullable
    private ArgbBuffer argbBufferBlurred;
    @Nullable
    private I420Buffer i420Buffer;
    @NotNull
    private final Paint paint;
    @NotNull
    public static final String TAG = "VideoFrameConverter";

    /*
     * WARNING - void declaration
     */
    public VideoFrameConverter() {
        void it;
        Paint paint;
        Paint paint2 = paint = new Paint();
        VideoFrameConverter videoFrameConverter = this;
        boolean bl = false;
        it.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        videoFrameConverter.paint = paint;
    }

    private final VideoFrame abgrBufferToFrame(AbgrBuffer abgrBuffer, int frameWidth, int frameHeight, int rotation, long timestampNs) {
        I420Buffer i420Buffer = this.checkAndAllocateI420Buffer(frameWidth, frameHeight);
        abgrBuffer.convertTo(i420Buffer);
        return this.i420BufferToFrame(i420Buffer, rotation, timestampNs);
    }

    private final Bitmap applyBackgroundToBitmap(Bitmap frameBitmap, Bitmap bgImageBitmap, SegmentationMask mask) {
        Bitmap maskedFrameBitmap = Bitmap.createBitmap((int)frameBitmap.getWidth(), (int)frameBitmap.getHeight(), (Bitmap.Config)frameBitmap.getConfig());
        Canvas maskedFrameCanvas = new Canvas(maskedFrameBitmap);
        Bitmap maskBitmap = Bitmap.createBitmap((int[])this.segmentationMaskToColorsMask(mask), (int)frameBitmap.getWidth(), (int)frameBitmap.getHeight(), (Bitmap.Config)frameBitmap.getConfig());
        Matrix matrix = new Matrix();
        maskedFrameCanvas.drawBitmap(maskBitmap, matrix, null);
        maskedFrameCanvas.drawBitmap(frameBitmap, matrix, this.paint);
        Bitmap frameWithBgBitmap = Bitmap.createBitmap((int)frameBitmap.getWidth(), (int)frameBitmap.getHeight(), (Bitmap.Config)frameBitmap.getConfig());
        Canvas canvas2 = new Canvas(frameWithBgBitmap);
        canvas2.drawBitmap(bgImageBitmap, matrix, null);
        canvas2.drawBitmap(maskedFrameBitmap, matrix, null);
        Intrinsics.checkNotNullExpressionValue((Object)frameWithBgBitmap, (String)"frameWithBgBitmap");
        return frameWithBgBitmap;
    }

    @NotNull
    public final VideoFrame applyBackgroundToFrame(@NotNull Bitmap frameBitmap, int frameRotation, long frameTimeStampsNs, @NotNull Bitmap bgImageBitmap, @NotNull SegmentationMask mask) {
        Intrinsics.checkNotNullParameter((Object)frameBitmap, (String)"frameBitmap");
        Intrinsics.checkNotNullParameter((Object)bgImageBitmap, (String)"bgImageBitmap");
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Bitmap outBitmap = this.applyBackgroundToBitmap(frameBitmap, bgImageBitmap, mask);
        return this.bitmapToFrame(outBitmap, frameRotation, frameTimeStampsNs);
    }

    private final VideoFrame bitmapToFrame(Bitmap bitmap, int rotation, long timestampNs) {
        AbgrBuffer abgrBuffer = this.checkAndAllocateAbgrBuffer(bitmap.getWidth(), bitmap.getHeight());
        ByteBuffer buffer = abgrBuffer.asBuffer();
        buffer.rewind();
        bitmap.copyPixelsToBuffer((Buffer)abgrBuffer.asBuffer());
        return this.abgrBufferToFrame(abgrBuffer, bitmap.getWidth(), bitmap.getHeight(), rotation, timestampNs);
    }

    @NotNull
    public final synchronized VideoFrame blurFrame(@NotNull VideoFrame frame, int blurRadius) {
        ArgbBuffer argbBuffer;
        int height;
        int width;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                width = frame.getBuffer().getWidth();
                height = frame.getBuffer().getHeight();
                argbBuffer = this.checkAndAllocateArgbBuffer(width, height);
                if (this.argbBufferBlurred == null) break block2;
                ArgbBuffer argbBuffer2 = this.argbBufferBlurred;
                Intrinsics.checkNotNull((Object)argbBuffer2);
                if (argbBuffer2.getWidth() != width) break block2;
                ArgbBuffer argbBuffer3 = this.argbBufferBlurred;
                Intrinsics.checkNotNull((Object)argbBuffer3);
                if (argbBuffer3.getHeight() == height) break block3;
            }
            this.argbBufferBlurred = ArgbBuffer.Factory.allocate(width, height);
        }
        AbgrBuffer abgrBuffer = this.frameToAbgrBuffer(frame);
        abgrBuffer.convertTo(argbBuffer);
        ArgbBuffer argbBuffer4 = this.argbBufferBlurred;
        Intrinsics.checkNotNull((Object)argbBuffer4);
        argbBuffer.drawBlur(argbBuffer4, width, height, blurRadius);
        ArgbBuffer argbBuffer5 = this.argbBufferBlurred;
        Intrinsics.checkNotNull((Object)argbBuffer5);
        argbBuffer5.convertTo(abgrBuffer);
        return this.abgrBufferToFrame(abgrBuffer, width, height, frame.getRotation(), frame.getTimestampNs());
    }

    public static /* synthetic */ VideoFrame blurFrame$default(VideoFrameConverter videoFrameConverter, VideoFrame videoFrame, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 45;
        }
        return videoFrameConverter.blurFrame(videoFrame, n);
    }

    @NotNull
    public final synchronized Bitmap frameToBlurredBitmap$edgeconf_sdk_release(@NotNull VideoFrame frame, int blurRadius) {
        ArgbBuffer argbBuffer;
        int height;
        int width;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                width = frame.getBuffer().getWidth();
                height = frame.getBuffer().getHeight();
                argbBuffer = this.checkAndAllocateArgbBuffer(width, height);
                if (this.argbBufferBlurred == null) break block2;
                ArgbBuffer argbBuffer2 = this.argbBufferBlurred;
                Intrinsics.checkNotNull((Object)argbBuffer2);
                if (argbBuffer2.getWidth() != width) break block2;
                ArgbBuffer argbBuffer3 = this.argbBufferBlurred;
                Intrinsics.checkNotNull((Object)argbBuffer3);
                if (argbBuffer3.getHeight() == height) break block3;
            }
            this.argbBufferBlurred = ArgbBuffer.Factory.allocate(width, height);
        }
        AbgrBuffer abgrBuffer = this.frameToAbgrBuffer(frame);
        abgrBuffer.convertTo(argbBuffer);
        ArgbBuffer argbBuffer4 = this.argbBufferBlurred;
        Intrinsics.checkNotNull((Object)argbBuffer4);
        argbBuffer.drawBlur(argbBuffer4, width, height, blurRadius);
        ArgbBuffer argbBuffer5 = this.argbBufferBlurred;
        Intrinsics.checkNotNull((Object)argbBuffer5);
        argbBuffer5.convertTo(abgrBuffer);
        return abgrBuffer.asBitmap();
    }

    public static /* synthetic */ Bitmap frameToBlurredBitmap$edgeconf_sdk_release$default(VideoFrameConverter videoFrameConverter, VideoFrame videoFrame, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 45;
        }
        return videoFrameConverter.frameToBlurredBitmap$edgeconf_sdk_release(videoFrame, n);
    }

    private final AbgrBuffer frameToAbgrBuffer(VideoFrame frame) {
        AbgrBuffer abgrBuffer;
        AbgrBuffer abgrBuffer2;
        Pair<I420Buffer, VideoFrame.I420Buffer> pair = this.frameToI420Buffer(frame);
        I420Buffer i420Buffer = (I420Buffer)pair.component1();
        VideoFrame.I420Buffer frameI420Buffer = (VideoFrame.I420Buffer)pair.component2();
        AbgrBuffer it = abgrBuffer2 = (abgrBuffer = this.i420BufferToAbgrBuffer(i420Buffer));
        boolean bl = false;
        i420Buffer.close();
        frameI420Buffer.release();
        return abgrBuffer2;
    }

    @NotNull
    public final Bitmap frameToBitmap(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        AbgrBuffer abgrBuffer = this.frameToAbgrBuffer(frame);
        return abgrBuffer.asBitmap();
    }

    private final Pair<I420Buffer, VideoFrame.I420Buffer> frameToI420Buffer(VideoFrame frame) {
        VideoFrame.I420Buffer i420Buffer = frame.getBuffer().toI420();
        Intrinsics.checkNotNull((Object)i420Buffer);
        VideoFrame.I420Buffer frameBufferI420 = i420Buffer;
        int n = frameBufferI420.getStrideY();
        ByteBuffer byteBuffer = frameBufferI420.getDataY();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"frameBufferI420.dataY");
        Plane plane = (Plane)new PlanePrimitive(n, byteBuffer);
        int n2 = frameBufferI420.getStrideU();
        ByteBuffer byteBuffer2 = frameBufferI420.getDataU();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"frameBufferI420.dataU");
        Plane plane2 = (Plane)new PlanePrimitive(n2, byteBuffer2);
        int n3 = frameBufferI420.getStrideV();
        ByteBuffer byteBuffer3 = frameBufferI420.getDataV();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"frameBufferI420.dataV");
        I420Buffer i420Buffer2 = I420Buffer.Factory.wrap(plane, plane2, (Plane)new PlanePrimitive(n3, byteBuffer3), frameBufferI420.getWidth(), frameBufferI420.getHeight());
        return new Pair((Object)i420Buffer2, (Object)frameBufferI420);
    }

    private final AbgrBuffer i420BufferToAbgrBuffer(I420Buffer buffer) {
        AbgrBuffer abgrBuffer = this.checkAndAllocateAbgrBuffer(buffer.getWidth(), buffer.getHeight());
        buffer.convertTo(abgrBuffer);
        return abgrBuffer;
    }

    private final VideoFrame i420BufferToFrame(I420Buffer i420Buffer, int rotation, long timestampNs) {
        return new VideoFrame((VideoFrame.Buffer)JavaI420Buffer.wrap((int)i420Buffer.getWidth(), (int)i420Buffer.getHeight(), (ByteBuffer)i420Buffer.getPlaneY().getBuffer(), (int)i420Buffer.getPlaneY().getRowStride(), (ByteBuffer)i420Buffer.getPlaneU().getBuffer(), (int)i420Buffer.getPlaneU().getRowStride(), (ByteBuffer)i420Buffer.getPlaneV().getBuffer(), (int)i420Buffer.getPlaneV().getRowStride(), null), rotation, timestampNs);
    }

    private final AbgrBuffer checkAndAllocateAbgrBuffer(int frameWidth, int frameHeight) {
        block3: {
            block2: {
                if (this.abgrBuffer == null) break block2;
                AbgrBuffer abgrBuffer = this.abgrBuffer;
                Intrinsics.checkNotNull((Object)abgrBuffer);
                if (abgrBuffer.getWidth() != frameWidth) break block2;
                AbgrBuffer abgrBuffer2 = this.abgrBuffer;
                Intrinsics.checkNotNull((Object)abgrBuffer2);
                if (abgrBuffer2.getHeight() == frameHeight) break block3;
            }
            this.abgrBuffer = AbgrBuffer.Factory.allocate(frameWidth, frameHeight);
        }
        AbgrBuffer abgrBuffer = this.abgrBuffer;
        Intrinsics.checkNotNull((Object)abgrBuffer);
        return abgrBuffer;
    }

    private final ArgbBuffer checkAndAllocateArgbBuffer(int frameWidth, int frameHeight) {
        block3: {
            block2: {
                if (this.argbBuffer == null) break block2;
                ArgbBuffer argbBuffer = this.argbBuffer;
                Intrinsics.checkNotNull((Object)argbBuffer);
                if (argbBuffer.getWidth() != frameWidth) break block2;
                ArgbBuffer argbBuffer2 = this.argbBuffer;
                Intrinsics.checkNotNull((Object)argbBuffer2);
                if (argbBuffer2.getHeight() == frameHeight) break block3;
            }
            this.argbBuffer = ArgbBuffer.Factory.allocate(frameWidth, frameHeight);
        }
        ArgbBuffer argbBuffer = this.argbBuffer;
        Intrinsics.checkNotNull((Object)argbBuffer);
        return argbBuffer;
    }

    private final I420Buffer checkAndAllocateI420Buffer(int frameWidth, int frameHeight) {
        block3: {
            block2: {
                if (this.i420Buffer == null) break block2;
                I420Buffer i420Buffer = this.i420Buffer;
                Intrinsics.checkNotNull((Object)i420Buffer);
                if (i420Buffer.getWidth() != frameWidth) break block2;
                I420Buffer i420Buffer2 = this.i420Buffer;
                Intrinsics.checkNotNull((Object)i420Buffer2);
                if (i420Buffer2.getHeight() == frameHeight) break block3;
            }
            this.i420Buffer = I420Buffer.Factory.allocate(frameWidth, frameHeight);
        }
        I420Buffer i420Buffer = this.i420Buffer;
        Intrinsics.checkNotNull((Object)i420Buffer);
        return i420Buffer;
    }

    private final int[] segmentationMaskToColorsMask(SegmentationMask mask) {
        int size = mask.getWidth() * mask.getHeight();
        int[] colors = new int[size];
        mask.getBuffer().rewind();
        try {
            for (int i = 0; i < size; ++i) {
                float backgroundLikelihood = mask.getBuffer().getFloat();
                if ((double)backgroundLikelihood > 0.9) {
                    colors[i] = Color.argb((int)255, (int)255, (int)0, (int)255);
                    continue;
                }
                if (!((double)backgroundLikelihood > 0.3)) continue;
                int alpha = (int)(182.9 * (double)backgroundLikelihood - 36.6 + 0.5);
                colors[i] = Color.argb((int)alpha, (int)255, (int)0, (int)255);
            }
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            LLog.d(TAG, "segmentationMaskToColorsMask error \n " + string + " \n " + e.getStackTrace()[0]);
            return colors;
        }
        return colors;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameConverter$Companion;", "", "()V", "TAG", "", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

