/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.utils.image;

import android.graphics.Bitmap;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetection;
import com.google.mlkit.vision.face.FaceDetector;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.webrtc.VideoFrame;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.utils.image.VideoFrameConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00038B@BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameFaceDetector;", "", "initialHasFace", "", "faceDetectingFrameInterval", "", "(ZI)V", "detectorOptions", "Lcom/google/mlkit/vision/face/FaceDetectorOptions;", "faceDetector", "Lcom/google/mlkit/vision/face/FaceDetector;", "frameConverter", "Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameConverter;", "frameCount", "<set-?>", "hasFace", "isDetectingInProgress", "detectFace", "", "frame", "Lorg/webrtc/VideoFrame;", "rotation", "release", "Companion", "edgeconf-sdk_release"})
public final class VideoFrameFaceDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int faceDetectingFrameInterval;
    private int frameCount;
    private boolean hasFace;
    private boolean isDetectingInProgress;
    @NotNull
    private final FaceDetectorOptions detectorOptions;
    @NotNull
    private final FaceDetector faceDetector;
    @NotNull
    private final VideoFrameConverter frameConverter;
    @NotNull
    private static final String TAG = "FaceDetectionUtils";

    @JvmOverloads
    public VideoFrameFaceDetector(boolean initialHasFace, int faceDetectingFrameInterval) {
        this.faceDetectingFrameInterval = faceDetectingFrameInterval;
        this.hasFace = initialHasFace;
        FaceDetectorOptions faceDetectorOptions = new FaceDetectorOptions.Builder().setPerformanceMode(1).setContourMode(2).setClassificationMode(1).build();
        Intrinsics.checkNotNullExpressionValue((Object)faceDetectorOptions, (String)"Builder().setPerformance\u2026CATION_MODE_NONE).build()");
        this.detectorOptions = faceDetectorOptions;
        FaceDetector faceDetector = FaceDetection.getClient((FaceDetectorOptions)this.detectorOptions);
        Intrinsics.checkNotNullExpressionValue((Object)faceDetector, (String)"getClient(detectorOptions)");
        this.faceDetector = faceDetector;
        this.frameConverter = new VideoFrameConverter();
    }

    public /* synthetic */ VideoFrameFaceDetector(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 40;
        }
        this(bl, n);
    }

    public final boolean hasFace(@NotNull VideoFrame frame, int rotation) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int n = this.frameCount;
        this.frameCount = n + 1;
        if (this.frameCount >= this.faceDetectingFrameInterval && !this.isDetectingInProgress) {
            this.detectFace(frame, rotation);
            this.frameCount = 0;
        }
        return this.hasFace;
    }

    public final void release() {
        this.faceDetector.close();
    }

    private final void detectFace(VideoFrame frame, int rotation) {
        this.isDetectingInProgress = true;
        Bitmap bitmap = this.frameConverter.frameToBitmap(frame);
        InputImage inputImage = InputImage.fromBitmap((Bitmap)bitmap, (int)rotation);
        Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromBitmap(\n            \u2026tation,\n                )");
        InputImage inputImage2 = inputImage;
        this.faceDetector.process(inputImage2).addOnFailureListener(arg_0 -> VideoFrameFaceDetector.detectFace$lambda$0(this, arg_0)).addOnSuccessListener(arg_0 -> VideoFrameFaceDetector.detectFace$lambda$1((Function1)new Function1<List<Face>, Unit>(this){
            final /* synthetic */ VideoFrameFaceDetector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<Face> faces) {
                Intrinsics.checkNotNullExpressionValue(faces, (String)"faces");
                VideoFrameFaceDetector.access$setHasFace$p(this.this$0, !((Collection)faces).isEmpty());
                VideoFrameFaceDetector.access$setDetectingInProgress$p(this.this$0, false);
            }
        }, arg_0));
    }

    @JvmOverloads
    public VideoFrameFaceDetector(boolean initialHasFace) {
        this(initialHasFace, 0, 2, null);
    }

    @JvmOverloads
    public VideoFrameFaceDetector() {
        this(false, 0, 3, null);
    }

    private static final void detectFace$lambda$0(VideoFrameFaceDetector this$0, Exception e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LLog.d(TAG, "face detector failed: " + e.getMessage());
        this$0.isDetectingInProgress = false;
    }

    private static final void detectFace$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setHasFace$p(VideoFrameFaceDetector $this, boolean bl) {
        $this.hasFace = bl;
    }

    public static final /* synthetic */ void access$setDetectingInProgress$p(VideoFrameFaceDetector $this, boolean bl) {
        $this.isDetectingInProgress = bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameFaceDetector$Companion;", "", "()V", "TAG", "", "edgeconf-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

