/*
 * Decompiled with CFR 0.152.
 */
package world.edgecenter.edgeconf.videocalls.utils.image;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.segmentation.SegmentationMask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.VideoFrame;
import world.edgecenter.edgeconf.videocalls.logger.LLog;
import world.edgecenter.edgeconf.videocalls.utils.image.VideoFrameConverter;
import world.edgecenter.edgeconf.videocalls.utils.image.VideoFrameSegmenter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00120\u0017J;\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001b\u001a\u00020\n2!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00120\u0017J\u0014\u0010\u001c\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameProcessor;", "", "()V", "TAG", "", "cachedBgImage", "Landroid/graphics/Bitmap;", "converter", "Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameConverter;", "frameRotation", "", "Ljava/lang/Integer;", "isApplyingBg", "", "rotatedBgImage", "segmenter", "Lworld/edgecenter/edgeconf/videocalls/utils/image/VideoFrameSegmenter;", "applyBackgroundToFrame", "", "frame", "Lorg/webrtc/VideoFrame;", "bgImage", "sink", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "applyBlurToFrame", "blurRadius", "rotate", "degrees", "edgeconf-sdk_release"})
public final class VideoFrameProcessor {
    @NotNull
    public static final VideoFrameProcessor INSTANCE = new VideoFrameProcessor();
    @NotNull
    private static final String TAG = "VideoFrameProcessor";
    @NotNull
    private static final VideoFrameSegmenter segmenter = new VideoFrameSegmenter();
    @NotNull
    private static final VideoFrameConverter converter = new VideoFrameConverter();
    @Nullable
    private static Bitmap cachedBgImage;
    @Nullable
    private static Bitmap rotatedBgImage;
    @Nullable
    private static Integer frameRotation;
    private static boolean isApplyingBg;

    private VideoFrameProcessor() {
    }

    public final void applyBackgroundToFrame(@NotNull VideoFrame frame, @NotNull Bitmap bgImage, @NotNull Function1<? super VideoFrame, Unit> sink) {
        block5: {
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                    Intrinsics.checkNotNullParameter((Object)bgImage, (String)"bgImage");
                    Intrinsics.checkNotNullParameter(sink, (String)"sink");
                    if (isApplyingBg) break block5;
                    isApplyingBg = true;
                    if (cachedBgImage != bgImage) break block6;
                    Integer n = frameRotation;
                    int n2 = frame.getRotation();
                    if (n != null && n == n2) break block7;
                }
                cachedBgImage = bgImage;
                frameRotation = frame.getRotation();
                rotatedBgImage = this.rotate(bgImage, frame.getRotation());
            }
            long startFrameToBitmapTime = System.currentTimeMillis();
            Bitmap frameBitmap = converter.frameToBitmap(frame);
            LLog.d(TAG, "time to convert videoFrame to bitmap: " + (System.currentTimeMillis() - startFrameToBitmapTime) + " ms");
            long startGettingMaskTime = System.currentTimeMillis();
            InputImage inputImage = InputImage.fromBitmap((Bitmap)frameBitmap, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromBitmap(frameBitmap, 0)");
            SegmentationMask segmentationMask = segmenter.getSegmentationMask$edgeconf_sdk_release(inputImage);
            if (segmentationMask == null) {
                VideoFrameProcessor $this$applyBackgroundToFrame_u24lambda_u240 = this;
                boolean bl = false;
                sink.invoke((Object)frame);
                isApplyingBg = false;
                return;
            }
            SegmentationMask mask = segmentationMask;
            LLog.d(TAG, "time of getting mask for videoFrame: " + (System.currentTimeMillis() - startGettingMaskTime) + " ms");
            Bitmap bitmap = rotatedBgImage;
            if (bitmap == null) {
                VideoFrameProcessor $this$applyBackgroundToFrame_u24lambda_u241 = this;
                boolean bl = false;
                sink.invoke((Object)frame);
                isApplyingBg = false;
                return;
            }
            Bitmap rotatedBgImage = bitmap;
            long startApplyingBgTime = System.currentTimeMillis();
            VideoFrame processedFrame = converter.applyBackgroundToFrame(frameBitmap, frame.getRotation(), frame.getTimestampNs(), rotatedBgImage, mask);
            LLog.d(TAG, "time of applying virutal-bg for videoFrame: " + (System.currentTimeMillis() - startApplyingBgTime) + " ms");
            sink.invoke((Object)processedFrame);
            isApplyingBg = false;
        }
    }

    public final void applyBlurToFrame(@NotNull VideoFrame frame, int blurRadius, @NotNull Function1<? super VideoFrame, Unit> sink) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        if (!isApplyingBg) {
            isApplyingBg = true;
            long startFrameToBitmapTime = System.currentTimeMillis();
            Bitmap frameBitmap = converter.frameToBitmap(frame);
            LLog.d(TAG, "-----------------------------------------------------");
            LLog.d(TAG, "time to convert videoFrame to bitmap: " + (System.currentTimeMillis() - startFrameToBitmapTime) + " ms");
            long startGettingMaskTime = System.currentTimeMillis();
            InputImage inputImage = InputImage.fromBitmap((Bitmap)frameBitmap, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromBitmap(frameBitmap, 0)");
            SegmentationMask segmentationMask = segmenter.getSegmentationMask$edgeconf_sdk_release(inputImage);
            if (segmentationMask == null) {
                VideoFrameProcessor $this$applyBlurToFrame_u24lambda_u242 = this;
                boolean bl = false;
                sink.invoke((Object)frame);
                isApplyingBg = false;
                return;
            }
            SegmentationMask mask = segmentationMask;
            LLog.d(TAG, "time of getting mask for videoFrame: " + (System.currentTimeMillis() - startGettingMaskTime) + " ms");
            long startBlurringFrameTime = System.currentTimeMillis();
            Bitmap blurredFrameBitmap = converter.frameToBlurredBitmap$edgeconf_sdk_release(frame, blurRadius);
            LLog.d(TAG, "time of blurring videoFrame: " + (System.currentTimeMillis() - startBlurringFrameTime) + " ms");
            long startApplyingBgTime = System.currentTimeMillis();
            VideoFrame processedFrame = converter.applyBackgroundToFrame(frameBitmap, frame.getRotation(), frame.getTimestampNs(), blurredFrameBitmap, mask);
            LLog.d(TAG, "time of applying virutal-bg for videoFrame: " + (System.currentTimeMillis() - startApplyingBgTime) + " ms");
            LLog.d(TAG, "-----------------------------------------------------");
            sink.invoke((Object)processedFrame);
            isApplyingBg = false;
        }
    }

    public static /* synthetic */ void applyBlurToFrame$default(VideoFrameProcessor videoFrameProcessor, VideoFrame videoFrame, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 45;
        }
        videoFrameProcessor.applyBlurToFrame(videoFrame, n, (Function1<? super VideoFrame, Unit>)function1);
    }

    private final Bitmap rotate(Bitmap $this$rotate, int degrees) {
        Matrix matrix;
        Matrix $this$rotate_u24lambda_u243 = matrix = new Matrix();
        boolean bl = false;
        $this$rotate_u24lambda_u243.postRotate(-((float)degrees));
        Matrix matrix2 = matrix;
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)$this$rotate, (int)0, (int)0, (int)$this$rotate.getWidth(), (int)$this$rotate.getHeight(), (Matrix)matrix2, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(this, 0, 0,\u2026th, height, matrix, true)");
        return bitmap;
    }
}

