/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.axiom.attachments.Attachments;

public class MIMEBodyPartInputStream
extends InputStream {
    PushbackInputStream inStream;
    boolean boundaryFound;
    Attachments parent;
    byte[] boundary;

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary) {
        this.inStream = inStream;
        this.boundary = boundary;
    }

    public MIMEBodyPartInputStream(PushbackInputStream inStream, byte[] boundary, Attachments parent) {
        this(inStream, boundary);
        this.parent = parent;
    }

    public int read() throws IOException {
        int boundaryIndex;
        if (this.boundaryFound) {
            return -1;
        }
        int value = this.inStream.read();
        if (value == 13) {
            value = this.inStream.read();
            if (value != 10) {
                this.inStream.unread(value);
                return 13;
            }
            value = this.inStream.read();
            if ((byte)value != this.boundary[0]) {
                this.inStream.unread(value);
                this.inStream.unread(10);
                return 13;
            }
        } else if ((byte)value != this.boundary[0]) {
            return value;
        }
        for (boundaryIndex = 0; boundaryIndex < this.boundary.length - 1 && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
            value = this.inStream.read();
        }
        if (boundaryIndex == this.boundary.length - 1) {
            this.boundaryFound = true;
            value = this.inStream.read();
            if (value == 45) {
                value = this.inStream.read();
                if (value == 45 && this.parent != null) {
                    this.parent.setEndOfStream(true);
                }
            } else {
                this.inStream.read();
            }
            return -1;
        }
        if (value != -1) {
            this.inStream.unread(value);
        }
        this.inStream.unread(this.boundary, 1, boundaryIndex - 1);
        return this.boundary[0];
    }

    public boolean getBoundaryStatus() {
        return this.boundaryFound;
    }
}

