/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.soap.SOAPFactory;

public class OMAbstractFactory {
    public static final String OM_FACTORY_NAME_PROPERTY = "om.factory";
    public static final String SOAP11_FACTORY_NAME_PROPERTY = "soap11.factory";
    public static final String SOAP12_FACTORY_NAME_PROPERTY = "soap12.factory";
    private static final String DEFAULT_OM_FACTORY_CLASS_NAME = "org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory";
    private static final String DEFAULT_SOAP11_FACTORY_CLASS_NAME = "org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory";
    private static final String DEFAULT_SOAP12_FACTORY_CLASS_NAME = "org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory";

    public static OMFactory getOMFactory() {
        try {
            String omFactory = System.getProperty(OM_FACTORY_NAME_PROPERTY);
            if (omFactory == null || "".equals(omFactory)) {
                omFactory = DEFAULT_OM_FACTORY_CLASS_NAME;
            }
            return (OMFactory)Class.forName(omFactory).newInstance();
        }
        catch (InstantiationException e) {
            throw new OMException(e);
        }
        catch (IllegalAccessException e) {
            throw new OMException(e);
        }
        catch (ClassNotFoundException e) {
            throw new OMException(e);
        }
    }

    public static SOAPFactory getSOAP11Factory() {
        try {
            String omFactory = System.getProperty(SOAP11_FACTORY_NAME_PROPERTY);
            if (omFactory == null || "".equals(omFactory)) {
                omFactory = DEFAULT_SOAP11_FACTORY_CLASS_NAME;
            }
            return (SOAPFactory)Class.forName(omFactory).newInstance();
        }
        catch (InstantiationException e) {
            throw new OMException(e);
        }
        catch (IllegalAccessException e) {
            throw new OMException(e);
        }
        catch (ClassNotFoundException e) {
            throw new OMException(e);
        }
    }

    public static SOAPFactory getSOAP12Factory() {
        try {
            String omFactory = System.getProperty(SOAP12_FACTORY_NAME_PROPERTY);
            if (omFactory == null || "".equals(omFactory)) {
                omFactory = DEFAULT_SOAP12_FACTORY_CLASS_NAME;
            }
            return (SOAPFactory)Class.forName(omFactory).newInstance();
        }
        catch (InstantiationException e) {
            throw new OMException(e);
        }
        catch (IllegalAccessException e) {
            throw new OMException(e);
        }
        catch (ClassNotFoundException e) {
            throw new OMException(e);
        }
    }
}

