/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.util;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;

public class OMSerializerUtil {
    static long nsCounter = 0L;

    public static void serializeEndpart(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    public static void serializeAttribute(OMAttribute attr, XMLStreamWriter writer) throws XMLStreamException {
        OMNamespace ns = attr.getNamespace();
        String prefix = null;
        String namespaceName = null;
        if (ns != null) {
            prefix = ns.getPrefix();
            namespaceName = ns.getName();
            if (prefix != null) {
                writer.writeAttribute(prefix, namespaceName, attr.getLocalName(), attr.getAttributeValue());
            } else {
                writer.writeAttribute(namespaceName, attr.getLocalName(), attr.getAttributeValue());
            }
        } else {
            String localName = attr.getLocalName();
            String attributeValue = attr.getAttributeValue();
            writer.writeAttribute(localName, attributeValue);
        }
    }

    public static void serializeNamespace(OMNamespace namespace, XMLStreamWriter writer) throws XMLStreamException {
        if (namespace == null) {
            return;
        }
        String uri = namespace.getName();
        String prefix = namespace.getPrefix();
        if (uri != null && !"".equals(uri)) {
            String prefixFromWriter = writer.getPrefix(uri);
            if ("".equals(prefix) && "".equals(prefixFromWriter) && !uri.equals(writer.getNamespaceContext().getNamespaceURI("")) || prefix != null && "".equals(prefix) && (prefixFromWriter == null || !prefix.equals(prefixFromWriter))) {
                writer.writeDefaultNamespace(uri);
                writer.setDefaultNamespace(uri);
            } else {
                String string = prefix = prefix == null ? OMSerializerUtil.getNextNSPrefix(writer) : prefix;
                if (prefix != null && !prefix.equals(prefixFromWriter) && !OMSerializerUtil.checkForPrefixInTheCurrentContext(writer, uri, prefix)) {
                    writer.writeNamespace(prefix, uri);
                    writer.setPrefix(prefix, uri);
                }
            }
        }
    }

    public static void serializeStartpart(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        if (element.getNamespace() != null) {
            String nameSpaceName = element.getNamespace().getName();
            String prefix = element.getNamespace().getPrefix();
            if (nameSpaceName != null && !"".equals(nameSpaceName)) {
                String writer_prefix = writer.getPrefix(nameSpaceName);
                if (writer_prefix == null && !"".equals(prefix)) {
                    prefix = prefix == null ? OMSerializerUtil.getNextNSPrefix(writer) : prefix;
                    writer.writeStartElement(prefix, element.getLocalName(), nameSpaceName);
                    writer.writeNamespace(prefix, nameSpaceName);
                    writer.setPrefix(prefix, nameSpaceName);
                } else if (prefix == null) {
                    writer.writeStartElement(nameSpaceName, element.getLocalName());
                } else if ("".equals(prefix) && "".equals(writer_prefix)) {
                    if (nameSpaceName.equals(writer.getNamespaceContext().getNamespaceURI(""))) {
                        writer.writeStartElement(nameSpaceName, element.getLocalName());
                    } else {
                        writer.writeStartElement(prefix, element.getLocalName(), nameSpaceName);
                        writer.writeDefaultNamespace(nameSpaceName);
                        writer.setDefaultNamespace(nameSpaceName);
                    }
                } else if (prefix.equals(writer_prefix)) {
                    writer.writeStartElement(nameSpaceName, element.getLocalName());
                } else if ("".equals(prefix)) {
                    writer.writeStartElement(prefix, element.getLocalName(), nameSpaceName);
                    writer.writeDefaultNamespace(nameSpaceName);
                    writer.setDefaultNamespace(nameSpaceName);
                } else {
                    boolean found = OMSerializerUtil.checkForPrefixInTheCurrentContext(writer, nameSpaceName, prefix);
                    if (!found) {
                        writer.writeStartElement(prefix, element.getLocalName(), nameSpaceName);
                        writer.writeNamespace(prefix, nameSpaceName);
                        writer.setPrefix(prefix, nameSpaceName);
                    } else {
                        writer.writeStartElement(prefix, element.getLocalName(), nameSpaceName);
                    }
                }
            } else {
                writer.writeStartElement(element.getLocalName());
            }
        } else {
            writer.writeStartElement(element.getLocalName());
        }
        OMSerializerUtil.serializeNamespaces(element, writer);
        OMSerializerUtil.serializeAttributes(element, writer);
    }

    private static boolean checkForPrefixInTheCurrentContext(XMLStreamWriter writer, String nameSpaceName, String prefix) throws XMLStreamException {
        Iterator<String> prefixesIter = writer.getNamespaceContext().getPrefixes(nameSpaceName);
        while (prefixesIter.hasNext()) {
            String prefix_w = prefixesIter.next();
            if (!prefix_w.equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public static void serializeNamespaces(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        Iterator namespaces = element.getAllDeclaredNamespaces();
        if (namespaces != null) {
            while (namespaces.hasNext()) {
                OMSerializerUtil.serializeNamespace((OMNamespace)namespaces.next(), writer);
            }
        }
    }

    public static void serializeAttributes(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        Iterator attributes = element.getAllAttributes();
        if (attributes != null && attributes.hasNext()) {
            while (attributes.hasNext()) {
                OMSerializerUtil.serializeAttribute((OMAttribute)attributes.next(), writer);
            }
        }
    }

    public static void serializeNormal(OMElement element, XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (cache) {
            element.build();
        }
        OMSerializerUtil.serializeStartpart(element, writer);
        OMNode firstChild = element.getFirstOMChild();
        if (firstChild != null) {
            if (cache) {
                ((OMNodeEx)firstChild).serialize(writer);
            } else {
                ((OMNodeEx)firstChild).serializeAndConsume(writer);
            }
        }
        OMSerializerUtil.serializeEndpart(writer);
    }

    public static void serializeByPullStream(OMElement element, XMLStreamWriter writer) throws XMLStreamException {
        OMSerializerUtil.serializeByPullStream(element, writer, false);
    }

    public static void serializeByPullStream(OMElement element, XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        StreamingOMSerializer streamingOMSerializer = new StreamingOMSerializer();
        if (cache) {
            streamingOMSerializer.serialize(element.getXMLStreamReader(), writer);
        } else {
            XMLStreamReader xmlStreamReaderWithoutCaching = element.getXMLStreamReaderWithoutCaching();
            streamingOMSerializer.serialize(xmlStreamReaderWithoutCaching, writer);
        }
    }

    public static String getNextNSPrefix() {
        return "axis2ns" + ++nsCounter % Long.MAX_VALUE;
    }

    public static String getNextNSPrefix(XMLStreamWriter writer) {
        String prefix = OMSerializerUtil.getNextNSPrefix();
        while (writer.getNamespaceContext().getNamespaceURI(prefix) != null) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        return prefix;
    }
}

