/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ws.schild.jave.FFMPEGExecutor;
import ws.schild.jave.FFMPEGLocator;

public class DefaultFFMPEGLocator
extends FFMPEGLocator {
    private static final Log LOG = LogFactory.getLog(FFMPEGExecutor.class);
    private static final String MY_EXE_VERSION = "2.5.0";
    private final String path;

    public DefaultFFMPEGLocator() {
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("windows");
        boolean isMac = os.contains("mac");
        LOG.debug((Object)("Os name is <" + os + "> isWindows: " + isWindows + " isMac: " + isMac));
        File dirFolder = new File(System.getProperty("java.io.tmpdir"), "jave/");
        if (!dirFolder.exists()) {
            LOG.debug((Object)("Creating jave temp folder to place executables in <" + dirFolder.getAbsolutePath() + ">"));
            dirFolder.mkdirs();
        } else {
            LOG.debug((Object)("Jave temp folder exists in <" + dirFolder.getAbsolutePath() + ">"));
        }
        String suffix = isWindows ? ".exe" : (isMac ? "-osx" : "");
        String arch = System.getProperty("os.arch");
        File ffmpegFile = new File(dirFolder, "ffmpeg-" + arch + "-" + MY_EXE_VERSION + suffix);
        LOG.debug((Object)("Executable path: " + ffmpegFile.getAbsolutePath()));
        if (ffmpegFile.exists()) {
            LOG.debug((Object)("Executable exists in <" + ffmpegFile.getAbsolutePath() + ">"));
        } else {
            LOG.debug((Object)("Need to copy executable to <" + ffmpegFile.getAbsolutePath() + ">"));
            this.copyFile("ffmpeg-" + arch + suffix, ffmpegFile);
        }
        if (!isWindows) {
            try {
                Runtime.getRuntime().exec(new String[]{"/bin/chmod", "755", ffmpegFile.getAbsolutePath()});
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        this.path = ffmpegFile.getAbsolutePath();
        LOG.debug((Object)("ffmpeg executable found: " + this.path));
    }

    @Override
    protected String getFFMPEGExecutablePath() {
        return this.path;
    }

    private void copyFile(String path, File dest) {
        String resourceName = "native/" + path;
        try {
            LOG.debug((Object)("Copy from resource <" + resourceName + "> to target <" + dest.getAbsolutePath() + ">"));
            if (this.copy(this.getClass().getResourceAsStream(resourceName), dest.getAbsolutePath())) {
                if (dest.exists()) {
                    LOG.debug((Object)("Target <" + dest.getAbsolutePath() + "> exists"));
                } else {
                    LOG.fatal((Object)("Target <" + dest.getAbsolutePath() + "> does not exist"));
                }
            } else {
                LOG.fatal((Object)("Copy resource to target <" + dest.getAbsolutePath() + "> failed"));
            }
        }
        catch (NullPointerException ex) {
            LOG.error((Object)("Could not find ffmpeg executable for " + resourceName + " is the correct platform jar included?"));
            throw ex;
        }
    }

    private boolean copy(InputStream source, String destination) {
        boolean success = true;
        try {
            Files.copy(source, Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            LOG.fatal((Object)("Cannot write file " + destination), (Throwable)ex);
            success = false;
        }
        return success;
    }
}

