/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.AudioAttributes;
import ws.schild.jave.ConversionOutputAnalyzer;
import ws.schild.jave.DefaultFFMPEGLocator;
import ws.schild.jave.EncoderException;
import ws.schild.jave.EncoderProgressListener;
import ws.schild.jave.EncodingAttributes;
import ws.schild.jave.FFMPEGExecutor;
import ws.schild.jave.FFMPEGLocator;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.MultimediaInfo;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.RBufferedReader;
import ws.schild.jave.VideoAttributes;
import ws.schild.jave.VideoFilter;
import ws.schild.jave.VideoSize;

public class Encoder {
    private static final Logger LOG = LoggerFactory.getLogger(Encoder.class);
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^\\s*([D ])([E ])\\s+([\\w,]+)\\s+.+$");
    private static final Pattern ENCODER_DECODER_PATTERN = Pattern.compile("^\\s*([AVS]).{5}\\s(\\S+).(.+)$", 2);
    private static final Pattern SUCCESS_PATTERN = Pattern.compile("^\\s*video\\:\\S+\\s+audio\\:\\S+\\s+subtitle\\:\\S+\\s+global headers\\:\\S+.*$", 2);
    private final FFMPEGLocator locator;
    private FFMPEGExecutor ffmpeg;
    private List<String> unhandledMessages = null;

    public Encoder() {
        this.locator = new DefaultFFMPEGLocator();
    }

    public Encoder(FFMPEGLocator locator) {
        this.locator = locator;
    }

    public String[] getAudioDecoders() throws EncoderException {
        return this.getCoders(false, true);
    }

    public String[] getAudioEncoders() throws EncoderException {
        return this.getCoders(true, true);
    }

    protected String[] getCoders(boolean encoder, boolean audio) throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor localFFMPEG = this.locator.createExecutor();
        localFFMPEG.addArgument(encoder ? "-encoders" : "-decoders");
        try {
            String line;
            localFFMPEG.execute();
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(localFFMPEG.getInputStream()));
            String format = audio ? "A" : "V";
            boolean headerFound = false;
            boolean evaluateLine = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (headerFound) {
                    if (evaluateLine) {
                        Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            String audioVideoFlag = matcher.group(1);
                            if (!format.equals(audioVideoFlag)) continue;
                            String name = matcher.group(2);
                            res.add(name);
                            continue;
                        }
                        break;
                    }
                    evaluateLine = line.trim().equals("------");
                    continue;
                }
                if (!line.trim().equals(encoder ? "Encoders:" : "Decoders:")) continue;
                headerFound = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            localFFMPEG.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getVideoDecoders() throws EncoderException {
        return this.getCoders(false, false);
    }

    public String[] getVideoEncoders() throws EncoderException {
        return this.getCoders(true, false);
    }

    public String[] getSupportedEncodingFormats() throws EncoderException {
        return this.getSupportedCodingFormats(true);
    }

    protected String[] getSupportedCodingFormats(boolean encoding) throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor localFFMPEG = this.locator.createExecutor();
        localFFMPEG.addArgument("-formats");
        try {
            String line;
            localFFMPEG.execute();
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(localFFMPEG.getInputStream()));
            String ed = encoding ? "E" : "D";
            boolean headerFound = false;
            boolean evaluateLine = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (headerFound) {
                    if (evaluateLine) {
                        Matcher matcher = FORMAT_PATTERN.matcher(line);
                        if (!matcher.matches()) break;
                        String encoderFlag = matcher.group(encoding ? 2 : 1);
                        if (!ed.equals(encoderFlag)) continue;
                        String aux = matcher.group(3);
                        StringTokenizer st = new StringTokenizer(aux, ",");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken().trim();
                            if (res.contains(token)) continue;
                            res.add(token);
                        }
                        continue;
                    }
                    evaluateLine = line.trim().equals("--");
                    continue;
                }
                if (!line.trim().equals("File formats:")) continue;
                headerFound = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            localFFMPEG.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getSupportedDecodingFormats() throws EncoderException {
        return this.getSupportedCodingFormats(false);
    }

    public void encode(MultimediaObject multimediaObject, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encode(multimediaObject, target, attributes, null);
    }

    public void encode(List<MultimediaObject> multimediaObjects, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encode(multimediaObjects, target, attributes, null);
    }

    public void encode(MultimediaObject multimediaObject, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        ArrayList<MultimediaObject> src = new ArrayList<MultimediaObject>();
        src.add(multimediaObject);
        this.encode(src, target, attributes, listener);
    }

    public void encode(List<MultimediaObject> multimediaObjects, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        Integer quality;
        String codec;
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        this.ffmpeg = this.locator.createExecutor();
        if (attributes.getFilterThreads() != -1) {
            this.ffmpeg.addArgument("--filter_thread");
            this.ffmpeg.addArgument(Integer.toString(attributes.getFilterThreads()));
        }
        if (offsetAttribute != null) {
            this.ffmpeg.addArgument("-ss");
            this.ffmpeg.addArgument(String.valueOf(offsetAttribute.floatValue()));
        }
        if (attributes.getDecodingThreads() != -1) {
            this.ffmpeg.addArgument("-threads");
            this.ffmpeg.addArgument(Integer.toString(attributes.getDecodingThreads()));
        }
        this.ffmpeg.addArgument("-i");
        if (multimediaObjects.size() == 1) {
            if (multimediaObjects.get(0).isURL()) {
                this.ffmpeg.addArgument(multimediaObjects.get(0).getURL().toString());
            } else {
                this.ffmpeg.addArgument(multimediaObjects.get(0).getFile().getAbsolutePath());
            }
        } else {
            StringBuilder inFiles = new StringBuilder();
            inFiles.append("concat:");
            boolean isFirst = true;
            for (MultimediaObject in : multimediaObjects) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    inFiles.append("|");
                }
                if (in.isURL()) {
                    inFiles.append(in.getURL().toString());
                    continue;
                }
                inFiles.append(in.getFile().getAbsolutePath());
            }
            this.ffmpeg.addArgument(inFiles.toString());
        }
        if (durationAttribute != null) {
            this.ffmpeg.addArgument("-t");
            this.ffmpeg.addArgument(String.valueOf(durationAttribute.floatValue()));
        }
        if (videoAttributes == null) {
            this.ffmpeg.addArgument("-vn");
        } else {
            VideoSize size;
            Integer frameRate;
            Integer bitRate;
            String tag;
            codec = videoAttributes.getCodec();
            if (codec != null) {
                this.ffmpeg.addArgument("-vcodec");
                this.ffmpeg.addArgument(codec);
            }
            if ((tag = videoAttributes.getTag()) != null) {
                this.ffmpeg.addArgument("-vtag");
                this.ffmpeg.addArgument(tag);
            }
            if ((bitRate = videoAttributes.getBitRate()) != null) {
                this.ffmpeg.addArgument("-vb");
                this.ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((frameRate = videoAttributes.getFrameRate()) != null) {
                this.ffmpeg.addArgument("-r");
                this.ffmpeg.addArgument(String.valueOf(frameRate));
            }
            if ((size = videoAttributes.getSize()) != null) {
                this.ffmpeg.addArgument("-s");
                this.ffmpeg.addArgument(String.valueOf(size.getWidth()) + "x" + String.valueOf(size.getHeight()));
            }
            if (videoAttributes.isFaststart()) {
                this.ffmpeg.addArgument("-movflags");
                this.ffmpeg.addArgument("faststart");
            }
            if (videoAttributes.getX264Profile() != null) {
                this.ffmpeg.addArgument("-profile:v");
                this.ffmpeg.addArgument(videoAttributes.getX264Profile().getModeName());
            }
            if (videoAttributes.getVideoFilters().size() > 0) {
                for (VideoFilter videoFilter : videoAttributes.getVideoFilters()) {
                    this.ffmpeg.addArgument("-vf");
                    this.ffmpeg.addArgument(videoFilter.getExpression());
                }
            }
            if ((quality = videoAttributes.getQuality()) != null) {
                this.ffmpeg.addArgument("-qscale:v");
                this.ffmpeg.addArgument(String.valueOf(quality));
            }
        }
        if (audioAttributes == null) {
            this.ffmpeg.addArgument("-an");
        } else {
            Integer volume;
            Integer samplingRate;
            Integer channels;
            Integer bitRate;
            codec = audioAttributes.getCodec();
            if (codec != null) {
                this.ffmpeg.addArgument("-acodec");
                this.ffmpeg.addArgument(codec);
            }
            if ((bitRate = audioAttributes.getBitRate()) != null) {
                this.ffmpeg.addArgument("-ab");
                this.ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((channels = audioAttributes.getChannels()) != null) {
                this.ffmpeg.addArgument("-ac");
                this.ffmpeg.addArgument(String.valueOf(channels));
            }
            if ((samplingRate = audioAttributes.getSamplingRate()) != null) {
                this.ffmpeg.addArgument("-ar");
                this.ffmpeg.addArgument(String.valueOf(samplingRate));
            }
            if ((volume = audioAttributes.getVolume()) != null) {
                this.ffmpeg.addArgument("-vol");
                this.ffmpeg.addArgument(String.valueOf(volume));
            }
            if ((quality = audioAttributes.getQuality()) != null) {
                this.ffmpeg.addArgument("-qscale:a");
                this.ffmpeg.addArgument(String.valueOf(quality));
            }
        }
        if (formatAttribute != null) {
            this.ffmpeg.addArgument("-f");
            this.ffmpeg.addArgument(formatAttribute);
        }
        if (attributes.getEncodingThreads() != -1) {
            this.ffmpeg.addArgument("-threads");
            this.ffmpeg.addArgument(Integer.toString(attributes.getEncodingThreads()));
        }
        this.ffmpeg.addArgument("-y");
        this.ffmpeg.addArgument(target.getAbsolutePath());
        if (attributes.isMapMetaData()) {
            this.ffmpeg.addArgument("-map_metadata");
            this.ffmpeg.addArgument("0");
        }
        try {
            this.ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            String lastWarning = null;
            long duration = 0L;
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(this.ffmpeg.getErrorStream()));
            MultimediaInfo info = null;
            if (!(multimediaObjects.size() != 1 || multimediaObjects.get(0).isURL() && multimediaObjects.get(0).isReadURLOnce())) {
                info = multimediaObjects.get(0).getInfo();
            }
            if (durationAttribute != null) {
                duration = Math.round(durationAttribute.floatValue() * 1000.0f);
            } else if (info != null) {
                duration = info.getDuration();
                if (offsetAttribute != null) {
                    duration -= (long)Math.round(offsetAttribute.floatValue() * 1000.0f);
                }
            }
            if (listener != null) {
                listener.sourceInfo(info);
            }
            ConversionOutputAnalyzer outputAnalyzer = new ConversionOutputAnalyzer(duration, listener);
            while ((line = reader.readLine()) != null) {
                outputAnalyzer.analyzeNewLine(line);
            }
            if (outputAnalyzer.getLastWarning() != null && !SUCCESS_PATTERN.matcher(lastWarning).matches()) {
                throw new EncoderException("No match for: " + SUCCESS_PATTERN + " in " + lastWarning);
            }
            this.unhandledMessages = outputAnalyzer.getUnhandledMessages();
            int exitCode = this.ffmpeg.getProcessExitCode();
            if (exitCode != 0) {
                LOG.error("Process exit code: {}  to {}", (Object)exitCode, (Object)target.getName());
                throw new EncoderException("Exit code of ffmpeg encoding run is " + exitCode);
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            this.ffmpeg.destroy();
            this.ffmpeg = null;
        }
    }

    public List<String> getUnhandledMessages() {
        return this.unhandledMessages;
    }

    public void abortEncoding() {
        if (this.ffmpeg != null) {
            this.ffmpeg.destroy();
            this.ffmpeg = null;
        }
    }
}

