/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.Serializable;
import java.util.ArrayList;
import ws.schild.jave.VideoFilter;
import ws.schild.jave.VideoSize;

public class VideoAttributes
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String DIRECT_STREAM_COPY = "copy";
    private String codec = null;
    private String tag = null;
    private Integer bitRate = null;
    private Integer frameRate = null;
    private VideoSize size = null;
    private Integer quality = null;
    private final ArrayList<VideoFilter> videoFilters = new ArrayList();
    private boolean faststart = false;
    private X264_PROFILE x264Profile = null;

    String getCodec() {
        return this.codec;
    }

    public VideoAttributes setCodec(String codec) {
        this.codec = codec;
        return this;
    }

    String getTag() {
        return this.tag;
    }

    public VideoAttributes setTag(String tag) {
        this.tag = tag;
        return this;
    }

    Integer getBitRate() {
        return this.bitRate;
    }

    public VideoAttributes setBitRate(Integer bitRate) {
        this.bitRate = bitRate;
        return this;
    }

    Integer getFrameRate() {
        return this.frameRate;
    }

    public VideoAttributes setFrameRate(Integer frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    VideoSize getSize() {
        return this.size;
    }

    public VideoAttributes setSize(VideoSize size) {
        this.size = size;
        return this;
    }

    public boolean isFaststart() {
        return this.faststart;
    }

    public void addFilter(VideoFilter videoFilter) {
        this.videoFilters.add(videoFilter);
    }

    public ArrayList<VideoFilter> getVideoFilters() {
        return this.videoFilters;
    }

    public VideoAttributes setFaststart(boolean faststart) {
        this.faststart = faststart;
        return this;
    }

    public Integer getQuality() {
        return this.quality;
    }

    public VideoAttributes setQuality(Integer quality) {
        this.quality = quality;
        return this;
    }

    public String toString() {
        return this.getClass().getName() + "(codec=" + this.codec + ", bitRate=" + this.bitRate + ", frameRate=" + this.frameRate + ", size=" + this.size + ", faststart=" + this.faststart + ", quality=" + this.quality + ")";
    }

    public X264_PROFILE getX264Profile() {
        return this.x264Profile;
    }

    public VideoAttributes setX264Profile(X264_PROFILE x264Profile) {
        this.x264Profile = x264Profile;
        return this;
    }

    public static enum X264_PROFILE {
        BASELINE("baseline"),
        MAIN("main"),
        HIGH("high"),
        HIGH10("high10"),
        HIGH422("high422"),
        HIGH444("high444");

        private final String modeName;

        private X264_PROFILE(String modeName) {
            this.modeName = modeName;
        }

        public String getModeName() {
            return this.modeName;
        }
    }
}

