/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters.helpers;

import java.util.Optional;

public enum OverlayLocation {
    TOP_LEFT(null, null),
    TOP_RIGHT("main_w-overlay_w", null),
    BOTTOM_RIGHT("main_w-overlay_w", "main_h-overlay_h"),
    BOTTOM_LEFT(null, "main_h-overlay_h");

    private Optional<String> x;
    private Optional<String> y;

    private OverlayLocation(String x, String y) {
        this.x = Optional.ofNullable(x);
        this.y = Optional.ofNullable(y);
    }

    public String getExpression(Optional<Integer> offsetX, Optional<Integer> offsetY) {
        return this.getX(offsetX) + ":" + this.getY(offsetY);
    }

    private static String resolveExpression(Optional<String> location, Optional<Integer> offset) {
        Optional<String> offsetValue = offset.map(Object::toString);
        return location.map(loc -> loc.concat(offsetValue.orElse(""))).orElse(offsetValue.orElse("0"));
    }

    public String getX(Optional<Integer> offset) {
        return OverlayLocation.resolveExpression(this.x, offset);
    }

    public String getY(Optional<Integer> offset) {
        return OverlayLocation.resolveExpression(this.y, offset);
    }
}

