/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filtergraphs;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ws.schild.jave.filters.ConcatFilter;
import ws.schild.jave.filters.FilterChain;
import ws.schild.jave.filters.FilterGraph;
import ws.schild.jave.filters.MovieFilter;
import ws.schild.jave.filters.OverlayFilter;
import ws.schild.jave.filters.helpers.OverlayLocation;

public abstract class FilterAndWatermark
extends FilterGraph {
    public FilterAndWatermark(File watermark, List<FilterChain> inputFilterChains) {
        IntStream.range(0, inputFilterChains.size()).mapToObj(i -> this.prepFilterChain((FilterChain)inputFilterChains.get(i), i)).forEach(this::addChain);
        this.addChain(new FilterChain(new ConcatFilter(IntStream.range(0, inputFilterChains.size()).mapToObj(this::labelForOutput).collect(Collectors.toList())).addOutputLabel("concatenated")));
        this.addChain(new FilterChain(new MovieFilter(watermark), new OverlayFilter("concatenated", OverlayLocation.BOTTOM_RIGHT, -10, -10)));
    }

    private FilterChain prepFilterChain(FilterChain chain, Integer i) {
        return chain.setInputLabel(i.toString()).setOutputLabel(this.labelForOutput(i));
    }

    private String labelForOutput(Integer i) {
        return "filtered" + i;
    }
}

