/*
 * Decompiled with CFR 0.152.
 */
package ws.wamp.jawampa.transport.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import ws.wamp.jawampa.ApplicationError;
import ws.wamp.jawampa.WampMessages;
import ws.wamp.jawampa.WampSerialization;
import ws.wamp.jawampa.connection.IPendingWampConnection;
import ws.wamp.jawampa.connection.IPendingWampConnectionListener;
import ws.wamp.jawampa.connection.IWampClientConnectionConfig;
import ws.wamp.jawampa.connection.IWampConnection;
import ws.wamp.jawampa.connection.IWampConnectionListener;
import ws.wamp.jawampa.connection.IWampConnectionPromise;
import ws.wamp.jawampa.connection.IWampConnector;
import ws.wamp.jawampa.connection.IWampConnectorProvider;
import ws.wamp.jawampa.transport.netty.ConnectionEstablishedEvent;
import ws.wamp.jawampa.transport.netty.NettyWampConnectionConfig;
import ws.wamp.jawampa.transport.netty.WampClientWebsocketHandler;

public class NettyWampClientConnectorProvider
implements IWampConnectorProvider {
    public ScheduledExecutorService createScheduler() {
        NioEventLoopGroup scheduler = new NioEventLoopGroup(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "WampClientEventLoop");
                t.setDaemon(true);
                return t;
            }
        });
        return scheduler;
    }

    public IWampConnector createConnector(final URI uri, IWampClientConnectionConfig configuration, List<WampSerialization> serializations) throws Exception {
        NettyWampConnectionConfig nettyConfig;
        String scheme = uri.getScheme();
        String string = scheme = scheme != null ? scheme : "";
        if (configuration instanceof NettyWampConnectionConfig) {
            nettyConfig = (NettyWampConnectionConfig)configuration;
        } else {
            if (configuration != null) {
                throw new ApplicationError("jawampa.error.invalid_connection_configuration");
            }
            nettyConfig = null;
        }
        if (scheme.equalsIgnoreCase("ws") || scheme.equalsIgnoreCase("wss")) {
            SslContext sslCtx0;
            if (uri.getHost() == null || uri.getPort() == 0) {
                throw new ApplicationError("wamp.error.invalid_uri");
            }
            final boolean needSsl = uri.getScheme().equalsIgnoreCase("wss");
            if (needSsl && (nettyConfig == null || nettyConfig.sslContext() == null)) {
                sslCtx0 = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            } else {
                sslCtx0 = needSsl ? nettyConfig.sslContext() : null;
            }
            final String subProtocols = WampSerialization.makeWebsocketSubprotocolList(serializations);
            int maxFramePayloadLength = nettyConfig == null ? 65535 : nettyConfig.getMaxFramePayloadLength();
            DefaultHttpHeaders httpHeaders = nettyConfig == null ? new DefaultHttpHeaders() : nettyConfig.getHttpHeaders();
            return new IWampConnector((HttpHeaders)httpHeaders, maxFramePayloadLength, sslCtx0){
                final /* synthetic */ HttpHeaders val$httpHeaders;
                final /* synthetic */ int val$maxFramePayloadLength;
                final /* synthetic */ SslContext val$sslCtx0;
                {
                    this.val$httpHeaders = httpHeaders;
                    this.val$maxFramePayloadLength = n;
                    this.val$sslCtx0 = sslContext;
                }

                public IPendingWampConnection connect(ScheduledExecutorService scheduler, final IPendingWampConnectionListener connectListener, final IWampConnectionListener connectionListener) {
                    final int port = uri.getPort() == -1 ? (needSsl ? 443 : 80) : uri.getPort();
                    final WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)subProtocols, (boolean)false, (HttpHeaders)this.val$httpHeaders, (int)this.val$maxFramePayloadLength);
                    SimpleChannelInboundHandler<WampMessages.WampMessage> connectionHandler = new SimpleChannelInboundHandler<WampMessages.WampMessage>(){
                        boolean connectionWasEstablished = false;
                        boolean wasClosed = false;

                        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                            if (this.wasClosed) {
                                return;
                            }
                            this.wasClosed = true;
                            if (this.connectionWasEstablished) {
                                connectionListener.transportClosed();
                            } else {
                                connectListener.connectFailed((Throwable)new ApplicationError("jawampa.error.transport_closed"));
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            if (this.wasClosed) {
                                return;
                            }
                            this.wasClosed = true;
                            if (this.connectionWasEstablished) {
                                connectionListener.transportError(cause);
                            } else {
                                connectListener.connectFailed(cause);
                            }
                        }

                        public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (this.wasClosed) {
                                return;
                            }
                            if (evt instanceof ConnectionEstablishedEvent) {
                                ConnectionEstablishedEvent ev = (ConnectionEstablishedEvent)evt;
                                final WampSerialization serialization = ev.serialization();
                                IWampConnection connection = new IWampConnection(){

                                    public WampSerialization serialization() {
                                        return serialization;
                                    }

                                    public boolean isSingleWriteOnly() {
                                        return false;
                                    }

                                    public void sendMessage(WampMessages.WampMessage message, final IWampConnectionPromise<Void> promise) {
                                        ChannelFuture f = ctx.writeAndFlush((Object)message);
                                        f.addListener((GenericFutureListener)new ChannelFutureListener(){

                                            public void operationComplete(ChannelFuture future) throws Exception {
                                                if (future.isSuccess() || future.isCancelled()) {
                                                    promise.fulfill(null);
                                                } else {
                                                    promise.reject(future.cause());
                                                }
                                            }
                                        });
                                    }

                                    public void close(boolean sendRemaining, final IWampConnectionPromise<Void> promise) {
                                        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)new ChannelFutureListener(){

                                            public void operationComplete(ChannelFuture future) throws Exception {
                                                future.channel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

                                                    public void operationComplete(ChannelFuture future) throws Exception {
                                                        if (future.isSuccess() || future.isCancelled()) {
                                                            promise.fulfill(null);
                                                        } else {
                                                            promise.reject(future.cause());
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    }
                                };
                                this.connectionWasEstablished = true;
                                connectListener.connectSucceeded(connection);
                            }
                        }

                        protected void channelRead0(ChannelHandlerContext ctx, WampMessages.WampMessage msg) throws Exception {
                            if (this.wasClosed) {
                                return;
                            }
                            assert (this.connectionWasEstablished);
                            connectionListener.messageReceived(msg);
                        }
                    };
                    if (!(scheduler instanceof EventLoopGroup)) {
                        connectListener.connectFailed((Throwable)new ApplicationError("jawampa.error.incompatible_scheduler"));
                        return IPendingWampConnection.Dummy;
                    }
                    EventLoopGroup nettyEventLoop = (EventLoopGroup)scheduler;
                    Bootstrap b = new Bootstrap();
                    ((Bootstrap)((Bootstrap)b.group(nettyEventLoop)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>((ChannelHandler)connectionHandler){
                        final /* synthetic */ ChannelHandler val$connectionHandler;
                        {
                            this.val$connectionHandler = channelHandler;
                        }

                        protected void initChannel(SocketChannel ch) {
                            ChannelPipeline p = ch.pipeline();
                            if (val$sslCtx0 != null) {
                                p.addLast(new ChannelHandler[]{val$sslCtx0.newHandler(ch.alloc(), uri.getHost(), port)});
                            }
                            p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), new WebSocketClientProtocolHandler(handshaker, false), new WebSocketFrameAggregator(0x1000000), new WampClientWebsocketHandler(handshaker), this.val$connectionHandler});
                        }
                    });
                    final ChannelFuture connectFuture = b.connect(uri.getHost(), port);
                    connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                connectListener.connectFailed(future.cause());
                            }
                        }
                    });
                    return new IPendingWampConnection(){

                        public void cancelConnect() {
                            connectFuture.cancel(false);
                        }
                    };
                }
            };
        }
        throw new ApplicationError("wamp.error.invalid_uri");
    }
}

