/*
 * Decompiled with CFR 0.152.
 */
package ws.wamp.jawampa.transport.netty;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.SslContext;
import ws.wamp.jawampa.connection.IWampClientConnectionConfig;

public class NettyWampConnectionConfig
implements IWampClientConnectionConfig {
    static final int DEFAULT_MAX_FRAME_PAYLOAD_LENGTH = 65535;
    SslContext sslContext;
    int maxFramePayloadLength;
    HttpHeaders httpHeaders;

    NettyWampConnectionConfig(SslContext sslContext, int maxFramePayloadLength, HttpHeaders httpHeaders) {
        this.sslContext = sslContext;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.httpHeaders = httpHeaders;
    }

    public SslContext sslContext() {
        return this.sslContext;
    }

    public int getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public static class Builder {
        SslContext sslContext;
        int maxFramePayloadLength = 65535;
        HttpHeaders httpHeaders = new DefaultHttpHeaders();

        public Builder withSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withMaxFramePayloadLength(int maxFramePayloadLength) {
            if (maxFramePayloadLength <= 0) {
                throw new IllegalArgumentException("maxFramePayloadLength parameter cannot be negative");
            }
            this.maxFramePayloadLength = maxFramePayloadLength;
            return this;
        }

        public Builder withHttpHeader(String name, Object value) {
            this.httpHeaders.add(name, value);
            return this;
        }

        public NettyWampConnectionConfig build() {
            return new NettyWampConnectionConfig(this.sslContext, this.maxFramePayloadLength, this.httpHeaders);
        }
    }
}

