/*
 * Decompiled with CFR 0.152.
 */
package ws.wamp.jawampa.transport.netty;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import ws.wamp.jawampa.WampError;
import ws.wamp.jawampa.WampSerialization;
import ws.wamp.jawampa.transport.netty.ConnectionEstablishedEvent;
import ws.wamp.jawampa.transport.netty.WampDeserializationHandler;
import ws.wamp.jawampa.transport.netty.WampSerializationHandler;

public class WampClientWebsocketHandler
extends ChannelInboundHandlerAdapter {
    final WebSocketClientHandshaker handshaker;
    WampSerialization serialization;

    public WampSerialization serialization() {
        return this.serialization;
    }

    public WampClientWebsocketHandler(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            String actualProtocol = this.handshaker.actualSubprotocol();
            this.serialization = WampSerialization.fromString((String)actualProtocol);
            if (this.serialization == WampSerialization.Invalid) {
                throw new WampError("Invalid Websocket Protocol");
            }
            ctx.pipeline().addAfter(ctx.name(), "wamp-deserializer", (ChannelHandler)new WampDeserializationHandler(this.serialization));
            ctx.pipeline().addAfter(ctx.name(), "wamp-serializer", (ChannelHandler)new WampSerializationHandler(this.serialization));
            ctx.fireUserEventTriggered((Object)new ConnectionEstablishedEvent(this.serialization));
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

