/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.mime;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import wtf.g4s8.mime.MimeTypeComparators;
import wtf.g4s8.mime.MimeTypeOfString;

public interface MimeType {
    public String type();

    public String subtype();

    public Set<String> params();

    public Optional<String> param(String var1);

    public static MimeType of(CharSequence src) {
        return new MimeTypeOfString(src);
    }

    public static Collection<MimeType> parse(CharSequence src) {
        Predicate<MimeType> pred = new Predicate<MimeType>(){
            final Set<String> types = new HashSet<String>();

            @Override
            public boolean test(MimeType type) {
                boolean check;
                String key = String.format("%s/%s", type.type(), type.subtype());
                if (this.types.contains(key)) {
                    check = false;
                } else {
                    this.types.add(key);
                    check = true;
                }
                return check;
            }
        };
        return Arrays.stream(src.toString().split(",")).map(String::trim).map(MimeTypeOfString::new).sorted(MimeTypeComparators.BY_QUALIFIER.thenComparing(MimeTypeComparators.BY_TYPE).thenComparing(MimeTypeComparators.BY_SUBTYPE)).filter(pred).collect(Collectors.toList());
    }

    public static abstract class Wrap
    implements MimeType {
        private final MimeType origin;

        protected Wrap(MimeType origin) {
            this.origin = origin;
        }

        @Override
        public final String type() {
            return this.origin.type();
        }

        @Override
        public String subtype() {
            return this.origin.subtype();
        }

        @Override
        public Set<String> params() {
            return this.origin.params();
        }

        @Override
        public Optional<String> param(String name) {
            return this.origin.param(name);
        }

        public String toString() {
            return this.origin.toString();
        }
    }
}

