/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.mime.test;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import wtf.g4s8.mime.MimeType;

public final class HmMimeHasParam
extends TypeSafeMatcher<MimeType> {
    private final String name;
    private final Matcher<String> expected;

    public HmMimeHasParam(String name, String expected) {
        this(name, (Matcher<String>)CoreMatchers.equalTo((Object)expected));
    }

    public HmMimeHasParam(String name, Matcher<String> expected) {
        super(MimeType.class);
        this.name = name;
        this.expected = expected;
    }

    public boolean matchesSafely(MimeType type) {
        return type.param(this.name).map(arg_0 -> this.expected.matches(arg_0)).orElse(false);
    }

    public void describeTo(Description description) {
        description.appendText("MIME with param ").appendDescriptionOf((SelfDescribing)new ParamDescription(this.name, this.expected));
    }

    public void describeMismatchSafely(MimeType item, Description desc) {
        Optional<String> opt = item.param(this.name);
        if (opt.isPresent()) {
            desc.appendText("was param ").appendDescriptionOf((SelfDescribing)new ParamDescription(this.name, opt.get()));
        } else {
            desc.appendText("no param `").appendValue((Object)this.name).appendText("`");
        }
    }

    private static class ParamDescription
    implements SelfDescribing {
        private final String name;
        private final String value;

        ParamDescription(String name, String value) {
            this.name = name;
            this.value = value;
        }

        ParamDescription(String name, Matcher<String> expected) {
            this(name, expected.toString());
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.name).appendText(" = ").appendValue((Object)this.value);
        }
    }
}

