/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import wtf.g4s8.rio.file.Buffers;
import wtf.g4s8.rio.file.ReadFlow;
import wtf.g4s8.rio.file.WriteGreed;
import wtf.g4s8.rio.file.WriteSubscriber;

public final class File {
    private static final ExecutorService EXEC_DEFAULT = Executors.newCachedThreadPool();
    private final Path path;

    public File(Path path) {
        this.path = path;
    }

    public Publisher<ByteBuffer> content() {
        return this.content(Buffers.Standard.K8);
    }

    public Publisher<ByteBuffer> content(Buffers buf) {
        return this.content(buf, EXEC_DEFAULT);
    }

    public Publisher<ByteBuffer> content(ExecutorService exec) {
        return new ReadFlow(this.path, Buffers.Standard.K8, exec);
    }

    public Publisher<ByteBuffer> content(Buffers buf, ExecutorService exec) {
        return new ReadFlow(this.path, buf, exec);
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data, OpenOption ... opts) {
        return this.write(data, WriteGreed.SYSTEM, opts);
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data, ExecutorService exec, OpenOption ... opts) {
        return this.write(data, WriteGreed.SYSTEM, exec, opts);
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data, WriteGreed greed, OpenOption ... opts) {
        return this.write(data, greed, EXEC_DEFAULT, opts);
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data, WriteGreed greed, ExecutorService exec, OpenOption ... opts) {
        WriteSubscriber sub;
        try {
            sub = new WriteSubscriber(FileChannel.open(this.path, new HashSet<OpenOption>(Arrays.asList(File.writeOpts(opts))), new FileAttribute[0]), greed, exec);
        }
        catch (IOException err) {
            CompletableFuture<Void> res = new CompletableFuture<Void>();
            res.completeExceptionally(err);
            return res;
        }
        data.subscribe((Subscriber)sub);
        return sub;
    }

    private static OpenOption[] writeOpts(OpenOption[] src) {
        OpenOption[] opts = src.length == 0 ? new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE} : src;
        return opts;
    }
}

