/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import wtf.g4s8.rio.file.Buffers;
import wtf.g4s8.rio.file.ReadSubscriberState;
import wtf.g4s8.rio.file.ReadSubscription;
import wtf.g4s8.rio.file.ReadTaskQueue;

final class ReadFlow
implements Publisher<ByteBuffer> {
    private static final Subscription DUMMY = new Subscription(){

        public void request(long count) {
        }

        public void cancel() {
        }
    };
    private final Path path;
    private final Buffers buffers;
    private final ExecutorService exec;

    ReadFlow(Path path, Buffers buffers, ExecutorService exec) {
        this.buffers = buffers;
        this.path = path;
        this.exec = exec;
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        FileChannel chan;
        Objects.requireNonNull(subscriber, "Subscriber can't be null");
        try {
            chan = FileChannel.open(this.path, StandardOpenOption.READ);
        }
        catch (IOException err) {
            subscriber.onSubscribe(DUMMY);
            subscriber.onError((Throwable)err);
            return;
        }
        ReadSubscriberState<? super ByteBuffer> wrap = new ReadSubscriberState<ByteBuffer>(subscriber);
        wrap.onSubscribe(new ReadSubscription(wrap, this.buffers, new ReadTaskQueue(wrap, chan, this.exec)));
    }
}

