/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import wtf.g4s8.rio.file.Buffers;
import wtf.g4s8.rio.file.ReadSubscriberState;

abstract class ReadRequest {
    protected final ReadSubscriberState<? super ByteBuffer> sub;

    private ReadRequest(ReadSubscriberState<? super ByteBuffer> sub) {
        this.sub = sub;
    }

    abstract void process(FileChannel var1);

    static final class Next
    extends ReadRequest {
        private final Buffers buffers;
        private final long count;

        Next(ReadSubscriberState<? super ByteBuffer> sub, Buffers buffers, long count) {
            super(sub);
            this.buffers = buffers;
            this.count = count;
        }

        @Override
        void process(FileChannel channel) {
            int i = 0;
            while ((long)i < this.count) {
                int read;
                if (this.sub.done()) {
                    return;
                }
                ByteBuffer buf = this.buffers.create();
                try {
                    read = channel.read(buf);
                }
                catch (IOException iex) {
                    try {
                        channel.close();
                    }
                    catch (IOException cex) {
                        Logger.warn((Object)this, (String)"Failed to close channel on errors: %[exception]s", (Object[])new Object[]{cex});
                    }
                    this.sub.onError(iex);
                    return;
                }
                ((Buffer)buf).flip();
                if (read >= 0) {
                    try {
                        this.sub.onNext(buf);
                    }
                    catch (Exception exx) {
                        try {
                            channel.close();
                        }
                        catch (IOException cex) {
                            Logger.warn((Object)this, (String)"Failed to close channel on next error: %[exception]s", (Object[])new Object[]{cex});
                        }
                        this.sub.onError(exx);
                        return;
                    }
                }
                try {
                    channel.close();
                    this.sub.onComplete();
                }
                catch (IOException iex) {
                    this.sub.onError(iex);
                }
                return;
                ++i;
            }
        }
    }
}

