/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscription;
import wtf.g4s8.rio.file.Buffers;
import wtf.g4s8.rio.file.ReadRequest;
import wtf.g4s8.rio.file.ReadSubscriberState;
import wtf.g4s8.rio.file.ReadTaskQueue;

final class ReadSubscription
implements Subscription {
    private final ReadSubscriberState<? super ByteBuffer> sub;
    private final Buffers buffers;
    private final ReadTaskQueue queue;

    ReadSubscription(ReadSubscriberState<? super ByteBuffer> sub, Buffers buffers, ReadTaskQueue queue) {
        this.sub = sub;
        this.buffers = buffers;
        this.queue = queue;
    }

    public void request(long count) {
        if (this.sub.done()) {
            return;
        }
        if (count <= 0L) {
            this.queue.clear();
            this.sub.onError(new IllegalArgumentException(String.format("Requested %d items", count)));
            return;
        }
        this.queue.accept(new ReadRequest.Next(this.sub, this.buffers, count));
    }

    public void cancel() {
        this.sub.cancel();
        this.queue.clear();
    }
}

