/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import wtf.g4s8.rio.file.CloseChanOnError;
import wtf.g4s8.rio.file.ErrorOnException;
import wtf.g4s8.rio.file.ReadRequest;
import wtf.g4s8.rio.file.ReadSubscriberState;

public final class ReadTaskQueue
implements Runnable {
    private final Queue<ReadRequest> queue;
    private final ReadSubscriberState<? super ByteBuffer> sub;
    private final FileChannel channel;
    private final Executor exec;
    private final AtomicBoolean running = new AtomicBoolean();

    public ReadTaskQueue(ReadSubscriberState<? super ByteBuffer> sub, FileChannel channel, Executor exec) {
        this.queue = new ConcurrentLinkedQueue<ReadRequest>();
        this.sub = sub;
        this.exec = exec;
        this.channel = channel;
    }

    @Override
    public void run() {
        while (!this.sub.done()) {
            boolean empty;
            ReadRequest next = this.queue.poll();
            boolean bl = empty = next == null;
            if (empty) {
                this.running.set(false);
                next = this.queue.peek();
                boolean bl2 = empty = next == null;
                if (!empty && this.running.compareAndSet(false, true)) {
                    if (this.sub.done()) break;
                    this.queue.remove(next);
                } else {
                    return;
                }
            }
            next.process(this.channel);
        }
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException err) {
                Logger.warn((Object)this, (String)"Failed to close channel: %[exception]s", (Object[])new Object[]{err});
            }
        }
    }

    public void accept(ReadRequest request) {
        if (this.sub.done()) {
            return;
        }
        this.queue.add(request);
        if (this.running.compareAndSet(false, true)) {
            this.exec.execute(new ErrorOnException(new CloseChanOnError(this, this.channel), this.sub));
        }
    }

    public void clear() {
        this.queue.clear();
    }
}

