/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

public interface WriteGreed {
    public static final WriteGreed SINGLE = new Constant(1L, 0L);
    public static final WriteGreed SYSTEM = new Constant(Long.getLong("rio.file.write.greed.amount", 3L), Long.getLong("rio.file.write.greed.shift", 1L));

    public boolean request(Subscription var1);

    public static final class Constant
    implements WriteGreed {
        private final long amount;
        private final long shift;
        private final AtomicLong cnt;

        public Constant(long amount, long shift) {
            if (shift >= amount) {
                throw new IllegalArgumentException("Shift should be less than amount");
            }
            this.amount = amount;
            this.shift = shift;
            this.cnt = new AtomicLong();
        }

        @Override
        public boolean request(Subscription sub) {
            long pos = this.cnt.updateAndGet(prev -> prev <= this.shift ? this.amount : prev);
            if (pos == this.amount) {
                sub.request(this.amount);
                return true;
            }
            this.cnt.decrementAndGet();
            return false;
        }
    }
}

