/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;

abstract class WriteRequest {
    protected final CompletableFuture<Void> future;

    private WriteRequest(CompletableFuture<Void> future) {
        this.future = future;
    }

    abstract void process(FileChannel var1);

    public static final class Init
    extends WriteRequest {
        public Init(CompletableFuture<Void> future) {
            super(future);
        }

        @Override
        void process(FileChannel chan) {
        }
    }

    static final class Error
    extends WriteRequest {
        private final Throwable err;

        public Error(CompletableFuture<Void> future, Throwable err) {
            super(future);
            this.err = err;
        }

        @Override
        void process(FileChannel chan) {
            try {
                chan.close();
            }
            catch (IOException cex) {
                Logger.warn((Object)this, (String)"Failed to close channel on error: %[exception]s", (Object[])new Object[]{cex});
            }
            this.future.completeExceptionally(this.err);
        }

        public String toString() {
            return String.format("Error: %s", this.err.getMessage());
        }
    }

    static final class Complete
    extends WriteRequest {
        public Complete(CompletableFuture<Void> future) {
            super(future);
        }

        @Override
        public void process(FileChannel chan) {
            try {
                chan.close();
            }
            catch (IOException iex) {
                this.future.completeExceptionally(iex);
                return;
            }
            this.future.complete(null);
        }

        public String toString() {
            return "Complete";
        }
    }

    static final class Next
    extends WriteRequest {
        private final ByteBuffer target;

        public Next(CompletableFuture<Void> future, ByteBuffer target) {
            super(future);
            this.target = target;
        }

        @Override
        public void process(FileChannel chan) {
            while (this.target.hasRemaining()) {
                try {
                    chan.write(this.target);
                }
                catch (IOException iex) {
                    try {
                        chan.close();
                    }
                    catch (IOException cex) {
                        Logger.warn((Object)this, (String)"Failed to close channel on next failure: %[exception]s", (Object[])new Object[]{cex});
                    }
                    this.future.completeExceptionally(iex);
                    return;
                }
            }
        }

        public String toString() {
            return String.format("Write next %s", this.target);
        }
    }
}

