/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import wtf.g4s8.rio.file.WriteGreed;
import wtf.g4s8.rio.file.WriteRequest;
import wtf.g4s8.rio.file.WriteTaskQueue;

final class WriteSubscriber
extends CompletableFuture<Void>
implements Subscriber<ByteBuffer> {
    private final FileChannel chan;
    private final AtomicReference<Subscription> sub;
    private final ExecutorService exec;
    private final WriteGreed greed;
    private WriteTaskQueue queue;

    WriteSubscriber(FileChannel chan, WriteGreed greed, ExecutorService exec) {
        this.chan = chan;
        this.sub = new AtomicReference();
        this.exec = exec;
        this.greed = greed;
    }

    public void onSubscribe(Subscription subscription) {
        if (!this.sub.compareAndSet(null, Objects.requireNonNull(subscription))) {
            subscription.cancel();
            return;
        }
        if (this.isCancelled()) {
            subscription.cancel();
        } else {
            this.queue = new WriteTaskQueue(this, this.chan, this.sub, this.greed, this.exec);
            this.queue.accept(new WriteRequest.Init(this));
        }
    }

    public void onNext(ByteBuffer buf) {
        this.queue.accept(new WriteRequest.Next((CompletableFuture<Void>)this, Objects.requireNonNull(buf)));
    }

    public void onError(Throwable err) {
        this.queue.accept(new WriteRequest.Error((CompletableFuture<Void>)this, Objects.requireNonNull(err)));
    }

    public void onComplete() {
        this.queue.accept(new WriteRequest.Complete(this));
    }
}

